/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.lsb;

import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.lsb.LSBDataHeader;
import com.openstego.desktop.util.ImageHolder;
import java.io.IOException;
import java.io.InputStream;

public class LSBInputStream
extends InputStream {
    private ImageHolder image = null;
    private LSBDataHeader dataHeader = null;
    private int channelBitsUsed = 1;
    private int x = 0;
    private int y = 0;
    private int currBit = 0;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private OpenStegoConfig config = null;

    public LSBInputStream(ImageHolder image, OpenStegoConfig config) throws OpenStegoException {
        if (image == null || image.getImage() == null) {
            throw new OpenStegoException(null, "LSB", 2);
        }
        this.image = image;
        this.channelBitsUsed = 1;
        this.config = config;
        this.imgWidth = image.getImage().getWidth();
        this.imgHeight = image.getImage().getHeight();
        this.readHeader();
    }

    private void readHeader() throws OpenStegoException {
        this.dataHeader = new LSBDataHeader(this, this.config);
        this.channelBitsUsed = this.dataHeader.getChannelBitsUsed();
        if (this.currBit != 0) {
            this.currBit = 0;
            ++this.x;
            if (this.x == this.imgWidth) {
                this.x = 0;
                ++this.y;
            }
        }
    }

    @Override
    public int read() throws IOException {
        int pixel = 0;
        byte[] bitSet = new byte[8];
        if (this.y == this.imgHeight) {
            return -1;
        }
        for (int i = 0; i < bitSet.length; ++i) {
            pixel = this.image.getImage().getRGB(this.x, this.y);
            bitSet[i] = this.getCurrBitFromPixel(pixel);
            ++this.currBit;
            if (this.currBit != 3 * this.channelBitsUsed) continue;
            this.currBit = 0;
            ++this.x;
            if (this.x != this.imgWidth) continue;
            this.x = 0;
            ++this.y;
            if (this.y != this.imgHeight) continue;
            return -1;
        }
        return (bitSet[0] << 7) + (bitSet[1] << 6) + (bitSet[2] << 5) + (bitSet[3] << 4) + (bitSet[4] << 3) + (bitSet[5] << 2) + (bitSet[6] << 1) + (bitSet[7] << 0);
    }

    public LSBDataHeader getDataHeader() {
        return this.dataHeader;
    }

    private byte getCurrBitFromPixel(int pixel) {
        int group = 0;
        int groupBit = 0;
        group = this.currBit / this.channelBitsUsed;
        groupBit = this.currBit % this.channelBitsUsed;
        return (byte)(pixel >> 16 - group * 8 >> this.channelBitsUsed - groupBit - 1 & 1);
    }
}

