/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.dwtdugad;

import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.dwtdugad.DWTDugadErrors;
import com.openstego.desktop.plugin.template.image.WMImagePluginTemplate;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.ImageUtil;
import com.openstego.desktop.util.LabelUtil;
import com.openstego.desktop.util.StringUtil;
import com.openstego.desktop.util.dwt.DWT;
import com.openstego.desktop.util.dwt.Image;
import com.openstego.desktop.util.dwt.ImageTree;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Random;

public class DWTDugadPlugin
extends WMImagePluginTemplate {
    private static LabelUtil labelUtil = LabelUtil.getInstance("DWTDUGAD");
    public static final String NAMESPACE = "DWTDUGAD";
    private static final String SIG_MARKER = "DGSG";
    private static final String WM_MARKER = "DGWM";

    public DWTDugadPlugin() {
        LabelUtil.addNamespace(NAMESPACE, "i18n.DWTDugadPluginLabels");
        new DWTDugadErrors();
    }

    @Override
    public String getName() {
        return "DWTDugad";
    }

    @Override
    public String getDescription() {
        return labelUtil.getString("plugin.description");
    }

    @Override
    public byte[] embedData(byte[] msg, String msgFileName, byte[] cover, String coverFileName, String stegoFileName) throws OpenStegoException {
        ImageHolder image = null;
        List<int[][]> yuv = null;
        DWT dwt = null;
        ImageTree dwtTree = null;
        ImageTree s = null;
        Signature sig = null;
        int[][] luminance = null;
        int imgType = 0;
        int cols = 0;
        int rows = 0;
        if (cover == null) {
            throw new OpenStegoException(null, NAMESPACE, 1);
        }
        image = ImageUtil.byteArrayToImage(cover, coverFileName);
        imgType = image.getImage().getType();
        cols = image.getImage().getWidth();
        rows = image.getImage().getHeight();
        yuv = ImageUtil.getYuvFromImage(image.getImage());
        luminance = yuv.get(0);
        sig = new Signature(msg);
        dwt = new DWT(cols, rows, sig.filterID, sig.decompositionLevel, sig.waveletFilterMethod);
        s = dwtTree = dwt.forwardDWT(luminance);
        for (int i = 0; i < sig.decompositionLevel; ++i) {
            this.wmSubBand(s.getHorizontal().getImage(), sig.watermark, sig.watermarkLength, sig.alpha, sig.castingThreshold);
            this.wmSubBand(s.getVertical().getImage(), sig.watermark, sig.watermarkLength, sig.alpha, sig.castingThreshold);
            this.wmSubBand(s.getDiagonal().getImage(), sig.watermark, sig.watermarkLength, sig.alpha, sig.castingThreshold);
            s = s.getCoarse();
        }
        dwt.inverseDWT(dwtTree, luminance);
        yuv.set(0, luminance);
        image.setImage(ImageUtil.getImageFromYuv(yuv, imgType));
        return ImageUtil.imageToByteArray(image, stegoFileName, this);
    }

    @Override
    public byte[] extractData(byte[] stegoData, String stegoFileName, byte[] origSigData) throws OpenStegoException {
        ImageHolder image = null;
        DWT dwt = null;
        ImageTree dwtTree = null;
        ImageTree s = null;
        Signature sig = null;
        int[][] luminance = null;
        int cols = 0;
        int rows = 0;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        Object[] vals = null;
        image = ImageUtil.byteArrayToImage(stegoData, stegoFileName);
        cols = image.getImage().getWidth();
        rows = image.getImage().getHeight();
        luminance = ImageUtil.getYuvFromImage(image.getImage()).get(0);
        sig = new Signature(origSigData);
        dwt = new DWT(cols, rows, sig.filterID, sig.decompositionLevel, sig.waveletFilterMethod);
        s = dwtTree = dwt.forwardDWT(luminance);
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeBytes(WM_MARKER);
            oos.writeInt(sig.decompositionLevel);
            oos.writeDouble(sig.alpha);
            for (int i = 0; i < sig.decompositionLevel; ++i) {
                vals = this.invWmSubBand(s.getHorizontal().getImage(), sig.watermark, sig.watermarkLength, sig.detectionThreshold);
                oos.writeInt((Integer)vals[0]);
                oos.writeDouble((Double)vals[1]);
                oos.writeDouble((Double)vals[2]);
                vals = this.invWmSubBand(s.getVertical().getImage(), sig.watermark, sig.watermarkLength, sig.detectionThreshold);
                oos.writeInt((Integer)vals[0]);
                oos.writeDouble((Double)vals[1]);
                oos.writeDouble((Double)vals[2]);
                vals = this.invWmSubBand(s.getDiagonal().getImage(), sig.watermark, sig.watermarkLength, sig.detectionThreshold);
                oos.writeInt((Integer)vals[0]);
                oos.writeDouble((Double)vals[1]);
                oos.writeDouble((Double)vals[2]);
                s = s.getCoarse();
            }
            oos.flush();
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
    }

    @Override
    public byte[] generateSignature() throws OpenStegoException {
        Random rand = null;
        Signature sig = null;
        rand = new Random(StringUtil.passwordHash(this.config.getPassword()));
        sig = new Signature(rand);
        return sig.getSigData();
    }

    @Override
    public double getWatermarkCorrelation(byte[] origSigData, byte[] watermarkData) throws OpenStegoException {
        int n;
        ObjectInputStream ois = null;
        byte[] markArr = new byte[WM_MARKER.length()];
        int ok = 0;
        int m = 0;
        double z = 0.0;
        double v = 0.0;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(watermarkData));
            ois.read(markArr, 0, WM_MARKER.length());
            if (!WM_MARKER.equals(new String(markArr))) {
                throw new OpenStegoException(null, NAMESPACE, 2);
            }
            int level = ois.readInt();
            double alpha = ois.readDouble();
            n = level * 3;
            for (int i = 0; i < level; ++i) {
                m = ois.readInt();
                z = ois.readDouble();
                v = ois.readDouble();
                if (m != 0) {
                    ok += z > v * alpha / 1.0 ? 1 : 0;
                } else {
                    --n;
                }
                m = ois.readInt();
                z = ois.readDouble();
                v = ois.readDouble();
                if (m != 0) {
                    ok += z > v * alpha / 1.0 ? 1 : 0;
                } else {
                    --n;
                }
                m = ois.readInt();
                z = ois.readDouble();
                v = ois.readDouble();
                if (m != 0) {
                    ok += z > v * alpha / 1.0 ? 1 : 0;
                    continue;
                }
                --n;
            }
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
        return (double)ok / (double)n;
    }

    @Override
    public String getUsage() throws OpenStegoException {
        return labelUtil.getString("plugin.usage");
    }

    private void wmSubBand(Image img, double[] wm, int n, double a, double threshold) {
        for (int i = 0; i < img.getWidth() * img.getHeight(); ++i) {
            if (!(Math.abs(img.getData()[i]) > threshold)) continue;
            double[] dArray = img.getData();
            int n2 = i;
            dArray[n2] = dArray[n2] + a * Math.abs(img.getData()[i]) * wm[i % n];
        }
    }

    private Object[] invWmSubBand(Image img, double[] wm, int n, double threshold) {
        int m = 0;
        double z = 0.0;
        double v = 0.0;
        for (int i = 0; i < img.getWidth() * img.getHeight(); ++i) {
            if (!(img.getData()[i] > threshold)) continue;
            z += img.getData()[i] * wm[i % n];
            v += Math.abs(img.getData()[i]);
            ++m;
        }
        return new Object[]{m, z, v};
    }

    private class Signature {
        byte[] sig = "DGSG".getBytes();
        int watermarkLength = 1000;
        int waveletFilterMethod = 2;
        int filterID = 1;
        int decompositionLevel = 3;
        double alpha = 0.2;
        double castingThreshold = 40.0;
        double detectionThreshold = 50.0;
        double[] watermark = null;

        public Signature(Random rand) {
            this.watermark = new double[this.watermarkLength];
            for (int i = 0; i < this.watermarkLength; i += 2) {
                double x2;
                double x1;
                double x;
                while ((x = (x1 = 2.0 * rand.nextDouble() - 1.0) * x1 + (x2 = 2.0 * rand.nextDouble() - 1.0) * x2) >= 1.0) {
                }
                this.watermark[i] = x1 *= Math.sqrt(-2.0 * Math.log(x) / x);
                this.watermark[i + 1] = x2 *= Math.sqrt(-2.0 * Math.log(x) / x);
            }
        }

        public Signature(byte[] sigData) throws OpenStegoException {
            ObjectInputStream ois = null;
            byte[] inputSig = new byte[this.sig.length];
            try {
                ois = new ObjectInputStream(new ByteArrayInputStream(sigData));
                ois.read(inputSig, 0, this.sig.length);
                if (!new String(this.sig).equals(new String(inputSig))) {
                    throw new OpenStegoException(null, DWTDugadPlugin.NAMESPACE, 2);
                }
                this.watermarkLength = ois.readInt();
                this.waveletFilterMethod = ois.readInt();
                this.filterID = ois.readInt();
                this.decompositionLevel = ois.readInt();
                this.alpha = ois.readDouble();
                this.castingThreshold = ois.readDouble();
                this.detectionThreshold = ois.readDouble();
                this.watermark = new double[this.watermarkLength];
                for (int i = 0; i < this.watermarkLength; ++i) {
                    this.watermark[i] = ois.readDouble();
                }
            }
            catch (IOException ioEx) {
                throw new OpenStegoException(ioEx);
            }
        }

        public byte[] getSigData() throws OpenStegoException {
            ByteArrayOutputStream baos = null;
            ObjectOutputStream oos = null;
            try {
                baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                oos.write(this.sig);
                oos.writeInt(this.watermarkLength);
                oos.writeInt(this.waveletFilterMethod);
                oos.writeInt(this.filterID);
                oos.writeInt(this.decompositionLevel);
                oos.writeDouble(this.alpha);
                oos.writeDouble(this.castingThreshold);
                oos.writeDouble(this.detectionThreshold);
                for (int i = 0; i < this.watermarkLength; ++i) {
                    oos.writeDouble(this.watermark[i]);
                }
                oos.flush();
                oos.close();
                return baos.toByteArray();
            }
            catch (IOException ioEx) {
                throw new OpenStegoException(ioEx);
            }
        }
    }
}

