/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;

public final class SetStatement
implements Statement {
    private final List<NameExpr> values = new ArrayList<NameExpr>();

    public SetStatement(String name, Expression expression) {
        this.add(name, expression, true);
    }

    public void add(String name, Expression expression, boolean useEqual) {
        this.values.add(new NameExpr(name, expression, useEqual));
    }

    public void remove(int idx) {
        this.values.remove(idx);
    }

    public int getCount() {
        return this.values.size();
    }

    public boolean isUseEqual(int idx) {
        return this.values.get(idx).useEqual;
    }

    public boolean isUseEqual() {
        return this.isUseEqual(0);
    }

    public SetStatement setUseEqual(int idx, boolean useEqual) {
        this.values.get(idx).useEqual = useEqual;
        return this;
    }

    public SetStatement setUseEqual(boolean useEqual) {
        return this.setUseEqual(0, useEqual);
    }

    public String getName() {
        return this.getName(0);
    }

    public String getName(int idx) {
        return this.values.get(idx).name;
    }

    public void setName(String name) {
        this.setName(0, name);
    }

    public void setName(int idx, String name) {
        this.values.get(idx).name = name;
    }

    public Expression getExpression(int idx) {
        return this.values.get(idx).expression;
    }

    public Expression getExpression() {
        return this.getExpression(0);
    }

    public void setExpression(int idx, Expression expression) {
        this.values.get(idx).expression = expression;
    }

    public void setExpression(Expression expression) {
        this.setExpression(0, expression);
    }

    private String toString(NameExpr ne) {
        return ne.name + (ne.useEqual ? " = " : " ") + ne.expression.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("SET ");
        for (NameExpr ne : this.values) {
            if (b.length() != 4) {
                b.append(", ");
            }
            b.append(this.toString(ne));
        }
        return b.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    static class NameExpr {
        private String name;
        private Expression expression;
        private boolean useEqual;

        public NameExpr(String name, Expression expr, boolean useEqual) {
            this.name = name;
            this.expression = expr;
            this.useEqual = useEqual;
        }
    }
}

