/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.squirrel_sql.fw.util.ClassLoaderListener;
import net.sourceforge.squirrel_sql.fw.util.EnumerationIterator;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;

public class MyURLClassLoader
extends URLClassLoader {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MyURLClassLoader.class);
    private Map<String, Class> _classes = new HashMap<String, Class>();
    ArrayList<ClassLoaderListener> listeners = new ArrayList();

    public MyURLClassLoader(String fileName) throws IOException {
        this(new File(fileName).toURI().toURL());
    }

    public MyURLClassLoader(URL url) {
        this(new URL[]{url});
    }

    public MyURLClassLoader(URL[] urls) {
        super(urls, ClassLoader.getSystemClassLoader());
    }

    public void addClassLoaderListener(ClassLoaderListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void notifyListenersLoadedZipFile(String filename) {
        for (ClassLoaderListener listener : this.listeners) {
            listener.loadedZipFile(filename);
        }
    }

    private void notifyListenersFinished() {
        for (ClassLoaderListener listener : this.listeners) {
            listener.finishedLoadingZipFiles();
        }
    }

    public void removeClassLoaderListener(ClassLoaderListener listener) {
        this.listeners.remove(listener);
    }

    public Class[] getAssignableClasses(Class type, ILogger logger) {
        ArrayList classes = new ArrayList();
        URL[] urls = this.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            File file = this.getFileFromUrl(logger, url);
            if (file == null || file.isDirectory() || !file.exists() || !file.canRead()) continue;
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
            }
            catch (IOException ex) {
                Object[] args = new Object[]{file.getAbsolutePath()};
                String msg = s_stringMgr.getString("MyURLClassLoader.errorLoadingFile", args);
                logger.error(msg, ex);
                continue;
            }
            this.notifyListenersLoadedZipFile(file.getName());
            EnumerationIterator<? extends ZipEntry> it = new EnumerationIterator<ZipEntry>(zipFile.entries());
            while (it.hasNext()) {
                Class<?> cls;
                block6: {
                    cls = null;
                    String entryName = ((ZipEntry)it.next()).getName();
                    String className = Utilities.changeFileNameToClassName(entryName);
                    if (className == null) continue;
                    try {
                        cls = Class.forName(className, false, this);
                    }
                    catch (Throwable th) {
                        if (!logger.isInfoEnabled()) break block6;
                        Object[] args = new Object[]{className, file.getAbsolutePath(), type.getName(), th.toString()};
                        String msg = s_stringMgr.getString("MyURLClassLoader.noAssignCheck", args);
                        logger.info(msg);
                    }
                }
                if (cls == null || !type.isAssignableFrom(cls)) continue;
                classes.add(cls);
            }
        }
        this.notifyListenersFinished();
        return classes.toArray(new Class[classes.size()]);
    }

    private File getFileFromUrl(ILogger logger, URL url) {
        File file = null;
        try {
            URI fileUri = url.toURI();
            if (logger.isDebugEnabled()) {
                logger.debug("getFileFromUrl: fileUri.getPath()=" + fileUri.getPath());
            }
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            logger.error("getAssignableClasses: Unable to convert URL (" + url + ") to a URI:" + e.getMessage(), e);
        }
        return file;
    }

    protected synchronized Class findClass(String className) throws ClassNotFoundException {
        Class<?> cls = this._classes.get(className);
        if (cls == null) {
            cls = super.findClass(className);
            this._classes.put(className, cls);
        }
        return cls;
    }

    protected void classHasBeenLoaded(Class cls) {
    }
}

