/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IntegerIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.resources.LibraryResources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DatabaseObjectType
implements IHasIdentifier,
Serializable {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DatabaseObjectType.class);
    private static final IntegerIdentifierFactory s_idFactory = new IntegerIdentifierFactory();
    public static final DatabaseObjectType OTHER = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.other");
    public static final DatabaseObjectType BEST_ROW_ID = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.bestRowID");
    public static final DatabaseObjectType CATALOG = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.catalog", "dot.catalog");
    public static final DatabaseObjectType COLUMN = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.column");
    public static final DatabaseObjectType SESSION = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.database", "dot.database");
    public static final DatabaseObjectType DATABASE_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.DATABASE_TYPE_DBO", "dot.database");
    public static final DatabaseObjectType DATATYPE = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.datatype", "dot.datatype");
    public static final DatabaseObjectType PRIMARY_KEY = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.primarykey");
    public static final DatabaseObjectType FOREIGN_KEY = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.foreignkey");
    public static final DatabaseObjectType FUNCTION = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.function", "dot.function");
    public static final DatabaseObjectType INDEX_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.INDEX_TYPE_DBO", "dot.indexes", true);
    public static final DatabaseObjectType INDEX = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.index", "dot.index");
    public static final DatabaseObjectType PROCEDURE = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.storproc", "dot.procedure");
    public static final DatabaseObjectType PROC_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.PROC_TYPE_DBO", "dot.procedures", true);
    public static final DatabaseObjectType SCHEMA = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.schema", "dot.schema");
    public static final DatabaseObjectType SEQUENCE_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.SEQUENCE_TYPE_DBO", "dot.sequence");
    public static final DatabaseObjectType SEQUENCE = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.sequence", "dot.sequences", true);
    public static final DatabaseObjectType SYNONYM_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.SYNONYM_TYPE_DBO");
    public static final DatabaseObjectType SYNONYM = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.synonym");
    public static final DatabaseObjectType TABLE = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.table", "dot.table");
    public static final DatabaseObjectType TABLE_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.TABLE_TYPE_DBO", "dot.tables", true);
    public static final DatabaseObjectType VIEW = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.view", "dot.view");
    public static final DatabaseObjectType TRIGGER_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.TRIGGER_TYPE_DBO", "dot.triggers", true);
    public static final DatabaseObjectType TRIGGER = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.catalog", "dot.trigger");
    public static final DatabaseObjectType UDT = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.udt", "dot.datatype");
    public static final DatabaseObjectType UDT_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.UDT_TYPE_DBO", "dot.datatypes", true);
    public static final DatabaseObjectType UDF = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.udf");
    public static final DatabaseObjectType UDF_TYPE_DBO = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.UDF_TYPE_DBO");
    public static final DatabaseObjectType USER = DatabaseObjectType.createNewDatabaseObjectTypeI18n("DatabaseObjectType.user", "dot.user");
    private final IIdentifier _id;
    private final String _name;
    private String _keyForSerializationReplace;
    private Icon _icon;
    private boolean _isContainerNode;

    private DatabaseObjectType(String name, String keyForSerializationReplace, Icon icon) {
        this._keyForSerializationReplace = keyForSerializationReplace;
        this._icon = icon;
        this._id = s_idFactory.createIdentifier();
        this._name = name != null ? name : this._id.toString();
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getKeyForSerializationReplace() {
        return this._keyForSerializationReplace;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public String toString() {
        return this.getName();
    }

    private static DatabaseObjectType createNewDatabaseObjectTypeI18n(String key, String imageName) {
        return DatabaseObjectType.createNewDatabaseObjectTypeI18n(key, imageName, false);
    }

    private static DatabaseObjectType createNewDatabaseObjectTypeI18n(String key, String imageName, boolean isContainerNode) {
        ImageIcon icon = null;
        if (null != imageName) {
            icon = new LibraryResources().getIcon(imageName);
        }
        DatabaseObjectType ret = DatabaseObjectType.createNewDatabaseObjectType(s_stringMgr.getString(key), icon);
        ret.setContainerNode(isContainerNode);
        return ret;
    }

    private void setContainerNode(boolean isContainerNode) {
        this._isContainerNode = isContainerNode;
    }

    public boolean isContainerNode() {
        return this._isContainerNode;
    }

    private static DatabaseObjectType createNewDatabaseObjectTypeI18n(String key) {
        return DatabaseObjectType.createNewDatabaseObjectTypeI18n(key, null);
    }

    public static DatabaseObjectType createNewDatabaseObjectType(String key) {
        return DatabaseObjectType.createNewDatabaseObjectType(key, null);
    }

    public static DatabaseObjectType createNewDatabaseObjectType(String key, Icon icon) {
        return new DatabaseObjectType(key, key, icon);
    }
}

