/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.props;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class StringInterpreter {
    public static <T> T interpret(String value, Class<T> clazz, T defaultValue) {
        return StringInterpreter.interpret(value, clazz, defaultValue, false);
    }

    public static <T> T interpret(String value, Class<T> clazz, T defaultValue, boolean allowWhiteSpacesOnly) {
        try {
            return (T)StringInterpreter._interpret(value, clazz, defaultValue, allowWhiteSpacesOnly);
        }
        catch (NumberFormatException | ParseException e) {
            return defaultValue;
        }
    }

    private static Object _interpret(String value, Class clazz, Object defaultValue, boolean allowWhiteSpacesOnly) throws ParseException {
        if (StringUtilities.isEmpty(value, false == allowWhiteSpacesOnly)) {
            return defaultValue;
        }
        if (String.class.equals((Object)clazz)) {
            return value;
        }
        if (Integer.class.equals((Object)clazz)) {
            return Integer.valueOf(value);
        }
        if (Long.class.equals((Object)clazz)) {
            return Integer.valueOf(value);
        }
        if (BigInteger.class.equals((Object)clazz)) {
            return new BigInteger(value);
        }
        if (Short.class.equals((Object)clazz)) {
            return Short.valueOf(value);
        }
        if (Boolean.class.equals((Object)clazz)) {
            try {
                Integer intVal = Integer.valueOf(value);
                return !intVal.equals(0);
            }
            catch (NumberFormatException intVal) {
                return Boolean.valueOf(value);
            }
        }
        if (Byte.class.equals((Object)clazz)) {
            return Byte.valueOf(value);
        }
        if (Character.class.equals((Object)clazz)) {
            return Character.valueOf(value.charAt(0));
        }
        if (Timestamp.class.equals((Object)clazz)) {
            String pattern = "yyyy-MM-dd HH:mm:ss";
            String buf = value.trim().substring(0, pattern.length());
            return new Timestamp(new SimpleDateFormat(pattern).parse(buf).getTime());
        }
        if (Time.class.equals((Object)clazz)) {
            String pattern = "HH:mm:ss";
            String buf = value.trim().substring(0, pattern.length());
            return new Time(new SimpleDateFormat(pattern).parse(buf).getTime());
        }
        if (Date.class.equals((Object)clazz)) {
            String pattern = "yyyy-MM-dd";
            String buf = value.trim().substring(0, pattern.length());
            return new Date(new SimpleDateFormat(pattern).parse(buf).getTime());
        }
        if (Float.class.equals((Object)clazz)) {
            return Float.valueOf(value);
        }
        if (Double.class.equals((Object)clazz)) {
            return Double.valueOf(value);
        }
        if (BigDecimal.class.equals((Object)clazz)) {
            return new BigDecimal(value);
        }
        return value;
    }
}

