/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.buttonchooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonHolder;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonSelectedListener;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ComboButton;

public class ButtonChooser
extends JPanel {
    private JButton _btnUndefinedDefault;
    private ComboButton _btnCombo = new ComboButton();
    private AbstractButton _btnCurrent;
    private List<ButtonHolder> _buttons = new ArrayList<ButtonHolder>();
    private ButtonSelectedListener _buttonSelectedListener;

    public ButtonChooser() {
        super(new GridBagLayout());
        this.createUI();
        this.initListeners();
    }

    private void initListeners() {
        this._btnCombo.addActionListener(e -> this.onShowPopup());
    }

    private void onShowPopup() {
        JPopupMenu comboPopUp = new JPopupMenu();
        for (ButtonHolder buttonHolder : this._buttons) {
            JMenuItem mnu = new JMenuItem(buttonHolder.getText(), buttonHolder.getBtn().getIcon());
            mnu.setToolTipText(buttonHolder.getBtn().getToolTipText());
            mnu.addActionListener(e -> this.displayAsCurrentButton(buttonHolder.getBtn()));
            comboPopUp.add(mnu);
        }
        comboPopUp.show(this._btnCurrent, 0, this._btnCurrent.getHeight());
    }

    private void createUI() {
        SquirrelResources rsrc = Main.getApplication().getResources();
        ImageIcon iconUndefined = rsrc.getIcon("undefined");
        this._btnUndefinedDefault = new JButton(iconUndefined);
        this._btnUndefinedDefault.setToolTipText("There were no buttons added???");
        this.displayAsCurrentButton(this._btnUndefinedDefault);
        GridBagConstraints gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 2), 1, 1);
        this.add((Component)this._btnCombo, gbc);
        GUIUtils.styleAsToolbarButton(this._btnCombo);
        this._btnCombo.setPreferredSize(new Dimension(12, 28));
        this._btnCombo.setMinimumSize(new Dimension(12, 28));
        this.setPreferredSize(new Dimension(38, 28));
        this.setMaximumSize(new Dimension(38, 28));
    }

    public void addButton(AbstractButton btn) {
        this._buttons.add(new ButtonHolder(btn));
        if (this._btnCurrent == this._btnUndefinedDefault) {
            this.setSelectedButton(btn);
        }
    }

    public void setSelectedButton(AbstractButton btn) {
        if (!this._buttons.stream().filter(bh -> bh.getBtn() == btn).findFirst().isPresent()) {
            throw new IllegalStateException("Button must be added before being selected");
        }
        this.displayAsCurrentButton(btn);
    }

    private void displayAsCurrentButton(AbstractButton btn) {
        AbstractButton formerSelectedButton = this._btnCurrent;
        if (null != this._btnCurrent) {
            this.remove(this._btnCurrent);
        }
        this._btnCurrent = btn;
        GUIUtils.styleAsToolbarButton(this._btnCurrent, true);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 1, 1);
        this.add((Component)this._btnCurrent, gbc);
        this.revalidate();
        this.repaint();
        if (null != this._buttonSelectedListener) {
            this._buttonSelectedListener.buttonSelected(this._btnCurrent, formerSelectedButton);
        }
    }

    public void setButtonSelectedListener(ButtonSelectedListener buttonSelectedListener) {
        this._buttonSelectedListener = buttonSelectedListener;
    }

    public void setChooserEnabled(boolean b) {
        this._btnCombo.setEnabled(b);
        this._btnCurrent.setEnabled(b);
    }

    public AbstractButton getSelectedButton() {
        return this._btnCurrent;
    }

    public List<AbstractButton> getAllButtons() {
        return this._buttons.stream().map(bh -> bh.getBtn()).collect(Collectors.toList());
    }
}

