/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.exportData;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.AbstractDataExportFileWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportDataCell;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class DataExportExcelWriter
extends AbstractDataExportFileWriter {
    private Workbook workbook;
    private Sheet sheet;
    private File file;
    private boolean withHeader = false;
    private HashMap<String, CellStyle> formatCache = null;

    public DataExportExcelWriter(File file, TableExportPreferences prefs, ProgressAbortCallback progressController) {
        super(file, prefs, progressController);
    }

    private Cell getXlsCell(ColumnDisplayDefinition colDef, int colIdx, int curRow, Object cellObj) {
        Row row = this.sheet.getRow(curRow);
        if (row == null) {
            row = this.sheet.createRow(curRow);
        }
        Cell retVal = row.createCell(colIdx);
        if (null == cellObj || null == colDef) {
            retVal.setCellValue(this.getDataXLSAsString(cellObj));
            return retVal;
        }
        int colType = colDef.getSqlType();
        switch (colType) {
            case -7: 
            case 16: {
                retVal.setCellValue(((Boolean)cellObj).booleanValue());
                break;
            }
            case 4: {
                retVal.setCellValue((double)((Number)cellObj).intValue());
                break;
            }
            case -6: 
            case 5: {
                retVal.setCellValue((double)((Number)cellObj).shortValue());
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                retVal.setCellValue(((Number)cellObj).doubleValue());
                break;
            }
            case -5: {
                retVal.setCellValue((double)Long.parseLong(cellObj.toString()));
                break;
            }
            case 91: {
                this.makeTemporalCell(retVal, (Date)cellObj, "m/d/yy");
                break;
            }
            case 93: {
                this.makeTemporalCell(retVal, (Date)cellObj, "m/d/yy h:mm");
                break;
            }
            case 92: {
                this.makeTemporalCell(retVal, (Date)cellObj, "h:mm");
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                cellObj = CellComponentFactory.renderObject(cellObj, colDef);
                retVal.setCellValue(this.getDataXLSAsString(cellObj));
                break;
            }
            default: {
                cellObj = CellComponentFactory.renderObject(cellObj, colDef);
                retVal.setCellValue(this.getDataXLSAsString(cellObj));
            }
        }
        return retVal;
    }

    private void makeTemporalCell(Cell retVal, Date cellObj, String format) {
        CellStyle cellStyle;
        CreationHelper creationHelper = this.workbook.getCreationHelper();
        if (this.formatCache == null) {
            cellStyle = this.workbook.createCellStyle();
            cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(format));
            this.formatCache = new HashMap();
            this.formatCache.put(format, cellStyle);
        } else {
            cellStyle = this.formatCache.get(format);
            if (cellStyle == null) {
                cellStyle = this.workbook.createCellStyle();
                cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(format));
                this.formatCache.put(format, cellStyle);
            }
        }
        retVal.setCellStyle(cellStyle);
        if (null != cellObj) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(cellObj);
            retVal.setCellValue(calendar);
        }
    }

    private String getDataXLSAsString(Object cellObj) {
        if (cellObj == null) {
            return "";
        }
        return cellObj.toString().trim();
    }

    @Override
    protected void beforeWorking(File file) throws IOException {
        this.workbook = this.getPrefs().isFormatXLSOld() ? new HSSFWorkbook() : new SXSSFWorkbook(100);
        this.file = file;
        this.sheet = this.workbook.createSheet("Squirrel SQL Export");
    }

    @Override
    protected void addHeaderCell(int colIdx, String columnName) throws Exception {
        this.withHeader = true;
        Row headerRow = this.sheet.getRow(0);
        if (headerRow == null) {
            headerRow = this.sheet.createRow(0);
        }
        Cell cell = headerRow.createCell(colIdx);
        cell.setCellValue(columnName);
    }

    @Override
    protected void addCell(IExportDataCell cell) throws Exception {
        if (this.getPrefs().isUseGlobalPrefsFormating()) {
            this.getXlsCell(cell.getColumnDisplayDefinition(), cell.getColumnIndex(), this.calculateRowIdx(cell), cell.getObject());
        } else {
            this.getXlsCell(null, cell.getColumnIndex(), this.calculateRowIdx(cell), cell.getObject());
        }
    }

    private int calculateRowIdx(IExportDataCell cell) {
        if (this.withHeader) {
            return cell.getRowIndex() + 1;
        }
        return cell.getRowIndex();
    }

    @Override
    protected void afterWorking() throws Exception {
        FileOutputStream out = new FileOutputStream(this.file);
        this.workbook.write((OutputStream)out);
        out.close();
        if (this.workbook instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook)this.workbook).dispose();
        }
    }
}

