/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.util.codereformat;

import net.sourceforge.squirrel_sql.client.util.codereformat.Piece;
import net.sourceforge.squirrel_sql.client.util.codereformat.PieceMarkerSpec;
import net.sourceforge.squirrel_sql.client.util.codereformat.StateOfPosition;

public class TopLevelPiecesIterator {
    private final PieceMarkerSpec[] _pieceSpecs;
    private StateOfPosition[] _statesOfPosition;
    private final boolean _lineBreakFor_AND_OR_in_FROM_clause;
    private boolean _in_FROM_Clause;

    public TopLevelPiecesIterator(PieceMarkerSpec[] pieceSpecs, StateOfPosition[] statesOfPosition, boolean lineBreakFor_AND_OR_in_FROM_clause) {
        this._pieceSpecs = pieceSpecs;
        this._statesOfPosition = statesOfPosition;
        this._lineBreakFor_AND_OR_in_FROM_clause = lineBreakFor_AND_OR_in_FROM_clause;
    }

    public Piece getNextToplevelPiece(int startAt, String in) {
        Piece ret = new Piece();
        ret.beginsAt = in.length();
        for (int i = 0; i < this._pieceSpecs.length; ++i) {
            int buf;
            if (this.hasFromClauseLineBreakVeto(this._pieceSpecs[i]) || -1 >= (buf = this.getTopLevelIndex(startAt, in, this._pieceSpecs[i])) || buf >= ret.beginsAt) continue;
            ret.spec = this._pieceSpecs[i];
            ret.beginsAt = buf;
        }
        if (null == ret.spec) {
            ret.beginsAt = startAt;
        } else {
            if (ret.spec.is_FROM_begin()) {
                this._in_FROM_Clause = true;
            }
            if (ret.spec.is_FROM_end()) {
                this._in_FROM_Clause = false;
            }
        }
        return ret;
    }

    private int getTopLevelIndex(int startAt, String in, PieceMarkerSpec pieceSpec) {
        int ix = in.indexOf(pieceSpec.getPieceMarker(), startAt);
        while (-1 != ix) {
            if (this._statesOfPosition[ix].isTopLevel) {
                if (pieceSpec.needsSuroundingWhiteSpaces()) {
                    char after;
                    char before = 0 == ix ? (char)' ' : (char)in.charAt(ix - 1);
                    int pieceMArkerEnd = ix + pieceSpec.getPieceMarker().length() - 1;
                    char c = after = pieceMArkerEnd == in.length() - 1 ? (char)' ' : (char)in.charAt(pieceMArkerEnd + 1);
                    if (Character.isWhitespace(before) && Character.isWhitespace(after)) {
                        return ix;
                    }
                } else {
                    return ix;
                }
            }
            ix = in.indexOf(pieceSpec.getPieceMarker(), ix + 1);
        }
        return -1;
    }

    private boolean hasFromClauseLineBreakVeto(PieceMarkerSpec pieceMarkerSpec) {
        if (!this._in_FROM_Clause || !this._lineBreakFor_AND_OR_in_FROM_clause) {
            return false;
        }
        return pieceMarkerSpec.is_AND_or_OR() && 0 == pieceMarkerSpec.getType();
    }
}

