/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.schema.Table;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ErrorInfo;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.JSqlParserAdapter;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParseTerminateRequestCheck;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParseTerminateRequestException;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParsingFinishedListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParsingResult;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.StatementBounds;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.StatementBoundsPrediction;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.TableAliasInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableQualifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ParserThread {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ParserThread.class);
    private final ExecutorService _executorService;
    private ISession _session;
    private ParsingFinishedListener _parsingFinishedListener;
    private Future<?> _currentFuture;
    private ErrorInfo[] _errorInfos = new ErrorInfo[0];
    private TableAliasInfo[] _tableAliasInfos = new TableAliasInfo[0];
    private ParseTerminateRequestCheck _parseTerminateRequestCheck = () -> this.onCheckExitThreadRequested();
    private volatile boolean _exitThreadRequested = false;

    public ParserThread(ISession session) {
        this._session = session;
        this._executorService = Executors.newSingleThreadExecutor();
    }

    private void onCheckExitThreadRequested() {
        if (this._exitThreadRequested) {
            throw new ParseTerminateRequestException();
        }
    }

    public void setParsingFinishedListener(ParsingFinishedListener parsingFinishedListener) {
        this._parsingFinishedListener = parsingFinishedListener;
    }

    public void parseInBackground(String text) {
        if (this._exitThreadRequested || null != this._currentFuture && !this._currentFuture.isDone()) {
            return;
        }
        this._currentFuture = this._executorService.submit(() -> this.onParse(text));
    }

    private void onParse(String text) {
        block4: {
            try {
                try {
                    this._onParse(text);
                    this._parsingFinishedListener.parsingFinished();
                }
                catch (ParseTerminateRequestException e) {
                    System.out.println("################## FINISHED PARSING ON REQUEST #########################");
                }
            }
            catch (Throwable e) {
                if (null == this._parsingFinishedListener) break block4;
                this._parsingFinishedListener.parserExitedOnException(e);
            }
        }
    }

    private void _onParse(String text) throws ParseException {
        List<StatementBounds> statementBoundsList = StatementBoundsPrediction.getStatementBoundsList(text, this._parseTerminateRequestCheck);
        this._parseTerminateRequestCheck.check();
        ArrayList<ErrorInfo> errorInfos = new ArrayList<ErrorInfo>();
        ArrayList<TableAliasInfo> tableAliasInfos = new ArrayList<TableAliasInfo>();
        for (StatementBounds statementBounds : statementBoundsList) {
            this._parseTerminateRequestCheck.check();
            ParsingResult parsingResult = JSqlParserAdapter.executeParsing(statementBounds);
            this._parseTerminateRequestCheck.check();
            for (Table table : parsingResult.getTables()) {
                this._parseTerminateRequestCheck.check();
                TableQualifier tableQualifier = new TableQualifier(table.getFullyQualifiedName());
                ITableInfo[] tableInfos = this._session.getSchemaInfo().getITableInfos(tableQualifier.getCatalog(), tableQualifier.getSchema(), tableQualifier.getTableName());
                this._parseTerminateRequestCheck.check();
                if (0 == tableInfos.length) {
                    int beginPos = statementBounds.getBeginPos() + table.getASTNode().jjtGetFirstToken().absoluteBegin;
                    int endPos = statementBounds.getBeginPos() + table.getASTNode().jjtGetFirstToken().absoluteEnd;
                    errorInfos.add(new ErrorInfo(s_stringMgr.getString("parserthread.undefinedTable"), beginPos, endPos));
                    continue;
                }
                if (null == table.getAlias()) continue;
                tableAliasInfos.add(new TableAliasInfo(table.getAlias().getName(), table.getFullyQualifiedName(), statementBounds.getBeginPos()));
            }
            this._tableAliasInfos = tableAliasInfos.toArray(new TableAliasInfo[0]);
            for (ParseException parseError : parsingResult.getParseErrors()) {
                this._parseTerminateRequestCheck.check();
                int beginPos = statementBounds.getBeginPos() + parseError.currentToken.next.absoluteBegin;
                int endPos = statementBounds.getBeginPos() + parseError.currentToken.next.absoluteEnd;
                errorInfos.add(new ErrorInfo(parseError.getMessage(), beginPos, endPos));
            }
            this._errorInfos = errorInfos.toArray(new ErrorInfo[0]);
        }
    }

    public TableAliasInfo[] getTableAliasInfos() {
        return this._tableAliasInfos;
    }

    public ErrorInfo[] getErrorInfos() {
        return this._errorInfos;
    }

    public void exitThread() {
        this._exitThreadRequested = true;
    }
}

