/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.findcolumn;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.findcolumn.ColumnSortingEnum;
import net.sourceforge.squirrel_sql.client.session.mainpanel.findcolumn.FindColumnColWrapper;
import net.sourceforge.squirrel_sql.client.session.mainpanel.findcolumn.FindColumnDlg;
import net.sourceforge.squirrel_sql.client.session.mainpanel.findcolumn.TableNameAccess;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanelUtil;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.CloseByEscapeListener;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class FindColumnCtrl {
    public static final String PREF_KEY_FIND_COLUMN_SHEET_WIDTH = "Squirrel.findColumnSheet.width";
    public static final String PREF_KEY_FIND_COLUMN_SHEET_HEIGHT = "Squirrel.findColumnSheet.height";
    private final DataSetViewerTablePanel _dataSetViewerTablePanel;
    private final FindColumnDlg _findColumnDlg;
    private final DefaultListModel _leftListModel;
    private final DefaultListModel _rightListModel = new DefaultListModel();
    private ColumnSortingEnum _columnSorting = ColumnSortingEnum.NONE;
    private FindColumnColWrapper _columnToGoTo;
    private ArrayList<ExtTableColumn> _columnsToMoveToFront;
    private final boolean _dataSetContainsdifferentTables;

    public FindColumnCtrl(Frame owningFrame, DataSetViewerTablePanel dataSetViewerTablePanel) {
        this._dataSetContainsdifferentTables = this.dataSetContainsdifferentTables(dataSetViewerTablePanel);
        this._dataSetViewerTablePanel = dataSetViewerTablePanel;
        this._findColumnDlg = new FindColumnDlg(owningFrame);
        this._leftListModel = new DefaultListModel();
        this._findColumnDlg.lstLeft.setModel(this._leftListModel);
        this._findColumnDlg.lstLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FindColumnCtrl.this.onMouseClicked(e);
            }
        });
        this._findColumnDlg.lstRight.setModel(this._rightListModel);
        this._findColumnDlg.btnSortAsc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindColumnCtrl.this._columnSorting = ColumnSortingEnum.ASC;
                FindColumnCtrl.this.onFilterChanged();
            }
        });
        this._findColumnDlg.btnSortDesc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindColumnCtrl.this._columnSorting = ColumnSortingEnum.DESC;
                FindColumnCtrl.this.onFilterChanged();
            }
        });
        this._findColumnDlg.txtFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindColumnCtrl.this.onFilterChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindColumnCtrl.this.onFilterChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindColumnCtrl.this.onFilterChanged();
            }
        });
        this._findColumnDlg.btnRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindColumnCtrl.this.onMoveRight();
            }
        });
        this._findColumnDlg.btnLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindColumnCtrl.this.onMoveLeft();
            }
        });
        this._findColumnDlg.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindColumnCtrl.this.onMoveUp();
            }
        });
        this._findColumnDlg.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindColumnCtrl.this.onMoveDown();
            }
        });
        this._findColumnDlg.btnToTableBegin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindColumnCtrl.this.onMoveToTableBegin();
            }
        });
        this.onFilterChanged();
        GUIUtils.enableCloseByEscape(this._findColumnDlg, new CloseByEscapeListener(){

            @Override
            public void willCloseByEcape(JDialog dialog) {
                FindColumnCtrl.this.onClosing();
            }
        });
        this._findColumnDlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindColumnCtrl.this.onClosing();
            }
        });
        this._findColumnDlg.setSize(this.getDimension());
        this._findColumnDlg.showDialog();
    }

    private boolean dataSetContainsdifferentTables(DataSetViewerTablePanel dataSetViewerTablePanel) {
        HashSet<String> uniqueTableNamesOrNull = new HashSet<String>();
        for (ExtTableColumn extTableColumn : DataSetViewerTablePanelUtil.getTableColumns(dataSetViewerTablePanel.getTable())) {
            uniqueTableNamesOrNull.add(TableNameAccess.getTableName(extTableColumn));
        }
        return uniqueTableNamesOrNull.size() > 1;
    }

    private void onMoveToTableBegin() {
        this._columnsToMoveToFront = new ArrayList();
        for (int i = 0; i < this._rightListModel.size(); ++i) {
            FindColumnColWrapper wrapper = (FindColumnColWrapper)this._rightListModel.get(i);
            this._columnsToMoveToFront.add(wrapper.getExtTableColumn());
        }
        this.close();
    }

    private void onMoveUp() {
        int[] selIx = this._findColumnDlg.lstRight.getSelectedIndices();
        if (null == selIx || 0 == selIx.length) {
            return;
        }
        for (int i : selIx) {
            if (0 != i) continue;
            return;
        }
        int[] newSelIx = new int[selIx.length];
        for (int i = 0; i < selIx.length; ++i) {
            Object item = this._rightListModel.remove(selIx[i]);
            newSelIx[i] = selIx[i] - 1;
            this._rightListModel.insertElementAt(item, newSelIx[i]);
        }
        this._findColumnDlg.lstRight.setSelectedIndices(newSelIx);
        this._findColumnDlg.lstRight.ensureIndexIsVisible(newSelIx[0]);
    }

    private void onMoveDown() {
        int[] selIx = this._findColumnDlg.lstRight.getSelectedIndices();
        if (null == selIx || 0 == selIx.length) {
            return;
        }
        for (int i : selIx) {
            if (this._rightListModel.getSize() - 1 != i) continue;
            return;
        }
        int[] newSelIx = new int[selIx.length];
        for (int i = selIx.length - 1; i >= 0; --i) {
            Object item = this._rightListModel.remove(selIx[i]);
            newSelIx[i] = selIx[i] + 1;
            this._rightListModel.insertElementAt(item, newSelIx[i]);
        }
        this._findColumnDlg.lstRight.setSelectedIndices(newSelIx);
        this._findColumnDlg.lstRight.ensureIndexIsVisible(newSelIx[newSelIx.length - 1]);
    }

    private void onMoveRight() {
        this._findColumnDlg.lstRight.clearSelection();
        for (Object obj : this._findColumnDlg.lstLeft.getSelectedValues()) {
            FindColumnColWrapper findColumnColWrapper = (FindColumnColWrapper)obj;
            this._leftListModel.removeElement(findColumnColWrapper);
            this._rightListModel.addElement(findColumnColWrapper);
            this._findColumnDlg.lstRight.addSelectionInterval(this._rightListModel.size() - 1, this._rightListModel.size() - 1);
        }
    }

    private void onMoveLeft() {
        this._findColumnDlg.lstLeft.clearSelection();
        for (Object obj : this._findColumnDlg.lstRight.getSelectedValues()) {
            FindColumnColWrapper findColumnColWrapper = (FindColumnColWrapper)obj;
            this._rightListModel.removeElement(findColumnColWrapper);
            this._leftListModel.addElement(findColumnColWrapper);
            this._findColumnDlg.lstLeft.addSelectionInterval(this._leftListModel.size() - 1, this._leftListModel.size() - 1);
        }
        this.onFilterChanged();
    }

    private void onFilterChanged() {
        ArrayList<FindColumnColWrapper> newListContent = new ArrayList<FindColumnColWrapper>();
        Object[] formerSelectedValues = this._findColumnDlg.lstLeft.getSelectedValues();
        for (ExtTableColumn extTableColumn : DataSetViewerTablePanelUtil.getTableColumns(this._dataSetViewerTablePanel.getTable())) {
            FindColumnColWrapper colWrapper = new FindColumnColWrapper(extTableColumn, this._dataSetContainsdifferentTables);
            String filterText = this._findColumnDlg.txtFilter.getText();
            if (!StringUtilities.isEmpty(filterText, true) && -1 >= colWrapper.toString().toLowerCase().indexOf(filterText.toLowerCase()) || this._rightListModel.contains(colWrapper)) continue;
            newListContent.add(colWrapper);
        }
        if (this._columnSorting == ColumnSortingEnum.ASC) {
            Collections.sort(newListContent, new Comparator<FindColumnColWrapper>(){

                @Override
                public int compare(FindColumnColWrapper o1, FindColumnColWrapper o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
        } else if (this._columnSorting == ColumnSortingEnum.DESC) {
            Collections.sort(newListContent, new Comparator<FindColumnColWrapper>(){

                @Override
                public int compare(FindColumnColWrapper o1, FindColumnColWrapper o2) {
                    return -o1.toString().compareTo(o2.toString());
                }
            });
        }
        this._leftListModel.clear();
        for (FindColumnColWrapper findColumnColWrapper : newListContent) {
            this._leftListModel.addElement(findColumnColWrapper);
        }
        this._findColumnDlg.lstLeft.clearSelection();
        ArrayList<Integer> indicesToSelect = new ArrayList<Integer>();
        for (Object formerSelectedValue : formerSelectedValues) {
            indicesToSelect.add(this._leftListModel.indexOf(formerSelectedValue));
        }
        for (Integer ix : indicesToSelect) {
            this._findColumnDlg.lstLeft.addSelectionInterval(ix, ix);
        }
    }

    private void onMouseClicked(MouseEvent e) {
        if (2 == e.getClickCount()) {
            this._columnToGoTo = (FindColumnColWrapper)this._findColumnDlg.lstLeft.getSelectedValue();
            if (null == this._columnToGoTo) {
                return;
            }
            this.close();
        }
    }

    private void close() {
        this.onClosing();
        this._findColumnDlg.setVisible(false);
        this._findColumnDlg.dispose();
    }

    public FindColumnColWrapper getColumnToGoTo() {
        return this._columnToGoTo;
    }

    public ArrayList<ExtTableColumn> getColumnsToMoveToFront() {
        return this._columnsToMoveToFront;
    }

    private void onClosing() {
        Props.putInt(PREF_KEY_FIND_COLUMN_SHEET_WIDTH, this._findColumnDlg.getWidth());
        Props.putInt(PREF_KEY_FIND_COLUMN_SHEET_HEIGHT, this._findColumnDlg.getHeight());
    }

    private Dimension getDimension() {
        return new Dimension(Props.getInt(PREF_KEY_FIND_COLUMN_SHEET_WIDTH, 600), Props.getInt(PREF_KEY_FIND_COLUMN_SHEET_HEIGHT, 500));
    }
}

