/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.Component;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class BaseMainPanelTab
implements IMainPanelTab {
    private static ILogger s_log = LoggerController.createLogger(BaseMainPanelTab.class);
    private ISession _session;
    private boolean _hasBeenDisplayed;

    @Override
    public void setSession(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this._session = session;
    }

    @Override
    public void sessionClosing(ISession session) {
    }

    public final ISession getSession() {
        return this._session;
    }

    @Override
    public synchronized void select() {
        if (!this._hasBeenDisplayed) {
            s_log.debug("Refreshing " + this.getTitle() + " main tab.");
            this.refreshComponent();
            this._hasBeenDisplayed = true;
        }
    }

    @Override
    public void mouseWheelClickedOnTab() {
    }

    @Override
    public IFileEditorAPI getActiveFileEditorAPIOrNull() {
        return null;
    }

    @Override
    public Component getTabComponent() {
        return null;
    }

    @Override
    public String getTitle() {
        return "";
    }

    protected void refreshComponent() {
    }

    public void sessionEnding(ISession session) {
        if (this._session == session) {
            this._session = null;
        }
    }
}

