/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.SmallTabButton;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.JScrollPopupMenu;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SchemaPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SchemaPanel.class);
    private static final ILogger s_log = LoggerController.createLogger(SchemaPanel.class);
    private SmallTabButton _btnRefresh;
    private SmallTabButton _btnChooseSchema;
    private ISession _session;
    private JTextField _txtSchema = new JTextField();

    public SchemaPanel(ISession session) {
        this._session = session;
        this.setLayout(new GridBagLayout());
        int maxHeight = 15;
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        JLabel label = new JLabel(s_stringMgr.getString("SchemaPanel.refresh.current.schema.label"));
        this.add((Component)label, gbc);
        this._txtSchema.setMaximumSize(new Dimension(1000, maxHeight));
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0);
        this.add((Component)this._txtSchema, gbc);
        this._txtSchema.setEditable(false);
        this._txtSchema.setMaximumSize(new Dimension(1000, maxHeight));
        this._txtSchema.setPreferredSize(new Dimension(130, maxHeight));
        gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0);
        this._btnRefresh = new SmallTabButton(s_stringMgr.getString("SchemaPanel.refresh.current.schema"), Main.getApplication().getResources().getIcon("smallRefresh"), 4);
        this.add((Component)this._btnRefresh, gbc);
        this._btnRefresh.setMaximumSize(new Dimension(1000, maxHeight));
        gbc = new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0);
        this._btnChooseSchema = new SmallTabButton(s_stringMgr.getString("SchemaPanel.refresh.choose.schema"), Main.getApplication().getResources().getIcon("smallChooseSchema"), 4);
        this.add((Component)this._btnChooseSchema, gbc);
        this._btnChooseSchema.setMaximumSize(new Dimension(1000, maxHeight));
        this._btnRefresh.addActionListener(e -> this.onRefreshSchema(true));
        this._btnChooseSchema.addActionListener(e -> this.onChooseSchema());
        this._txtSchema.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SchemaPanel.this.onTxtSchemaClicked(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SchemaPanel.this.onTxtSchemaClicked(e);
            }
        });
        this.onRefreshSchema(false);
        this.setMaximumSize(new Dimension(1000, maxHeight));
    }

    private void onTxtSchemaClicked(MouseEvent me) {
        if (!me.isPopupTrigger()) {
            return;
        }
        JPopupMenu popupTxtSchemas = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(s_stringMgr.getString("SchemaPanel.txtschema.copy"));
        menuItem.addActionListener(e -> this.onCopyTxtSchema());
        popupTxtSchemas.add(menuItem);
        popupTxtSchemas.show(this._txtSchema, me.getX(), me.getY());
    }

    private void onCopyTxtSchema() {
        StringSelection ss = new StringSelection(this._txtSchema.getText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
    }

    private void onChooseSchema() {
        try {
            JScrollPopupMenu popupSchemas = new JScrollPopupMenu();
            popupSchemas.setMaximumVisibleRows(20);
            int menuCount = 0;
            int menuHeight = new JMenuItem((String)"Test").getPreferredSize().height;
            for (String schema : Main.getApplication().getSessionManager().getAllSchemas(this._session)) {
                if (StringUtilities.isEmpty(schema, true)) continue;
                JMenuItem menuItem = new JMenuItem(schema);
                menuItem.addActionListener(e -> this.onSchemaSelected(menuItem));
                popupSchemas.add(menuItem);
                ++menuCount;
            }
            int visibleItemCount = Math.min(menuCount, popupSchemas.getMaximumVisibleRows());
            int scrollbarSizeIfVisible = 0;
            if (menuCount > popupSchemas.getMaximumVisibleRows()) {
                scrollbarSizeIfVisible = popupSchemas.getScrollBar().getPreferredSize().width;
            }
            popupSchemas.show(this._btnChooseSchema, -popupSchemas.getPreferredSize().width - scrollbarSizeIfVisible + this._btnChooseSchema.getWidth(), -visibleItemCount * menuHeight + this._btnChooseSchema.getHeight());
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void onSchemaSelected(JMenuItem menuItem) {
        try {
            this._session.getSQLConnection().setSchema(menuItem.getText());
            if (menuItem.getText().equalsIgnoreCase(this._session.getSQLConnection().getSchema())) {
                this.onRefreshSchema(true);
            } else {
                s_log.error("Setting schema didn't take effect.");
            }
        }
        catch (Throwable e) {
            s_log.error("Failed to set schema", e);
        }
    }

    private void onRefreshSchema(boolean logException) {
        String schema;
        block2: {
            String noneString = "<None>";
            try {
                schema = this._session.getSQLConnection().getSchema();
                schema = StringUtilities.isEmpty(schema, true) ? noneString : schema;
            }
            catch (Throwable e) {
                schema = "<Not accessible>";
                if (!logException) break block2;
                s_log.error("Failed to load current schema name", e);
            }
        }
        this._txtSchema.setText(schema);
        this.invalidate();
    }
}

