/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionTabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrameToolBar;
import net.sourceforge.squirrel_sql.client.gui.session.SchemaPanel;
import net.sourceforge.squirrel_sql.client.gui.session.SessionColoringUtil;
import net.sourceforge.squirrel_sql.client.gui.session.rowcolumnlabel.RowColumnLabel;
import net.sourceforge.squirrel_sql.client.session.ISQLInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanelPosition;
import net.sourceforge.squirrel_sql.fw.gui.StatusBar;

public class SQLInternalFrame
extends SessionTabWidget
implements ISQLInternalFrame {
    private SQLPanel _sqlPanel;
    private SQLInternalFrameToolBar _toolBar;
    private StatusBar _statusBar = new StatusBar();

    public SQLInternalFrame(ISession session) {
        super(session.getTitle(), true, true, true, true, session);
        this.setVisible(false);
        this.createGUI(session);
    }

    public SQLPanel getSQLPanel() {
        return this._sqlPanel;
    }

    @Override
    public ISQLPanelAPI getMainSQLPanelAPI() {
        return this._sqlPanel.getSQLPanelAPI();
    }

    private void createGUI(final ISession session) {
        this._sqlPanel = new SQLPanel(session, SQLPanelPosition.IN_SQL_WORKSHEET, super.getTitleFileHandler());
        this.setVisible(false);
        IApplication app = Main.getApplication();
        ImageIcon icon = app.getResources().getIcon(this.getClass(), "frameIcon");
        if (icon != null) {
            this.setFrameIcon(icon);
        }
        this.addWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetActivated(WidgetEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SQLInternalFrame.this._sqlPanel.getSQLEntryPanel().getTextComponent().requestFocus();
                    }
                });
            }

            @Override
            public boolean widgetClosing(WidgetEvent e) {
                if (!Main.getApplication().getSessionManager().isInCloseSession(session) && !SQLInternalFrame.this._sqlPanel.getSQLPanelAPI().confirmClose()) {
                    return false;
                }
                SQLInternalFrame.this._sqlPanel.sessionWindowClosing();
                return true;
            }
        });
        this._sqlPanel.setVisible(true);
        this._toolBar = new SQLInternalFrameToolBar(this.getSession(), this._sqlPanel.getSQLPanelAPI());
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this._toolBar, "North");
        contentPanel.add((Component)this._sqlPanel, "Center");
        Font fn = app.getFontInfoStore().getStatusBarFontInfo().createFont();
        this._statusBar.setFont(fn);
        contentPanel.add((Component)this._statusBar, "South");
        this._statusBar.addJComponent(new SchemaPanel(session));
        this._statusBar.addJComponent(new RowColumnLabel(this._sqlPanel.getSQLEntryPanel()));
        SessionColoringUtil.colorStatusbar(session, this._statusBar);
        this.setContentPane(contentPanel);
        this.validate();
    }

    public void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQLInternalFrame.this._sqlPanel.getSQLEntryPanel().requestFocus();
            }
        });
    }

    public void addSeparatorToToolbar() {
        if (null != this._toolBar) {
            this._toolBar.addSeparator();
        }
    }

    public void addToToolbar(Action action) {
        if (null != this._toolBar) {
            this._toolBar.add(action);
        }
    }

    public void addToToolsPopUp(String selectionString, Action action) {
        this.getMainSQLPanelAPI().addToToolsPopUp(selectionString, action);
    }

    @Override
    public boolean hasSQLPanelAPI() {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void moveToFront() {
        super.moveToFront();
        this._sqlPanel.getSQLEntryPanel().requestFocus();
    }
}

