/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicButtonUI;

public class SmallTabButton<T>
extends JButton {
    private Icon _icon;
    private T _userObject;
    private static final MouseListener s_buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public SmallTabButton(String toolTipText, ImageIcon icon) {
        this(toolTipText, icon, null);
    }

    public SmallTabButton(String toolTipText, ImageIcon icon, int sizeOffset) {
        this(toolTipText, icon, null, sizeOffset);
    }

    public SmallTabButton(String toolTipText, ImageIcon icon, T userObject) {
        this(toolTipText, icon, userObject, 5);
    }

    public SmallTabButton(String toolTipText, ImageIcon icon, T userObject, int sizeOffset) {
        this._icon = icon;
        this._userObject = userObject;
        int size = null == icon ? 17 : Math.max(this._icon.getIconWidth(), this._icon.getIconHeight()) + sizeOffset;
        this.setPreferredSize(new Dimension(size, size));
        this.setToolTipText(toolTipText);
        this.setUI(new BasicButtonUI());
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBorderPainted(false);
        this.addMouseListener(s_buttonMouseListener);
        this.setRolloverEnabled(true);
        this.setOpaque(false);
    }

    @Override
    public void updateUI() {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (null == this._icon) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.getModel().isPressed()) {
            g2.translate(1, 1);
        }
        int x = (this.getWidth() - this._icon.getIconWidth()) / 2;
        int y = (this.getHeight() - this._icon.getIconHeight()) / 2;
        g2.drawImage(this.iconToImage(this._icon), x, y, null);
        g2.dispose();
    }

    private Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 1);
        icon.paintIcon(null, image.getGraphics(), 0, 0);
        return image;
    }

    @Override
    public void setIcon(Icon icon) {
        this._icon = icon;
        this.repaint();
    }

    public T getUserObject() {
        return this._userObject;
    }

    public void setUserObject(T userObject) {
        this._userObject = userObject;
    }
}

