/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.ApplicationListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DockDelegate;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DockWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IDesktopContainer;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabDelegate;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.ButtonTabComponent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DesktopTabbedPane;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockHandle;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockPanel;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockTabDesktopManager;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockTabDesktopPaneListener;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.RemoveTabHandelResult;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.ScrollableTabHandler;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.SmallTabButton;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.TabHandle;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.TabPanel;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.TabWindowController;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.VerticalToggleButton;
import net.sourceforge.squirrel_sql.client.gui.mainframe.SquirrelDesktopManager;
import net.sourceforge.squirrel_sql.client.mainframe.action.CloseAllButCurrentSessionsAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CloseAllSessionsAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseSessionAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseSessionWindowAction;
import net.sourceforge.squirrel_sql.client.session.action.RenameSessionAction;

public class DockTabDesktopPane
extends JComponent
implements IDesktopContainer {
    private IApplication _app;
    private boolean _belongsToMainApplicationWindow;
    private DockTabDesktopPaneListener _dockTabDesktopPaneListener;
    private JPanel _pnlButtons = new JPanel();
    private DockPanel _pnlDock = new DockPanel();
    private DesktopTabbedPane _tabbedPane;
    private JSplitPane _split = new JSplitPane(1);
    private boolean _inOnToggleOpenDock;
    private ArrayList<DockHandle> _dockHandles = new ArrayList();
    private ArrayList<TabHandle> _tabHandles = new ArrayList();
    private int _standardDividerSize;
    private HashSet<TabHandle> _handlesInRemoveTab_CloseButton = new HashSet();
    private HashSet<TabHandle> _handlesInRemoveTab_Dispose = new HashSet();
    private DockTabDesktopManager _dockTabDesktopManager = new DockTabDesktopManager();
    private JPopupMenu _tabRightMouseMenu;
    private ScrollableTabHandler _scrollableTabHandler;

    public DockTabDesktopPane(IApplication app, boolean belongsToMainApplicationWindow, DockTabDesktopPaneListener dockTabDesktopPaneListener) {
        this._app = app;
        this._belongsToMainApplicationWindow = belongsToMainApplicationWindow;
        this._dockTabDesktopPaneListener = dockTabDesktopPaneListener;
        this._tabbedPane = new DesktopTabbedPane(this._app);
        this.setLayout(new BorderLayout());
        this._pnlButtons = new JPanel();
        this._pnlButtons.setLayout(new BoxLayout(this._pnlButtons, 1));
        this.add((Component)this._pnlButtons, "West");
        this._split.setLeftComponent(this._pnlDock);
        this._scrollableTabHandler = new ScrollableTabHandler(this._app, this._tabbedPane);
        this._tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DockTabDesktopPane.this.onTabStateChanged(e);
            }
        });
        this._split.setRightComponent(this._tabbedPane);
        this.add((Component)this._split, "Center");
        this._standardDividerSize = this._split.getDividerSize();
        this._pnlDock.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DockTabDesktopPane.this.onDockPanelResized();
            }
        });
        this.closeDock();
        if (this._belongsToMainApplicationWindow) {
            this._app.addApplicationListener(new ApplicationListener(){

                @Override
                public void saveApplicationState() {
                    DockTabDesktopPane.this.onSaveApplicationState();
                }
            });
        }
        this.initTabRightMouseMenu();
    }

    private void onSaveApplicationState() {
        for (DockHandle dockHandle : this._dockHandles) {
            if (dockHandle.isClosed()) continue;
            dockHandle.storeDividerLocation(this._split.getDividerLocation());
        }
    }

    private void onTabStateChanged(ChangeEvent e) {
        this.tabActivationChanged();
    }

    private void tabActivationChanged() {
        TabPanel tabPanel = (TabPanel)this._tabbedPane.getSelectedComponent();
        if (null != tabPanel && tabPanel.getTabHandle().isSelected()) {
            return;
        }
        for (TabHandle tabHandle : this._tabHandles) {
            if (null != tabPanel && (!tabHandle.isSelected() || tabHandle == tabPanel.getTabHandle())) continue;
            tabHandle.setSelected(false);
        }
        if (tabPanel != null) {
            tabPanel.getTabHandle().setSelected(true);
        }
    }

    @Override
    public void addWidget(DockWidget widget) {
        DockHandle dockHandle = this.addDock(widget.getContentPane(), widget.getTitle());
        ((DockDelegate)widget.getDelegate()).setDockHandle(dockHandle);
    }

    @Override
    public void addWidget(DialogWidget client) {
    }

    @Override
    public void addWidget(TabWidget widget) {
        this.addTabWidgetAt(widget, this._tabbedPane.getTabCount(), new ArrayList<SmallTabButton>());
    }

    public TabHandle addTabWidgetAt(TabWidget widget, int index, ArrayList<SmallTabButton> externalButtons) {
        return this.addTabWidgetAt(widget, index, externalButtons, false);
    }

    public TabHandle addTabWidgetAt(TabWidget widget, int index, ArrayList<SmallTabButton> externalButtons, boolean widgetMovedButNotCreated) {
        final TabHandle tabHandle = new TabHandle(widget, this);
        ((TabDelegate)widget.getDelegate()).setTabHandle(tabHandle);
        tabHandle.addTabHandleListener(this._dockTabDesktopManager);
        TabPanel tabPanel = this.createTabPanel(tabHandle);
        this._tabbedPane.insertTab(widget.getTitle(), null, tabPanel, widget.getTip(), index);
        int tabIx = this._tabbedPane.indexOfComponent(tabPanel);
        ButtonTabComponent btc = (ButtonTabComponent)this._tabbedPane.getTabComponentAt(tabIx);
        btc.getClosebutton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockTabDesktopPane.this.removeTab(tabHandle, e, TabClosingMode.CLOSE_BUTTON);
            }
        });
        btc.getToWindowButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockTabDesktopPane.this.onToWindow(tabHandle);
            }
        });
        for (SmallTabButton externalButton : externalButtons) {
            btc.addSmallTabButton(externalButton);
        }
        this._tabHandles.add(tabHandle);
        tabHandle.fireAdded(this._belongsToMainApplicationWindow, widgetMovedButNotCreated);
        this._tabbedPane.setSelectedIndex(tabIx);
        this._scrollableTabHandler.tabAdded();
        return tabHandle;
    }

    private void onToWindow(TabHandle tabHandle) {
        Point locationOnScreen = this.getSelectedHandle().getWidget().getContentPane().getLocationOnScreen();
        Dimension size = this.getSelectedHandle().getWidget().getContentPane().getSize();
        TabWindowController tabWindowController = new TabWindowController(locationOnScreen, size, this._app);
        this._app.getMultipleWindowsHandler().registerDesktop(tabWindowController);
        RemoveTabHandelResult removeTabHandelResult = this.removeTabHandel(tabHandle);
        tabWindowController.addTabWidgetAt(tabHandle.getWidget(), 0, removeTabHandelResult.getRemovedButtonTabComponent().getExternalButtons(), true);
        if (null != this._dockTabDesktopPaneListener) {
            this._dockTabDesktopPaneListener.tabWasRemoved(tabHandle);
        }
    }

    public RemoveTabHandelResult removeTabHandel(int tabIndex) {
        TabHandle tabHandle = ((TabPanel)this._tabbedPane.getComponentAt(tabIndex)).getTabHandle();
        return this.removeTabHandel(tabHandle);
    }

    public RemoveTabHandelResult removeTabHandel(TabHandle tabHandle) {
        RemoveTabHandelResult ret = new RemoveTabHandelResult();
        int tabIndex = this.getTabIndex(tabHandle);
        if (-1 != tabIndex) {
            ret.setRemovedButtonTabComponent(this.removeTabFromTabbedPane(tabIndex));
        }
        this._tabHandles.remove(tabHandle);
        tabHandle.removeTabHandleListener(this._dockTabDesktopManager);
        if (this._belongsToMainApplicationWindow) {
            this._app.getWindowManager().removeWidgetFromWindowMenu(tabHandle.getWidget());
        }
        ret.setRemovedTabHandle(tabHandle);
        return ret;
    }

    public boolean isMyTabbedPane(JTabbedPane tabbedPane) {
        return this._tabbedPane == tabbedPane;
    }

    private void onDockPanelResized() {
        if (0 == this._pnlDock.getComponentCount()) {
            this.closeDock();
        }
    }

    private void closeDock() {
        this._split.setDividerLocation(0);
        this._split.setDividerSize(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onToggleOpenDock(DockHandle handle, JToggleButton btn, ActionEvent e) {
        if (this._inOnToggleOpenDock) {
            return;
        }
        try {
            this._inOnToggleOpenDock = true;
            for (int i = 0; i < this._pnlButtons.getComponents().length; ++i) {
                JToggleButton btnBuf = (JToggleButton)this._pnlButtons.getComponents()[i];
                if (btnBuf == btn) continue;
                btnBuf.setSelected(false);
            }
            if (1 == this._pnlDock.getComponentCount()) {
                DockHandle lastHandle = this.getDockHandleForComponent(this._pnlDock.getComponent(0));
                lastHandle.storeDividerLocation(this._split.getDividerLocation());
                this._pnlDock.remove(0);
                lastHandle.wasClosedByOtherButton(e);
            }
            if (btn.isSelected()) {
                this._pnlDock.add(handle.getDockFrame());
                this._split.setDividerSize(this._standardDividerSize);
                this._split.setDividerLocation(handle.getDividerLocation());
            } else {
                this.closeDock();
            }
        }
        finally {
            this._inOnToggleOpenDock = false;
        }
    }

    private DockHandle getDockHandleForComponent(Component component) {
        for (DockHandle dockHandle : this._dockHandles) {
            if (dockHandle.getDockFrame() != component) continue;
            return dockHandle;
        }
        return null;
    }

    private DockHandle addDock(Container comp, String title) {
        final VerticalToggleButton btn = new VerticalToggleButton(title);
        btn.setBorder(BorderFactory.createEtchedBorder());
        this._pnlButtons.add(btn);
        final DockHandle handle = new DockHandle(this._app, comp, title, btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockTabDesktopPane.this.onToggleOpenDock(handle, btn, e);
            }
        });
        this._dockHandles.add(handle);
        return handle;
    }

    private TabPanel createTabPanel(TabHandle tabHandle) {
        return new TabPanel(tabHandle);
    }

    public void selectTab(TabHandle tabHandle) {
        TabHandle selectedHandle = this.getSelectedHandle();
        if (selectedHandle == tabHandle) {
            return;
        }
        if (null != selectedHandle) {
            selectedHandle.fireDeselected(null);
        }
        if (null != tabHandle) {
            int tabIx = this.getTabIndex(tabHandle);
            this._tabbedPane.setSelectedIndex(tabIx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean removeTab(TabHandle tabHandle, ActionEvent e, TabClosingMode tabClosingMode) {
        if (TabClosingMode.CLOSE_BUTTON == tabClosingMode) {
            try {
                if (this._handlesInRemoveTab_CloseButton.contains(tabHandle)) {
                    boolean bl = false;
                    return bl;
                }
                this._handlesInRemoveTab_CloseButton.add(tabHandle);
                if (!tabHandle.fireClosing(e)) {
                    boolean bl = false;
                    return bl;
                }
                if (0 == tabHandle.getWidget().getDefaultCloseOperation()) return true;
                int tabIndex = this.getTabIndex(tabHandle);
                if (-1 != tabIndex) {
                    this.removeTabFromTabbedPane(tabIndex);
                }
                tabHandle.fireClosed(e);
                this._tabHandles.remove(tabHandle);
                tabHandle.removeTabHandleListener(this._dockTabDesktopManager);
                return true;
            }
            finally {
                this._handlesInRemoveTab_CloseButton.remove(tabHandle);
            }
        }
        if (TabClosingMode.DISPOSE != tabClosingMode) throw new IllegalArgumentException("Unknown TabClosingMode: " + (Object)((Object)tabClosingMode));
        try {
            if (this._handlesInRemoveTab_Dispose.contains(tabHandle)) {
                boolean tabIndex = false;
                return tabIndex;
            }
            this._handlesInRemoveTab_Dispose.add(tabHandle);
            if (!tabHandle.isFireClosingProceedingOrDone() && !tabHandle.fireClosing(e)) {
                boolean tabIndex = false;
                return tabIndex;
            }
            tabHandle.getWidget().setVisible(false);
            tabHandle.fireDeselected(e);
            this.removeTabHandel(tabHandle);
            TabHandle newSelectedHandle = this.getSelectedHandle();
            if (null == newSelectedHandle) return true;
            newSelectedHandle.fireSelected(e);
            return true;
        }
        finally {
            this._handlesInRemoveTab_Dispose.remove(tabHandle);
        }
    }

    private ButtonTabComponent removeTabFromTabbedPane(int tabIndex) {
        ButtonTabComponent ret = (ButtonTabComponent)this._tabbedPane.getTabComponentAt(tabIndex);
        this._tabbedPane.remove(tabIndex);
        this._scrollableTabHandler.tabRemoved();
        return ret;
    }

    @Override
    public IWidget[] getAllWidgets() {
        IWidget[] ret = new IWidget[this._tabHandles.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this._tabHandles.get(i).getWidget();
        }
        return ret;
    }

    public ArrayList<TabHandle> getAllHandels() {
        return this._tabHandles;
    }

    @Override
    public IWidget getSelectedWidget() {
        TabHandle selectedHandle = this.getSelectedHandle();
        if (null == selectedHandle) {
            return null;
        }
        return selectedHandle.getWidget();
    }

    private TabHandle getSelectedHandle() {
        TabPanel selComp = (TabPanel)this._tabbedPane.getSelectedComponent();
        if (null == selComp) {
            return null;
        }
        for (TabHandle tabHandle : this._tabHandles) {
            if (tabHandle != selComp.getTabHandle()) continue;
            return tabHandle;
        }
        return null;
    }

    private int getTabIndex(TabHandle tabHandle) {
        for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
            TabPanel comp = (TabPanel)this._tabbedPane.getComponentAt(i);
            if (comp.getTabHandle() != tabHandle) continue;
            return i;
        }
        return -1;
    }

    public TabHandle getHandleAtTabIndex(int tabIndex) {
        TabPanel comp = (TabPanel)this._tabbedPane.getComponentAt(tabIndex);
        return comp.getTabHandle();
    }

    @Override
    public Dimension getRequiredSize() {
        return this.getPreferredSize();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void initTabRightMouseMenu() {
        this._tabRightMouseMenu = new JPopupMenu();
        this._tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DockTabDesktopPane.this.maybeShowTabRightMouseMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DockTabDesktopPane.this.maybeShowTabRightMouseMenu(e);
            }
        });
        this._tabRightMouseMenu.add(this.createMenu(this._app.getActionCollection().get(CloseSessionWindowAction.class)));
        this._tabRightMouseMenu.add(this.createMenu(this._app.getActionCollection().get(CloseSessionAction.class)));
        this._tabRightMouseMenu.add(this.createMenu(this._app.getActionCollection().get(CloseAllButCurrentSessionsAction.class)));
        this._tabRightMouseMenu.add(this.createMenu(this._app.getActionCollection().get(CloseAllSessionsAction.class)));
        this._tabRightMouseMenu.add(this.createMenu(this._app.getActionCollection().get(RenameSessionAction.class)));
    }

    private JMenuItem createMenu(Action action) {
        JMenuItem ret = new JMenuItem(action);
        String accel = (String)action.getValue("SQuirreLAcceleratorString");
        Main.getApplication().getShortcutManager().setAccelerator(ret, KeyStroke.getKeyStroke(accel), action);
        return ret;
    }

    private void maybeShowTabRightMouseMenu(MouseEvent e) {
        int tab;
        if (e.isPopupTrigger() && -1 != (tab = this._tabbedPane.getUI().tabForCoordinate(this._tabbedPane, e.getX(), e.getY()))) {
            this._tabRightMouseMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void setDesktopManager(SquirrelDesktopManager squirrelDesktopManager) {
        this._dockTabDesktopManager.setSquirrelDesktopManager(squirrelDesktopManager);
    }

    public void setTabTitle(TabHandle tabHandle, String title) {
        this._tabbedPane.setTitleAt(this.getTabIndex(tabHandle), title);
    }

    public void addSmallTabButton(TabHandle tabHandle, SmallTabButton smallTabButton) {
        this._tabbedPane.addSmallTabButtonAt(this.getTabIndex(tabHandle), smallTabButton);
    }

    public void removeSmallTabButton(TabHandle tabHandle, SmallTabButton smallTabButton) {
        this._tabbedPane.removeSmallTabButtonAt(this.getTabIndex(tabHandle), smallTabButton);
    }

    public String getTabTitle(TabHandle tabHandle) {
        int index = this.getTabIndex(tabHandle);
        if (-1 == index) {
            return null;
        }
        return this._tabbedPane.getTitleAt(index);
    }

    public void setTabIcon(TabHandle tabHandle, Icon frameIcon) {
        this._tabbedPane.setIconAt(this.getTabIndex(tabHandle), frameIcon);
    }

    @Override
    public void putClientProperty(String key, String value) {
    }

    public void setSelected(boolean b) {
        TabHandle selectedHandle = this.getSelectedHandle();
        if (null != selectedHandle) {
            selectedHandle._setSelected(b, true);
        }
    }

    public int getTabCount() {
        return this._tabHandles.size();
    }

    public TabHandle getPreviousTabHandle(TabHandle tabHandle) {
        int tabIndex = this.getTabIndex(tabHandle);
        if (0 < tabIndex) {
            return this.getHandleAtTabIndex(tabIndex - 1);
        }
        return null;
    }

    public TabHandle getNextTabHandle(TabHandle tabHandle) {
        int tabIndex = this.getTabIndex(tabHandle);
        if (tabIndex + 1 < this.getTabCount()) {
            return this.getHandleAtTabIndex(tabIndex + 1);
        }
        return null;
    }

    public static enum TabClosingMode {
        CLOSE_BUTTON,
        DISPOSE;

    }
}

