/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.importer.csv;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.HashMap;

public class CsvReader {
    private Reader inputStream = null;
    private String fileName = null;
    private UserSettings userSettings = new UserSettings();
    private Charset charset = null;
    private boolean useCustomRecordDelimiter = false;
    private DataBuffer dataBuffer = new DataBuffer();
    private ColumnBuffer columnBuffer = new ColumnBuffer();
    private RawRecordBuffer rawBuffer = new RawRecordBuffer();
    private boolean[] isQualified = null;
    private String rawRecord = "";
    private HeadersHolder headersHolder = new HeadersHolder();
    private boolean startedColumn = false;
    private boolean startedWithQualifier = false;
    private boolean hasMoreData = true;
    private char lastLetter = '\u0000';
    private boolean hasReadNextLine = false;
    private int columnsCount = 0;
    private long currentRecord = 0L;
    private String[] values = new String[10];
    private boolean initialized = false;
    private boolean closed = false;
    public static final int ESCAPE_MODE_DOUBLED = 1;
    public static final int ESCAPE_MODE_BACKSLASH = 2;

    public CsvReader(Reader inputStream, char delimiter, boolean trimValues) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Parameter inputStream can not be null.");
        }
        this.inputStream = inputStream;
        this.userSettings.delimiter = delimiter;
        this.userSettings.trimWhitespace = trimValues;
        this.initialized = true;
        this.isQualified = new boolean[this.values.length];
    }

    public CsvReader(Reader inputStream) {
        this(inputStream, ',', true);
    }

    public boolean getCaptureRawRecord() {
        return this.userSettings.captureRawRecord;
    }

    public void setCaptureRawRecord(boolean captureRawRecord) {
        this.userSettings.captureRawRecord = captureRawRecord;
    }

    public String getRawRecord() {
        return this.rawRecord;
    }

    public boolean getTrimWhitespace() {
        return this.userSettings.trimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this.userSettings.trimWhitespace = trimWhitespace;
    }

    public char getDelimiter() {
        return this.userSettings.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.userSettings.delimiter = delimiter;
    }

    public char getRecordDelimiter() {
        return this.userSettings.recordDelimiter;
    }

    public void setRecordDelimiter(char recordDelimiter) {
        this.useCustomRecordDelimiter = true;
        this.userSettings.recordDelimiter = recordDelimiter;
    }

    public char getTextQualifier() {
        return this.userSettings.textQualifier;
    }

    public void setTextQualifier(char textQualifier) {
        this.userSettings.textQualifier = textQualifier;
    }

    public boolean getUseTextQualifier() {
        return this.userSettings.useTextQualifier;
    }

    public void setUseTextQualifier(boolean useTextQualifier) {
        this.userSettings.useTextQualifier = useTextQualifier;
    }

    public char getComment() {
        return this.userSettings.comment;
    }

    public void setComment(char comment) {
        this.userSettings.comment = comment;
    }

    public boolean getUseComments() {
        return this.userSettings.useComments;
    }

    public void setUseComments(boolean useComments) {
        this.userSettings.useComments = useComments;
    }

    public int getEscapeMode() {
        return this.userSettings.escapeMode;
    }

    public void setEscapeMode(int escapeMode) throws IllegalArgumentException {
        if (escapeMode != 1 && escapeMode != 2) {
            throw new IllegalArgumentException("Parameter escapeMode must be a valid value.");
        }
        this.userSettings.escapeMode = escapeMode;
    }

    public boolean getSkipEmptyRecords() {
        return this.userSettings.skipEmptyRecords;
    }

    public void setSkipEmptyRecords(boolean skipEmptyRecords) {
        this.userSettings.skipEmptyRecords = skipEmptyRecords;
    }

    public boolean getSafetySwitch() {
        return this.userSettings.safetySwitch;
    }

    public void setSafetySwitch(boolean safetySwitch) {
        this.userSettings.safetySwitch = safetySwitch;
    }

    public int getColumnCount() {
        return this.columnsCount;
    }

    public long getCurrentRecord() {
        return this.currentRecord - 1L;
    }

    public int getHeaderCount() {
        return this.headersHolder.length;
    }

    public String[] getHeaders() throws IOException {
        this.checkClosed();
        if (this.headersHolder.headers == null) {
            return null;
        }
        String[] clone = new String[this.headersHolder.length];
        System.arraycopy(this.headersHolder.headers, 0, clone, 0, this.headersHolder.length);
        return clone;
    }

    public void setHeaders(String[] headers) {
        this.headersHolder.headers = headers;
        this.headersHolder.indexByName.clear();
        this.headersHolder.length = headers != null ? headers.length : 0;
        for (int i = 0; i < this.headersHolder.length; ++i) {
            this.headersHolder.indexByName.put(headers[i], i);
        }
    }

    public String[] getValues() throws IOException {
        this.checkClosed();
        String[] clone = new String[this.columnsCount];
        System.arraycopy(this.values, 0, clone, 0, this.columnsCount);
        return clone;
    }

    public String get(int columnIndex) throws IOException {
        this.checkClosed();
        if (columnIndex > -1 && columnIndex < this.columnsCount) {
            return this.values[columnIndex];
        }
        return "";
    }

    public String get(String headerName) throws IOException {
        this.checkClosed();
        return this.get(this.getIndex(headerName));
    }

    public static CsvReader parse(String data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter data can not be null.");
        }
        return new CsvReader(new StringReader(data));
    }

    public boolean readRecord() throws IOException {
        this.checkClosed();
        this.columnsCount = 0;
        this.rawBuffer.Position = 0;
        this.dataBuffer.lineStart = this.dataBuffer.position;
        this.hasReadNextLine = false;
        if (this.hasMoreData) {
            do {
                if (this.dataBuffer.position == this.dataBuffer.count) {
                    this.checkDataLength();
                    continue;
                }
                this.startedWithQualifier = false;
                char currentLetter = this.dataBuffer.buffer[this.dataBuffer.position];
                if (this.userSettings.useTextQualifier && currentLetter == this.userSettings.textQualifier) {
                    this.lastLetter = currentLetter;
                    this.startedColumn = true;
                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                    this.startedWithQualifier = true;
                    boolean lastLetterWasQualifier = false;
                    char escapeChar = this.userSettings.textQualifier;
                    if (this.userSettings.escapeMode == 2) {
                        escapeChar = '\\';
                    }
                    boolean eatingTrailingJunk = false;
                    boolean lastLetterWasEscape = false;
                    boolean readingComplexEscape = false;
                    int escape = 1;
                    int escapeLength = 0;
                    char escapeValue = '\u0000';
                    ++this.dataBuffer.position;
                    do {
                        if (this.dataBuffer.position == this.dataBuffer.count) {
                            this.checkDataLength();
                            continue;
                        }
                        currentLetter = this.dataBuffer.buffer[this.dataBuffer.position];
                        if (eatingTrailingJunk) {
                            this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                            if (currentLetter == this.userSettings.delimiter) {
                                this.endColumn();
                            } else if (!this.useCustomRecordDelimiter && (currentLetter == '\r' || currentLetter == '\n') || this.useCustomRecordDelimiter && currentLetter == this.userSettings.recordDelimiter) {
                                this.endColumn();
                                this.endRecord();
                            }
                        } else if (readingComplexEscape) {
                            ++escapeLength;
                            switch (escape) {
                                case 1: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 4) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 2: {
                                    escapeValue = (char)(escapeValue * 8);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 3: {
                                    escapeValue = (char)(escapeValue * 10);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 4: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 2) break;
                                    readingComplexEscape = false;
                                }
                            }
                            if (!readingComplexEscape) {
                                this.appendLetter(escapeValue);
                            } else {
                                this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                            }
                        } else if (currentLetter == this.userSettings.textQualifier) {
                            if (lastLetterWasEscape) {
                                lastLetterWasEscape = false;
                                lastLetterWasQualifier = false;
                            } else {
                                this.updateCurrentValue();
                                if (this.userSettings.escapeMode == 1) {
                                    lastLetterWasEscape = true;
                                }
                                lastLetterWasQualifier = true;
                            }
                        } else if (this.userSettings.escapeMode == 2 && lastLetterWasEscape) {
                            switch (currentLetter) {
                                case 'n': {
                                    this.appendLetter('\n');
                                    break;
                                }
                                case 'r': {
                                    this.appendLetter('\r');
                                    break;
                                }
                                case 't': {
                                    this.appendLetter('\t');
                                    break;
                                }
                                case 'b': {
                                    this.appendLetter('\b');
                                    break;
                                }
                                case 'f': {
                                    this.appendLetter('\f');
                                    break;
                                }
                                case 'e': {
                                    this.appendLetter('\u001b');
                                    break;
                                }
                                case 'v': {
                                    this.appendLetter('\u000b');
                                    break;
                                }
                                case 'a': {
                                    this.appendLetter('\u0007');
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    escape = 2;
                                    readingComplexEscape = true;
                                    escapeLength = 1;
                                    escapeValue = (char)(currentLetter - 48);
                                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                    break;
                                }
                                case 'D': 
                                case 'O': 
                                case 'U': 
                                case 'X': 
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (currentLetter) {
                                        case 'U': 
                                        case 'u': {
                                            escape = 1;
                                            break;
                                        }
                                        case 'X': 
                                        case 'x': {
                                            escape = 4;
                                            break;
                                        }
                                        case 'O': 
                                        case 'o': {
                                            escape = 2;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            escape = 3;
                                        }
                                    }
                                    readingComplexEscape = true;
                                    escapeLength = 0;
                                    escapeValue = '\u0000';
                                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                    break;
                                }
                            }
                            lastLetterWasEscape = false;
                        } else if (currentLetter == escapeChar) {
                            this.updateCurrentValue();
                            lastLetterWasEscape = true;
                        } else if (lastLetterWasQualifier) {
                            if (currentLetter == this.userSettings.delimiter) {
                                this.endColumn();
                            } else if (!this.useCustomRecordDelimiter && (currentLetter == '\r' || currentLetter == '\n') || this.useCustomRecordDelimiter && currentLetter == this.userSettings.recordDelimiter) {
                                this.endColumn();
                                this.endRecord();
                            } else {
                                this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                eatingTrailingJunk = true;
                            }
                            lastLetterWasQualifier = false;
                        }
                        this.lastLetter = currentLetter;
                        if (!this.startedColumn) continue;
                        ++this.dataBuffer.position;
                        if (!this.userSettings.safetySwitch || this.dataBuffer.position - this.dataBuffer.columnStart + this.columnBuffer.Position <= 100000) continue;
                        this.close();
                        throw new IOException("Maximum column length of 100,000 exceeded in column " + NumberFormat.getIntegerInstance().format(this.columnsCount) + " in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false if you're expecting column lengths greater than 100,000 characters to avoid this error.");
                    } while (this.hasMoreData && this.startedColumn);
                } else if (currentLetter == this.userSettings.delimiter) {
                    this.lastLetter = currentLetter;
                    this.endColumn();
                } else if (this.useCustomRecordDelimiter && currentLetter == this.userSettings.recordDelimiter) {
                    if (this.startedColumn || this.columnsCount > 0 || !this.userSettings.skipEmptyRecords) {
                        this.endColumn();
                        this.endRecord();
                    } else {
                        this.dataBuffer.lineStart = this.dataBuffer.position + 1;
                    }
                    this.lastLetter = currentLetter;
                } else if (!(this.useCustomRecordDelimiter || currentLetter != '\r' && currentLetter != '\n')) {
                    if (this.startedColumn || this.columnsCount > 0 || !this.userSettings.skipEmptyRecords && (currentLetter == '\r' || this.lastLetter != '\r')) {
                        this.endColumn();
                        this.endRecord();
                    } else {
                        this.dataBuffer.lineStart = this.dataBuffer.position + 1;
                    }
                    this.lastLetter = currentLetter;
                } else if (this.userSettings.useComments && this.columnsCount == 0 && currentLetter == this.userSettings.comment) {
                    this.lastLetter = currentLetter;
                    this.skipLine();
                } else if (this.userSettings.trimWhitespace && (currentLetter == ' ' || currentLetter == '\t')) {
                    this.startedColumn = true;
                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                } else {
                    this.startedColumn = true;
                    this.dataBuffer.columnStart = this.dataBuffer.position;
                    boolean lastLetterWasBackslash = false;
                    boolean readingComplexEscape = false;
                    int escape = 1;
                    int escapeLength = 0;
                    char escapeValue = '\u0000';
                    boolean firstLoop = true;
                    do {
                        if (!firstLoop && this.dataBuffer.position == this.dataBuffer.count) {
                            this.checkDataLength();
                            continue;
                        }
                        if (!firstLoop) {
                            currentLetter = this.dataBuffer.buffer[this.dataBuffer.position];
                        }
                        if (!this.userSettings.useTextQualifier && this.userSettings.escapeMode == 2 && currentLetter == '\\') {
                            if (lastLetterWasBackslash) {
                                lastLetterWasBackslash = false;
                            } else {
                                this.updateCurrentValue();
                                lastLetterWasBackslash = true;
                            }
                        } else if (readingComplexEscape) {
                            ++escapeLength;
                            switch (escape) {
                                case 1: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 4) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 2: {
                                    escapeValue = (char)(escapeValue * 8);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 3: {
                                    escapeValue = (char)(escapeValue * 10);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 4: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 2) break;
                                    readingComplexEscape = false;
                                }
                            }
                            if (!readingComplexEscape) {
                                this.appendLetter(escapeValue);
                            } else {
                                this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                            }
                        } else if (this.userSettings.escapeMode == 2 && lastLetterWasBackslash) {
                            switch (currentLetter) {
                                case 'n': {
                                    this.appendLetter('\n');
                                    break;
                                }
                                case 'r': {
                                    this.appendLetter('\r');
                                    break;
                                }
                                case 't': {
                                    this.appendLetter('\t');
                                    break;
                                }
                                case 'b': {
                                    this.appendLetter('\b');
                                    break;
                                }
                                case 'f': {
                                    this.appendLetter('\f');
                                    break;
                                }
                                case 'e': {
                                    this.appendLetter('\u001b');
                                    break;
                                }
                                case 'v': {
                                    this.appendLetter('\u000b');
                                    break;
                                }
                                case 'a': {
                                    this.appendLetter('\u0007');
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    escape = 2;
                                    readingComplexEscape = true;
                                    escapeLength = 1;
                                    escapeValue = (char)(currentLetter - 48);
                                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                    break;
                                }
                                case 'D': 
                                case 'O': 
                                case 'U': 
                                case 'X': 
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (currentLetter) {
                                        case 'U': 
                                        case 'u': {
                                            escape = 1;
                                            break;
                                        }
                                        case 'X': 
                                        case 'x': {
                                            escape = 4;
                                            break;
                                        }
                                        case 'O': 
                                        case 'o': {
                                            escape = 2;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            escape = 3;
                                        }
                                    }
                                    readingComplexEscape = true;
                                    escapeLength = 0;
                                    escapeValue = '\u0000';
                                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                    break;
                                }
                            }
                            lastLetterWasBackslash = false;
                        } else if (currentLetter == this.userSettings.delimiter) {
                            this.endColumn();
                        } else if (!this.useCustomRecordDelimiter && (currentLetter == '\r' || currentLetter == '\n') || this.useCustomRecordDelimiter && currentLetter == this.userSettings.recordDelimiter) {
                            this.endColumn();
                            this.endRecord();
                        }
                        this.lastLetter = currentLetter;
                        firstLoop = false;
                        if (!this.startedColumn) continue;
                        ++this.dataBuffer.position;
                        if (!this.userSettings.safetySwitch || this.dataBuffer.position - this.dataBuffer.columnStart + this.columnBuffer.Position <= 100000) continue;
                        this.close();
                        throw new IOException("Maximum column length of 100,000 exceeded in column " + NumberFormat.getIntegerInstance().format(this.columnsCount) + " in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false if you're expecting column lengths greater than 100,000 characters to avoid this error.");
                    } while (this.hasMoreData && this.startedColumn);
                }
                if (!this.hasMoreData) continue;
                ++this.dataBuffer.position;
            } while (this.hasMoreData && !this.hasReadNextLine);
            if (this.startedColumn || this.lastLetter == this.userSettings.delimiter) {
                this.endColumn();
                this.endRecord();
            }
        }
        this.rawRecord = this.userSettings.captureRawRecord ? (this.hasMoreData ? (this.rawBuffer.Position == 0 ? new String(this.dataBuffer.buffer, this.dataBuffer.lineStart, this.dataBuffer.position - this.dataBuffer.lineStart - 1) : new String(this.rawBuffer.Buffer, 0, this.rawBuffer.Position) + new String(this.dataBuffer.buffer, this.dataBuffer.lineStart, this.dataBuffer.position - this.dataBuffer.lineStart - 1)) : new String(this.rawBuffer.Buffer, 0, this.rawBuffer.Position)) : "";
        return this.hasReadNextLine;
    }

    private void checkDataLength() throws IOException {
        if (!this.initialized) {
            if (this.fileName != null) {
                this.inputStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), this.charset), 4096);
            }
            this.charset = null;
            this.initialized = true;
        }
        this.updateCurrentValue();
        if (this.userSettings.captureRawRecord && this.dataBuffer.count > 0) {
            if (this.rawBuffer.Buffer.length - this.rawBuffer.Position < this.dataBuffer.count - this.dataBuffer.lineStart) {
                int newLength = this.rawBuffer.Buffer.length + Math.max(this.dataBuffer.count - this.dataBuffer.lineStart, this.rawBuffer.Buffer.length);
                char[] holder = new char[newLength];
                System.arraycopy(this.rawBuffer.Buffer, 0, holder, 0, this.rawBuffer.Position);
                this.rawBuffer.Buffer = holder;
            }
            System.arraycopy(this.dataBuffer.buffer, this.dataBuffer.lineStart, this.rawBuffer.Buffer, this.rawBuffer.Position, this.dataBuffer.count - this.dataBuffer.lineStart);
            this.rawBuffer.Position += this.dataBuffer.count - this.dataBuffer.lineStart;
        }
        try {
            this.dataBuffer.count = this.inputStream.read(this.dataBuffer.buffer, 0, this.dataBuffer.buffer.length);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
        if (this.dataBuffer.count == -1) {
            this.hasMoreData = false;
        }
        this.dataBuffer.position = 0;
        this.dataBuffer.lineStart = 0;
        this.dataBuffer.columnStart = 0;
    }

    public boolean readHeaders() throws IOException {
        boolean result = this.readRecord();
        this.headersHolder.length = this.columnsCount;
        this.headersHolder.headers = new String[this.columnsCount];
        for (int i = 0; i < this.headersHolder.length; ++i) {
            String columnValue;
            this.headersHolder.headers[i] = columnValue = this.get(i);
            this.headersHolder.indexByName.put(columnValue, i);
        }
        if (result) {
            --this.currentRecord;
        }
        this.columnsCount = 0;
        return result;
    }

    public String getHeader(int columnIndex) throws IOException {
        this.checkClosed();
        if (columnIndex > -1 && columnIndex < this.headersHolder.length) {
            return this.headersHolder.headers[columnIndex];
        }
        return "";
    }

    public boolean isQualified(int columnIndex) throws IOException {
        this.checkClosed();
        if (columnIndex < this.columnsCount && columnIndex > -1) {
            return this.isQualified[columnIndex];
        }
        return false;
    }

    private void endColumn() throws IOException {
        String currentValue = "";
        if (this.startedColumn) {
            int lastLetter;
            if (this.columnBuffer.Position == 0) {
                if (this.dataBuffer.columnStart < this.dataBuffer.position) {
                    if (this.userSettings.trimWhitespace && !this.startedWithQualifier) {
                        for (lastLetter = this.dataBuffer.position - 1; lastLetter >= this.dataBuffer.columnStart && (this.dataBuffer.buffer[lastLetter] == ' ' || this.dataBuffer.buffer[lastLetter] == '\t'); --lastLetter) {
                        }
                    }
                    currentValue = new String(this.dataBuffer.buffer, this.dataBuffer.columnStart, lastLetter - this.dataBuffer.columnStart + 1);
                }
            } else {
                this.updateCurrentValue();
                if (this.userSettings.trimWhitespace && !this.startedWithQualifier) {
                    for (lastLetter = this.columnBuffer.Position - 1; lastLetter >= 0 && (this.columnBuffer.Buffer[lastLetter] == ' ' || this.columnBuffer.Buffer[lastLetter] == ' '); --lastLetter) {
                    }
                }
                currentValue = new String(this.columnBuffer.Buffer, 0, lastLetter + 1);
            }
        }
        this.columnBuffer.Position = 0;
        this.startedColumn = false;
        if (this.columnsCount >= 100000 && this.userSettings.safetySwitch) {
            this.close();
            throw new IOException("Maximum column count of 100,000 exceeded in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false if you're expecting more than 100,000 columns per record to avoid this error.");
        }
        if (this.columnsCount == this.values.length) {
            int newLength = this.values.length * 2;
            String[] holder = new String[newLength];
            System.arraycopy(this.values, 0, holder, 0, this.values.length);
            this.values = holder;
            boolean[] qualifiedHolder = new boolean[newLength];
            System.arraycopy(this.isQualified, 0, qualifiedHolder, 0, this.isQualified.length);
            this.isQualified = qualifiedHolder;
        }
        this.values[this.columnsCount] = currentValue;
        this.isQualified[this.columnsCount] = this.startedWithQualifier;
        currentValue = "";
        ++this.columnsCount;
    }

    private void appendLetter(char letter) {
        if (this.columnBuffer.Position == this.columnBuffer.Buffer.length) {
            int newLength = this.columnBuffer.Buffer.length * 2;
            char[] holder = new char[newLength];
            System.arraycopy(this.columnBuffer.Buffer, 0, holder, 0, this.columnBuffer.Position);
            this.columnBuffer.Buffer = holder;
        }
        this.columnBuffer.Buffer[this.columnBuffer.Position++] = letter;
        this.dataBuffer.columnStart = this.dataBuffer.position + 1;
    }

    private void updateCurrentValue() {
        if (this.startedColumn && this.dataBuffer.columnStart < this.dataBuffer.position) {
            if (this.columnBuffer.Buffer.length - this.columnBuffer.Position < this.dataBuffer.position - this.dataBuffer.columnStart) {
                int newLength = this.columnBuffer.Buffer.length + Math.max(this.dataBuffer.position - this.dataBuffer.columnStart, this.columnBuffer.Buffer.length);
                char[] holder = new char[newLength];
                System.arraycopy(this.columnBuffer.Buffer, 0, holder, 0, this.columnBuffer.Position);
                this.columnBuffer.Buffer = holder;
            }
            System.arraycopy(this.dataBuffer.buffer, this.dataBuffer.columnStart, this.columnBuffer.Buffer, this.columnBuffer.Position, this.dataBuffer.position - this.dataBuffer.columnStart);
            this.columnBuffer.Position += this.dataBuffer.position - this.dataBuffer.columnStart;
        }
        this.dataBuffer.columnStart = this.dataBuffer.position + 1;
    }

    private void endRecord() throws IOException {
        this.hasReadNextLine = true;
        ++this.currentRecord;
    }

    public int getIndex(String headerName) throws IOException {
        this.checkClosed();
        Integer indexValue = this.headersHolder.indexByName.get(headerName);
        if (indexValue != null) {
            return indexValue;
        }
        return -1;
    }

    public boolean skipRecord() throws IOException {
        this.checkClosed();
        boolean recordRead = false;
        if (this.hasMoreData && (recordRead = this.readRecord())) {
            --this.currentRecord;
        }
        return recordRead;
    }

    public boolean skipLine() throws IOException {
        this.checkClosed();
        this.columnsCount = 0;
        boolean skippedLine = false;
        if (this.hasMoreData) {
            boolean foundEol = false;
            do {
                if (this.dataBuffer.position == this.dataBuffer.count) {
                    this.checkDataLength();
                    continue;
                }
                skippedLine = true;
                char currentLetter = this.dataBuffer.buffer[this.dataBuffer.position];
                if (currentLetter == '\r' || currentLetter == '\n') {
                    foundEol = true;
                }
                this.lastLetter = currentLetter;
                if (foundEol) continue;
                ++this.dataBuffer.position;
            } while (this.hasMoreData && !foundEol);
            this.columnBuffer.Position = 0;
            this.dataBuffer.lineStart = this.dataBuffer.position + 1;
        }
        this.rawBuffer.Position = 0;
        this.rawRecord = "";
        return skippedLine;
    }

    public void close() {
        if (!this.closed) {
            this.close(true);
            this.closed = true;
        }
    }

    private void close(boolean closing) {
        if (!this.closed) {
            if (closing) {
                this.charset = null;
                this.headersHolder.headers = null;
                this.headersHolder.indexByName = null;
                this.dataBuffer.buffer = null;
                this.columnBuffer.Buffer = null;
                this.rawBuffer.Buffer = null;
            }
            try {
                if (this.initialized) {
                    this.inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputStream = null;
            this.closed = true;
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("This instance of the CsvReader class has already been closed.");
        }
    }

    protected void finalize() {
        this.close(false);
    }

    private static char hexToDec(char hex) {
        char result = hex >= 'a' ? (char)(hex - 97 + 10) : (hex >= 'A' ? (char)(hex - 65 + 10) : (char)(hex - 48));
        return result;
    }

    private class StaticSettings {
        public static final int MAX_BUFFER_SIZE = 1024;
        public static final int MAX_FILE_BUFFER_SIZE = 4096;
        public static final int INITIAL_COLUMN_COUNT = 10;
        public static final int INITIAL_COLUMN_BUFFER_SIZE = 50;

        private StaticSettings() {
        }
    }

    private class HeadersHolder {
        public String[] headers = null;
        public int length = 0;
        public HashMap<String, Integer> indexByName = new HashMap();
    }

    private class UserSettings {
        public boolean caseSensitive = true;
        public char textQualifier = (char)34;
        public boolean trimWhitespace = true;
        public boolean useTextQualifier = true;
        public char delimiter = (char)44;
        public char recordDelimiter = '\u0000';
        public char comment = (char)35;
        public boolean useComments = false;
        public int escapeMode = 1;
        public boolean safetySwitch = true;
        public boolean skipEmptyRecords = true;
        public boolean captureRawRecord = true;
    }

    private class Letters {
        public static final char LF = '\n';
        public static final char CR = '\r';
        public static final char QUOTE = '\"';
        public static final char COMMA = ',';
        public static final char SPACE = ' ';
        public static final char TAB = '\t';
        public static final char POUND = '#';
        public static final char BACKSLASH = '\\';
        public static final char NULL = '\u0000';
        public static final char BACKSPACE = '\b';
        public static final char FORM_FEED = '\f';
        public static final char ESCAPE = '\u001b';
        public static final char VERTICAL_TAB = '\u000b';
        public static final char ALERT = '\u0007';

        private Letters() {
        }
    }

    private class RawRecordBuffer {
        public char[] Buffer = new char[500];
        public int Position = 0;
    }

    private class ColumnBuffer {
        public char[] Buffer = new char[50];
        public int Position = 0;
    }

    private class DataBuffer {
        public char[] buffer = new char[1024];
        public int position = 0;
        public int count = 0;
        public int columnStart = 0;
        public int lineStart = 0;
    }

    private class ComplexEscape {
        private static final int UNICODE = 1;
        private static final int OCTAL = 2;
        private static final int DECIMAL = 3;
        private static final int HEX = 4;

        private ComplexEscape() {
        }
    }
}

