/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.gui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.dataimport.gui.SpecialColumnMapping;

public class ColumnMappingTableModel
extends AbstractTableModel {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(ColumnMappingTableModel.class);
    private TableColumnInfo[] columns;
    private Vector<String> mapping = new Vector();
    private Vector<String> defaults = new Vector();

    public ColumnMappingTableModel(TableColumnInfo[] columns) {
        this.columns = columns;
        for (int i = 0; i < columns.length; ++i) {
            this.mapping.add(SpecialColumnMapping.SKIP.getVisibleString());
            this.defaults.add("");
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.columns[rowIndex].getColumnName();
        }
        if (columnIndex == 1) {
            return this.mapping.get(rowIndex);
        }
        if (columnIndex == 2) {
            return this.defaults.get(rowIndex);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 || columnIndex == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            this.mapping.set(row, value.toString());
        } else if (col == 2) {
            this.defaults.set(row, value.toString());
        }
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return stringMgr.getString("ImportFileDialog.tableColumn");
        }
        if (column == 1) {
            return stringMgr.getString("ImportFileDialog.importFileColumn");
        }
        if (column == 2) {
            return stringMgr.getString("ImportFileDialog.fixedValue");
        }
        return null;
    }

    public int findTableColumn(String columnName) {
        int i = 0;
        for (i = 0; i < this.columns.length; ++i) {
            if (!columnName.equals(this.columns[i].getColumnName())) continue;
            return i;
        }
        return -1;
    }

    public void resetMappings() {
        this.mapping.clear();
        this.defaults.clear();
        for (int i = 0; i < this.columns.length; ++i) {
            this.mapping.add(SpecialColumnMapping.SKIP.getVisibleString());
            this.defaults.add("");
        }
        this.fireTableDataChanged();
    }

    public String getMapping(TableColumnInfo column) {
        int pos = this.findTableColumn(column.getColumnName());
        return this.getValueAt(pos, 1).toString();
    }

    public String getFixedValue(TableColumnInfo column) {
        int pos = this.findTableColumn(column.getColumnName());
        return this.getValueAt(pos, 2).toString();
    }

    public int getColumnCountExcludingSkipped(TableColumnInfo[] columns) {
        int count = 0;
        for (TableColumnInfo column : columns) {
            int pos = this.findTableColumn(column.getColumnName());
            String mapping = this.getValueAt(pos, 1).toString();
            if (SpecialColumnMapping.SKIP.getVisibleString().equals(mapping)) continue;
            ++count;
        }
        return count;
    }
}

