/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.fife.rsta.ui.UIUtil;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextMenuBar;
import org.fife.rtext.StatusBar;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;

public class SearchToolBar
extends JToolBar {
    private RText owner;
    private JTextField findField;
    private JButton findButton;
    private JButton findPrevButton;
    private JCheckBox matchCaseCheckBox;
    private JLabel infoLabel;
    private String textNotFound;

    public SearchToolBar(String title, final RText rtext, StatusBar mouseListener) {
        super(title);
        this.owner = rtext;
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.rtext.QuickSearchBar");
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        FindButtonListener findButtonListener = new FindButtonListener();
        FindFieldListener findFieldListener = new FindFieldListener();
        ClassLoader cl = this.getClass().getClassLoader();
        ImageIcon icon = null;
        this.add(Box.createHorizontalStrut(5));
        FindButton hideButton = null;
        try {
            hideButton = new FindButton(new ImageIcon(cl.getResource("org/fife/rtext/graphics/close.gif")));
        }
        catch (Exception e) {
            hideButton = new FindButton("x");
        }
        hideButton.setBorderPainted(false);
        hideButton.setBorder(BorderFactory.createEmptyBorder());
        try {
            icon = new ImageIcon(cl.getResource("org/fife/rtext/graphics/close_rollover.gif"));
            hideButton.setRolloverEnabled(true);
            hideButton.setRolloverIcon(icon);
            hideButton.setPressedIcon(icon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchToolBar.this.setVisible(false);
                ((RTextMenuBar)((Object)rtext.getJMenuBar())).setSearchToolbarMenuItemSelected(false);
            }
        });
        this.add(hideButton);
        this.add(Box.createHorizontalStrut(5));
        JLabel label = new JLabel(msg.getString("Find"));
        this.add(label);
        this.findField = new JTextField(20){

            @Override
            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.width = 200;
                return size;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = 200;
                return size;
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension max = super.getMaximumSize();
                max.width = 200;
                return max;
            }
        };
        this.findField.putClientProperty("JTextField.variant", "search");
        this.findField.getAccessibleContext().setAccessibleDescription(msg.getString("FindFieldDesc"));
        this.findField.addMouseListener((MouseListener)((Object)mouseListener));
        this.findField.getDocument().addDocumentListener(findFieldListener);
        this.findField.addKeyListener(findFieldListener);
        this.findField.addFocusListener(findFieldListener);
        this.add(this.findField);
        this.add(Box.createHorizontalStrut(5));
        ImageIcon nextIcon = null;
        ImageIcon prevIcon = null;
        try {
            nextIcon = new ImageIcon(cl.getResource("org/fife/rtext/graphics/right.gif"));
            prevIcon = new ImageIcon(cl.getResource("org/fife/rtext/graphics/left.gif"));
            if (!orientation.isLeftToRight()) {
                icon = nextIcon;
                nextIcon = prevIcon;
                prevIcon = icon;
            }
        }
        catch (Exception e) {
            rtext.displayException(e);
        }
        this.findButton = new FindButton(msg.getString("FindNext"), nextIcon);
        this.findButton.setActionCommand("FindNext");
        this.findButton.getAccessibleContext().setAccessibleDescription(msg.getString("DescFindNext"));
        this.findButton.addMouseListener((MouseListener)((Object)mouseListener));
        this.findButton.addActionListener(findButtonListener);
        this.findButton.setEnabled(false);
        this.add(this.findButton);
        this.add(Box.createHorizontalStrut(5));
        this.findPrevButton = new FindButton(msg.getString("FindPrev"), prevIcon);
        this.findPrevButton.getAccessibleContext().setAccessibleDescription(msg.getString("DescFindPrev"));
        this.findPrevButton.addMouseListener((MouseListener)((Object)mouseListener));
        this.findPrevButton.setActionCommand("FindPrevious");
        this.findPrevButton.addActionListener(findButtonListener);
        this.findPrevButton.setEnabled(false);
        this.add(this.findPrevButton);
        this.add(Box.createHorizontalStrut(5));
        this.matchCaseCheckBox = new JCheckBox(msg.getString("MatchCase"));
        this.add(this.matchCaseCheckBox);
        this.add(Box.createHorizontalStrut(15));
        this.infoLabel = new JLabel("");
        this.textNotFound = msg.getString("TextNotFound");
        this.add(this.infoLabel);
        this.setFloatable(false);
        this.applyComponentOrientation(orientation);
    }

    public void focusFindField() {
        if (this.findField.isFocusOwner()) {
            this.findField.selectAll();
        } else {
            this.findField.requestFocusInWindow();
        }
    }

    class FindFieldListener
    extends KeyAdapter
    implements DocumentListener,
    FocusListener {
        FindFieldListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            SearchToolBar.this.findField.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (!SearchToolBar.this.findButton.isEnabled()) {
                SearchToolBar.this.findButton.setEnabled(true);
                SearchToolBar.this.findPrevButton.setEnabled(true);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                SearchToolBar.this.owner.getMainView().getCurrentTextArea().requestFocusInWindow();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\n') {
                int mod = e.getModifiersEx();
                if ((mod & 0x80) > 0) {
                    SearchToolBar.this.findPrevButton.doClick(0);
                } else {
                    SearchToolBar.this.findButton.doClick(0);
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (e.getDocument().getLength() == 0) {
                SearchToolBar.this.findButton.setEnabled(false);
                SearchToolBar.this.findPrevButton.setEnabled(false);
            }
        }
    }

    private static class FindButtonUI
    extends BasicButtonUI {
        private Rectangle viewRect = new Rectangle(0, 0, 0, 0);
        private Rectangle iconRect = new Rectangle(0, 0, 0, 0);
        private Rectangle textRect = new Rectangle(0, 0, 0, 0);
        private MouseInputHandler mouseInputHandler;
        private boolean isArmed;
        private boolean isMouseOver;
        private static boolean someButtonDepressed;
        private static final Border BORDER;

        private FindButtonUI() {
        }

        @Override
        protected void installDefaults(AbstractButton b) {
            super.installDefaults(b);
            b.setBorder(BORDER);
            b.setOpaque(false);
        }

        @Override
        protected void installListeners(AbstractButton b) {
            super.installListeners(b);
            this.mouseInputHandler = new MouseInputHandler(b);
            b.addMouseListener(this.mouseInputHandler);
        }

        protected boolean isArmed() {
            return this.isArmed;
        }

        protected boolean isMouseOver() {
            return this.isMouseOver;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            AbstractButton b = (AbstractButton)c;
            Font f = c.getFont();
            g.setFont(f);
            FontMetrics fm = b.getFontMetrics(b.getFont());
            Insets i = c.getInsets();
            this.viewRect.x = i.left;
            this.viewRect.y = i.top;
            this.viewRect.width = b.getWidth() - (i.right + this.viewRect.x);
            this.viewRect.height = b.getHeight() - (i.bottom + this.viewRect.y);
            this.textRect.height = 0;
            this.textRect.width = 0;
            this.textRect.y = 0;
            this.textRect.x = 0;
            this.iconRect.height = 0;
            this.iconRect.width = 0;
            this.iconRect.y = 0;
            this.iconRect.x = 0;
            String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, b.getText() == null ? 0 : b.getIconTextGap());
            this.paintBackground(g, b);
            if (b.getIcon() != null) {
                this.paintIcon(g, c, this.iconRect);
            }
            if (text != null && !text.equals("")) {
                this.paintText(g, b, this.textRect, text);
            }
            if (b.isFocusPainted() && b.hasFocus()) {
                this.paintFocus(g, b, this.viewRect, this.textRect, this.iconRect);
            }
        }

        public void paintBackground(Graphics g, AbstractButton b) {
            ButtonModel model = b.getModel();
            int width = b.getWidth();
            int height = b.getHeight();
            if (model.isEnabled()) {
                String text;
                if (model.isArmed()) {
                    String text2 = b.getText();
                    if (text2 != null && text2.length() > 0) {
                        g.setColor(b.getForeground());
                        g.drawRect(0, 0, width - 1, height - 1);
                        this.textRect.translate(1, 1);
                    }
                    this.iconRect.translate(1, 1);
                } else if ((this.isMouseOver() || this.isArmed()) && (text = b.getText()) != null && text.length() > 0) {
                    g.setColor(b.getForeground());
                    g.drawRect(0, 0, width - 1, height - 1);
                }
            }
        }

        @Override
        protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            FontMetrics fm = g.getFontMetrics();
            int mnemonicIndex = b.getDisplayedMnemonicIndex();
            if (model.isEnabled()) {
                g.setColor(b.getForeground());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
            } else {
                g.setColor(b.getBackground().darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }

        protected void setArmed(boolean armed) {
            this.isArmed = armed;
        }

        protected void setMouseOver(boolean over) {
            this.isMouseOver = over;
        }

        @Override
        protected void uninstallListeners(AbstractButton b) {
            b.removeMouseListener(this.mouseInputHandler);
            super.uninstallListeners(b);
        }

        static {
            BORDER = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        }

        protected class MouseInputHandler
        extends MouseInputAdapter {
            private AbstractButton button;

            public MouseInputHandler(AbstractButton b) {
                this.button = b;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                someButtonDepressed = true;
                if (FindButtonUI.this.isMouseOver()) {
                    FindButtonUI.this.setArmed(true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                someButtonDepressed = false;
                FindButtonUI.this.setArmed(false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!someButtonDepressed) {
                    FindButtonUI.this.setMouseOver(true);
                    this.button.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FindButtonUI.this.setMouseOver(false);
                this.button.repaint();
            }
        }
    }

    class FindButtonListener
    implements ActionListener {
        FindButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean forward = "FindNext".equals(e.getActionCommand());
            String text = SearchToolBar.this.findField.getText();
            RTextEditorPane textArea = SearchToolBar.this.owner.getMainView().getCurrentTextArea();
            SearchContext context = new SearchContext();
            context.setMatchCase(SearchToolBar.this.matchCaseCheckBox.isSelected());
            context.setRegularExpression(false);
            context.setSearchFor(text);
            context.setSearchForward(forward);
            context.setSearchSelectionOnly(false);
            context.setWholeWord(false);
            SearchResult result = SearchEngine.find((JTextArea)((Object)textArea), (SearchContext)context);
            if (result.wasFound()) {
                SearchToolBar.this.infoLabel.setText("");
            } else {
                SearchToolBar.this.infoLabel.setForeground(UIUtil.getErrorTextForeground());
                SearchToolBar.this.infoLabel.setText(SearchToolBar.this.textNotFound);
                UIManager.getLookAndFeel().provideErrorFeedback(SearchToolBar.this.findField);
            }
            if (!SearchToolBar.this.findField.isFocusOwner()) {
                SearchToolBar.this.findField.grabFocus();
            }
        }
    }

    private static class FindButton
    extends JButton {
        public FindButton(String text) {
            super(text);
        }

        public FindButton(String text, Icon icon) {
            super(text, icon);
        }

        public FindButton(Icon icon) {
            super(icon);
        }

        @Override
        public void setUI(ButtonUI ui) {
            super.setUI(new FindButtonUI());
        }
    }
}

