/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api;

import java.awt.Component;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ColorSchemeTransform;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceApi;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.colorscheme.BlendBiColorScheme;

@SubstanceApi
public class SubstanceColorSchemeBundle
implements Cloneable {
    protected SubstanceColorScheme activeColorScheme;
    protected SubstanceColorScheme defaultColorScheme;
    protected SubstanceColorScheme disabledColorScheme;
    protected Map<ComponentState, Float> stateAlphaMap;
    protected Map<ComponentState, Float> stateHighlightSchemeAlphaMap;
    protected SubstanceColorScheme pressedScheme;
    protected SubstanceColorScheme disabledSelectedScheme;
    protected Map<ColorSchemeAssociationKind, Map<ComponentState, SubstanceColorScheme>> colorSchemeMap;

    public SubstanceColorSchemeBundle(SubstanceColorScheme activeColorScheme, SubstanceColorScheme defaultColorScheme, SubstanceColorScheme disabledColorScheme) {
        this.activeColorScheme = activeColorScheme;
        this.defaultColorScheme = defaultColorScheme;
        this.disabledColorScheme = disabledColorScheme;
        this.stateAlphaMap = new EnumMap<ComponentState, Float>(ComponentState.class);
        this.stateHighlightSchemeAlphaMap = new EnumMap<ComponentState, Float>(ComponentState.class);
        this.colorSchemeMap = new HashMap<ColorSchemeAssociationKind, Map<ComponentState, SubstanceColorScheme>>();
        for (ColorSchemeAssociationKind associationKind : ColorSchemeAssociationKind.values()) {
            this.colorSchemeMap.put(associationKind, new EnumMap(ComponentState.class));
        }
    }

    public void registerColorScheme(SubstanceColorScheme stateColorScheme, float alpha, ComponentState ... states) {
        if (states != null) {
            for (ComponentState state : states) {
                this.colorSchemeMap.get(ColorSchemeAssociationKind.FILL).put(state, stateColorScheme);
                this.stateAlphaMap.put(state, Float.valueOf(alpha));
            }
        }
    }

    public void registerColorScheme(SubstanceColorScheme stateColorScheme, ComponentState ... states) {
        this.registerColorScheme(stateColorScheme, 1.0f, states);
    }

    public void registerHighlightColorScheme(SubstanceColorScheme stateHighlightScheme, ComponentState ... states) {
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.values()) {
                if (this.colorSchemeMap.get(ColorSchemeAssociationKind.HIGHLIGHT).containsKey((Object)state) || !state.isKindActive(FadeKind.ENABLE) || state == ComponentState.DEFAULT) continue;
                this.colorSchemeMap.get(ColorSchemeAssociationKind.HIGHLIGHT).put(state, stateHighlightScheme);
            }
        } else {
            for (ComponentState state : states) {
                this.colorSchemeMap.get(ColorSchemeAssociationKind.HIGHLIGHT).put(state, stateHighlightScheme);
            }
        }
    }

    public void registerHighlightColorScheme(SubstanceColorScheme stateHighlightScheme, float alpha, ComponentState ... states) {
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.values()) {
                if (!state.isKindActive(FadeKind.ENABLE) || state == ComponentState.DEFAULT) continue;
                if (!this.colorSchemeMap.get(ColorSchemeAssociationKind.HIGHLIGHT).containsKey((Object)state)) {
                    this.colorSchemeMap.get(ColorSchemeAssociationKind.HIGHLIGHT).put(state, stateHighlightScheme);
                }
                if (this.stateHighlightSchemeAlphaMap.containsKey((Object)state)) continue;
                this.stateHighlightSchemeAlphaMap.put(state, Float.valueOf(alpha));
            }
        } else {
            for (ComponentState state : states) {
                this.colorSchemeMap.get(ColorSchemeAssociationKind.HIGHLIGHT).put(state, stateHighlightScheme);
                this.stateHighlightSchemeAlphaMap.put(state, Float.valueOf(alpha));
            }
        }
    }

    public SubstanceColorScheme getColorScheme(Component comp, ComponentState componentState) {
        SubstanceColorScheme registered = this.colorSchemeMap.get(ColorSchemeAssociationKind.FILL).get((Object)componentState);
        if (registered != null) {
            return registered;
        }
        if (componentState.isKindActive(FadeKind.PRESS)) {
            if (this.pressedScheme == null) {
                this.pressedScheme = this.activeColorScheme.shade(0.2).saturate(0.1);
            }
            return this.pressedScheme;
        }
        if (componentState == ComponentState.DISABLED_SELECTED) {
            if (this.disabledSelectedScheme == null) {
                this.disabledSelectedScheme = new BlendBiColorScheme(this.activeColorScheme, this.disabledColorScheme, 0.25);
            }
            return this.disabledSelectedScheme;
        }
        if (componentState == ComponentState.DEFAULT) {
            return this.defaultColorScheme;
        }
        if (!componentState.isKindActive(FadeKind.ENABLE)) {
            return this.disabledColorScheme;
        }
        return this.activeColorScheme;
    }

    @Deprecated
    public SubstanceColorScheme getHighlightColorScheme(Component comp, ComponentState componentState) {
        return this.getColorScheme(comp, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
    }

    public float getHighlightAlpha(Component comp, ComponentState componentState) {
        Float registered = this.stateHighlightSchemeAlphaMap.get((Object)componentState);
        if (registered != null) {
            return registered.floatValue();
        }
        return -1.0f;
    }

    public float getAlpha(Component comp, ComponentState componentState) {
        Float registered = this.stateAlphaMap.get((Object)componentState);
        if (registered != null) {
            return registered.floatValue();
        }
        return -1.0f;
    }

    public SubstanceColorScheme getActiveColorScheme() {
        return this.activeColorScheme;
    }

    public SubstanceColorScheme getDefaultColorScheme() {
        return this.defaultColorScheme;
    }

    public SubstanceColorScheme getDisabledColorScheme() {
        return this.disabledColorScheme;
    }

    public void registerColorScheme(SubstanceColorScheme scheme, ColorSchemeAssociationKind associationKind, ComponentState ... states) {
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.values()) {
                if (this.colorSchemeMap.get(associationKind).containsKey((Object)state)) continue;
                this.colorSchemeMap.get(associationKind).put(state, scheme);
            }
        } else {
            for (ComponentState state : states) {
                this.colorSchemeMap.get(associationKind).put(state, scheme);
            }
        }
    }

    public SubstanceColorScheme getColorScheme(Component comp, ColorSchemeAssociationKind associationKind, ComponentState componentState) {
        if (associationKind == ColorSchemeAssociationKind.FILL) {
            return this.getColorScheme(comp, componentState);
        }
        SubstanceColorScheme registered = this.colorSchemeMap.get(associationKind).get((Object)componentState);
        if (registered != null) {
            return registered;
        }
        ColorSchemeAssociationKind fallback = associationKind.getFallback();
        if (fallback == null) {
            return null;
        }
        return this.getColorScheme(comp, fallback, componentState);
    }

    @Deprecated
    public void registerBorderColorScheme(SubstanceColorScheme scheme, ComponentState ... states) {
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.values()) {
                if (this.colorSchemeMap.get(ColorSchemeAssociationKind.BORDER).containsKey((Object)state)) continue;
                this.colorSchemeMap.get(ColorSchemeAssociationKind.BORDER).put(state, scheme);
            }
        } else {
            for (ComponentState state : states) {
                this.colorSchemeMap.get(ColorSchemeAssociationKind.BORDER).put(state, scheme);
            }
        }
    }

    @Deprecated
    public SubstanceColorScheme getBorderColorScheme(Component comp, ComponentState componentState) {
        return this.getColorScheme(comp, ColorSchemeAssociationKind.BORDER, componentState);
    }

    protected Object clone() throws CloneNotSupportedException {
        SubstanceColorSchemeBundle clone = new SubstanceColorSchemeBundle(this.activeColorScheme, this.defaultColorScheme, this.disabledColorScheme);
        for (Map.Entry<ColorSchemeAssociationKind, Map<ComponentState, SubstanceColorScheme>> entry : this.colorSchemeMap.entrySet()) {
            clone.colorSchemeMap.get(entry.getKey()).putAll(entry.getValue());
        }
        if (this.stateAlphaMap != null) {
            clone.stateAlphaMap = new EnumMap<ComponentState, Float>(this.stateAlphaMap);
        }
        if (this.stateHighlightSchemeAlphaMap != null) {
            clone.stateHighlightSchemeAlphaMap = new EnumMap<ComponentState, Float>(this.stateHighlightSchemeAlphaMap);
        }
        return clone;
    }

    public SubstanceColorSchemeBundle transform(ColorSchemeTransform transform) {
        SubstanceColorSchemeBundle result = new SubstanceColorSchemeBundle(transform.transform(this.activeColorScheme), transform.transform(this.defaultColorScheme), transform.transform(this.disabledColorScheme));
        for (Map.Entry<ColorSchemeAssociationKind, Map<ComponentState, SubstanceColorScheme>> entry : this.colorSchemeMap.entrySet()) {
            for (Map.Entry<ComponentState, SubstanceColorScheme> subEntry : entry.getValue().entrySet()) {
                result.colorSchemeMap.get(entry.getKey()).put(subEntry.getKey(), transform.transform(subEntry.getValue()));
            }
        }
        if (this.stateAlphaMap != null) {
            result.stateAlphaMap = new EnumMap<ComponentState, Float>(this.stateAlphaMap);
        }
        if (this.stateHighlightSchemeAlphaMap != null) {
            result.stateHighlightSchemeAlphaMap = new EnumMap<ComponentState, Float>(this.stateHighlightSchemeAlphaMap);
        }
        return result;
    }

    Set<ComponentState> getStatesWithAlpha() {
        EnumSet<ComponentState> result = EnumSet.noneOf(ComponentState.class);
        for (Map.Entry<ComponentState, Float> alphaEntry : this.stateAlphaMap.entrySet()) {
            if (!(alphaEntry.getValue().floatValue() < 1.0f)) continue;
            result.add(alphaEntry.getKey());
        }
        return result;
    }
}

