/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.PrimaryKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.mysql.MysqlPlugin;

public class DBUtils {
    private static final ILogger s_log = LoggerController.createLogger(DBUtils.class);
    private final ISession _session;
    private final MysqlPlugin _plugin;

    public DBUtils(ISession session, MysqlPlugin plugin) {
        this._session = session;
        this._plugin = plugin;
    }

    public ITableInfo getTableInfo() {
        IObjectTreeAPI treeAPI = this._session.getSessionInternalFrame().getObjectTreeAPI();
        IDatabaseObjectInfo[] dbInfo = treeAPI.getSelectedDatabaseObjects();
        if (dbInfo[0] instanceof ITableInfo) {
            return (ITableInfo)dbInfo[0];
        }
        return null;
    }

    public String[] getColumnNames() {
        String[] columnNames = null;
        try {
            ISQLConnection conn = this._session.getSQLConnection();
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + this.getTableInfo() + ";");
            ResultSetMetaData md = rs.getMetaData();
            columnNames = new String[md.getColumnCount()];
            for (int i = 0; i < columnNames.length; ++i) {
                columnNames[i] = md.getColumnLabel(i + 1);
            }
        }
        catch (SQLException ex) {
            this._session.showErrorMessage((Throwable)ex);
        }
        return columnNames;
    }

    public String[] getFieldDataTypes() {
        String[] dataTypes = null;
        try {
            ISQLConnection conn = this._session.getSQLConnection();
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + this.getTableInfo() + ";");
            ResultSetMetaData md = rs.getMetaData();
            dataTypes = new String[md.getColumnCount()];
            for (int i = 0; i < dataTypes.length; ++i) {
                dataTypes[i] = md.getColumnTypeName(i + 1);
            }
        }
        catch (SQLException ex) {
            this._session.showErrorMessage((Throwable)ex);
        }
        return dataTypes;
    }

    public void execute(String SQLQuery) {
        try {
            ISQLConnection conn = this._session.getSQLConnection();
            Statement stmt = conn.createStatement();
            stmt.execute(SQLQuery);
        }
        catch (SQLException ex) {
            this._session.showErrorMessage((Throwable)ex);
        }
    }

    public Vector<String> getDataTypes() {
        Vector<String> dataTypes = new Vector<String>();
        try {
            ISQLConnection conn = this._session.getSQLConnection();
            SQLDatabaseMetaData dmd = conn.getSQLMetaData();
            String[] infos = dmd.getDataTypesSimpleNames();
            for (int i = 0; i < infos.length; ++i) {
                dataTypes.add(infos[i]);
            }
        }
        catch (SQLException ex) {
            this._session.showErrorMessage((Throwable)ex);
        }
        return dataTypes;
    }

    public String getPrimaryKeyColumn() {
        String primaryKey = "";
        try {
            ISQLConnection con = this._session.getSQLConnection();
            SQLDatabaseMetaData db = con.getSQLMetaData();
            PrimaryKeyInfo[] infos = db.getPrimaryKey(this.getTableInfo());
            for (int i = 0; i < infos.length; ++i) {
                primaryKey = infos[i].getColumnName();
            }
        }
        catch (SQLException ex) {
            this._session.showErrorMessage((Throwable)ex);
        }
        return primaryKey;
    }
}

