/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.codecompletion;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import net.sourceforge.squirrel_sql.client.session.ExtendedColumnInfo;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionColumnInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.CodeCompletionInfo;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.CodeCompletionPreferences;

public class CodeCompletionTableInfo
extends CodeCompletionInfo {
    private String _tableName;
    private String _tableType;
    private ArrayList<CodeCompletionColumnInfo> _colInfos;
    String _toString;
    private String _catalog;
    private String _schema;
    private boolean _useCompletionPrefs;
    private CodeCompletionPreferences _prefs;
    private ISession _session;

    public CodeCompletionTableInfo(String tableName, String tableType, String catalog, String schema, boolean useCompletionPrefs, CodeCompletionPreferences prefs, ISession session) {
        this._tableName = tableName;
        this._tableType = tableType;
        this._catalog = catalog;
        this._schema = schema;
        this._useCompletionPrefs = useCompletionPrefs;
        this._prefs = prefs;
        this._session = session;
        this._toString = null != this._tableType && !"TABLE".equals(this._tableType) ? this._tableName + " (" + this._tableType + ")" : this._tableName;
    }

    void setHasDuplicateNameInDfifferentSchemas() {
        String tabNameWithSchemaHint = this._tableName + (null == this._catalog ? "" : " catalog=" + this._catalog) + (null == this._schema ? "" : " schema=" + this._schema);
        this._toString = null != this._tableType && !"TABLE".equals(this._tableType) ? tabNameWithSchemaHint + " (" + this._tableType + ")" : tabNameWithSchemaHint;
    }

    public String getCompareString() {
        return this._tableName;
    }

    @Override
    public ArrayList<? extends CodeCompletionInfo> getColumns(SchemaInfo schemaInfo, String colNamePattern) {
        try {
            if (null == this._colInfos || this._colInfos.size() == 0) {
                ExtendedColumnInfo[] schemColInfos = schemaInfo.getExtendedColumnInfos(this._catalog, this._schema, this._tableName);
                ArrayList<CodeCompletionColumnInfo> colInfosBuf = new ArrayList<CodeCompletionColumnInfo>();
                HashSet<String> uniqCols = new HashSet<String>();
                for (int i = 0; i < schemColInfos.length; ++i) {
                    boolean nullable;
                    int decimalDigits;
                    int columnSize;
                    if (null != this._catalog && null != schemColInfos[i].getCatalog() && !("" + this._catalog).equals("" + schemColInfos[i].getCatalog()) || null != this._schema && null != schemColInfos[i].getSchema() && !("" + this._schema).equals("" + schemColInfos[i].getSchema())) continue;
                    String columnName = schemColInfos[i].getColumnName();
                    String columnType = schemColInfos[i].getColumnType();
                    String remarks = schemColInfos[i].getRemarks();
                    CodeCompletionColumnInfo buf = new CodeCompletionColumnInfo(this._tableName, columnName, remarks, columnType, columnSize = schemColInfos[i].getColumnSize(), decimalDigits = schemColInfos[i].getDecimalDigits(), nullable = schemColInfos[i].isNullable(), this._prefs);
                    String bufStr = buf.toString();
                    if (uniqCols.contains(bufStr)) continue;
                    uniqCols.add(bufStr);
                    colInfosBuf.add(buf);
                }
                if (colInfosBuf.size() == 0 && this._session != null) {
                    SQLDatabaseMetaData sdmd = this._session.getSQLConnection().getSQLMetaData();
                    TableColumnInfo[] ti = sdmd.getColumnInfo(this._catalog, this._schema, this._tableName);
                    for (int x = 0; x < ti.length; ++x) {
                        CodeCompletionColumnInfo buf = new CodeCompletionColumnInfo(this._tableName, ti[x].getColumnName(), ti[x].getRemarks(), ti[x].getTypeName(), ti[x].getColumnSize(), ti[x].getDecimalDigits(), !ti[x].isNullable().equals("NO"), this._prefs);
                        String bufStr = buf.toString();
                        if (uniqCols.contains(bufStr)) continue;
                        uniqCols.add(bufStr);
                        colInfosBuf.add(buf);
                    }
                }
                this._colInfos = colInfosBuf;
            }
            String trimmedColNamePattern = colNamePattern.trim();
            ArrayList<Object> ret = new ArrayList();
            if ("".equals(trimmedColNamePattern)) {
                ret = this._colInfos;
            } else {
                for (CodeCompletionColumnInfo colInfo : this._colInfos) {
                    if (!colInfo.matchesCompletionStringStart(trimmedColNamePattern, this._useCompletionPrefs && this._prefs.isMatchCamelCase())) continue;
                    ret.add((Object)colInfo);
                }
            }
            if (this._prefs.isSortColumnsAlphabetically()) {
                ret.sort(Comparator.comparing(codeCompletionColumnInfo -> codeCompletionColumnInfo.getCompareString().toUpperCase()));
            }
            return ret;
        }
        catch (SQLException e) {
            throw Utilities.wrapRuntime((Throwable)e);
        }
    }

    public boolean hasColumns() {
        return true;
    }

    public String toString() {
        return this._toString;
    }
}

