/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AbstractRefactoringTabbedDialog;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AddIndexColumnTableModel;

public class AddIndexDialog
extends AbstractRefactoringTabbedDialog {
    private static final long serialVersionUID = -3938627506591289398L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddIndexDialog.class);
    private static final ILogger log = LoggerController.createLogger(AddIndexDialog.class);
    private ColumnsTab _columnTab;
    private PropertiesTab _propertiesTab;
    private final String[] _tableColumns;

    public AddIndexDialog(String[] tableColumns) {
        super(new Dimension(400, 340));
        this._tableColumns = tableColumns;
        this.init();
    }

    private void init() {
        this._columnTab = new ColumnsTab();
        this._propertiesTab = new PropertiesTab();
        this.pane.addTab(i18n.TABBEDPANE_PROPERTIES_LABEL, this._propertiesTab);
        this.pane.addTab(i18n.TABBEDPANE_COLUMNS_LABEL, this._columnTab);
        this.setAllButtonEnabled(false);
        this.setTitle(i18n.DIALOG_TITLE);
    }

    private void checkInputCompletion() {
        if (this._columnTab._columnTable.getRowCount() == 0) {
            this.setAllButtonEnabled(false);
            return;
        }
        this.setAllButtonEnabled(true);
    }

    public void enableTablespaceField(boolean enable) {
        this._propertiesTab.enableTableSpaceField(enable);
    }

    public void setAccessMethods(boolean enable, String[] accessMethods) {
        this._propertiesTab.setAccessMethods(enable, accessMethods);
    }

    public String getIndexName() {
        return this._propertiesTab.getIndexName();
    }

    public String getTablespaceText() {
        return this._propertiesTab.getTablespaceText();
    }

    public String getAccessMethod() {
        return this._propertiesTab.getAccessMethod();
    }

    public boolean isUniqueSet() {
        return this._propertiesTab.isUniqueSet();
    }

    public String getConstraints() {
        return this._propertiesTab.getConstraints();
    }

    public String[] getIndexColumns() {
        return this._columnTab.getIndexColumns();
    }

    public static void main(String[] args) {
        String[] tableColumns = new String[]{"id", "name", "street", "number"};
        String[] accessMethods = new String[]{"b-tree", "hash", "gin", "gi"};
        AddIndexDialog dialog = new AddIndexDialog(tableColumns);
        dialog.enableTablespaceField(true);
        dialog.setAccessMethods(true, accessMethods);
        dialog.setVisible(true);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    class ColumnsTab
    extends JPanel {
        private static final long serialVersionUID = 8534250606004015711L;
        private JTable _columnTable;
        private final AddIndexColumnTableModel _columnTableModel = new AddIndexColumnTableModel();
        private JComboBox _columnBox;
        private JButton _removeButton;
        private JButton _addButton;

        public ColumnsTab() {
            this.init();
            this.initData();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this._columnTable = new JTable();
            this._columnTable.setModel(this._columnTableModel);
            this._columnTable.setDragEnabled(false);
            this._columnTable.setRowSelectionAllowed(true);
            this._columnTable.setColumnSelectionAllowed(false);
            this._columnTable.getTableHeader().setReorderingAllowed(false);
            this._columnTable.setCellSelectionEnabled(false);
            this._columnTable.setSelectionMode(0);
            this._columnTable.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    ColumnsTab.this._removeButton.setEnabled(true);
                }
            });
            JScrollPane scrollTablePane = new JScrollPane(this._columnTable);
            this._columnBox = new JComboBox();
            JPanel buttonPanel = new JPanel(new GridLayout(1, 0, 10, 10));
            this._addButton = new JButton(i18n.COLUMNS_ADD_BUTTON_LABEL);
            this._addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String local = (String)ColumnsTab.this._columnBox.getSelectedItem();
                    ColumnsTab.this._columnBox.removeItem(local);
                    ColumnsTab.this._columnTableModel.addColumn(local);
                    if (ColumnsTab.this._columnBox.getItemCount() == 0) {
                        ColumnsTab.this._addButton.setEnabled(false);
                    }
                    AddIndexDialog.this.checkInputCompletion();
                }
            });
            this._removeButton = new JButton(i18n.COLUMNS_REMOVE_BUTTON_LABEL);
            this._removeButton.setEnabled(false);
            this._removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = ColumnsTab.this._columnTable.getSelectedRow();
                    if (index != -1) {
                        String removed = ColumnsTab.this._columnTableModel.deleteRow(index);
                        ColumnsTab.this._columnBox.addItem(removed);
                        ColumnsTab.this._addButton.setEnabled(true);
                        if (ColumnsTab.this._columnTableModel.getRowCount() == 0) {
                            ColumnsTab.this._removeButton.setEnabled(false);
                        } else {
                            int deleteIndex = 0;
                            if (index > 0) {
                                deleteIndex = index - 1;
                            }
                            ColumnsTab.this._columnTable.getSelectionModel().setSelectionInterval(0, deleteIndex);
                        }
                    }
                    AddIndexDialog.this.checkInputCompletion();
                }
            });
            buttonPanel.add(this._addButton);
            buttonPanel.add(this._removeButton);
            this.add((Component)scrollTablePane, new GridBagConstraints(0, 0, 4, 3, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._columnBox, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)buttonPanel, new GridBagConstraints(2, 3, 2, 0, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        }

        private void initData() {
            for (String column : AddIndexDialog.this._tableColumns) {
                this._columnBox.addItem(column);
            }
        }

        public String[] getIndexColumns() {
            return this._columnTableModel.getRowData().toArray(new String[0]);
        }
    }

    class PropertiesTab
    extends JPanel {
        private static final long serialVersionUID = -6278926941374497863L;
        private JTextField _indexNameField;
        private JTextField _tableSpaceField;
        private JComboBox _accessMethodBox;
        private JLabel _uniqueLabel;
        private JCheckBox _uniqueBox;
        private JTextArea _constraintArea;

        public PropertiesTab() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            JLabel nameLabel = AddIndexDialog.this.getBorderedLabel(i18n.PROPERTIES_NAME_LABEL, AddIndexDialog.this.emptyBorder);
            this._indexNameField = new JTextField();
            this._indexNameField.setPreferredSize(AddIndexDialog.this.mediumField);
            JLabel tableSpaceLabel = AddIndexDialog.this.getBorderedLabel(i18n.PROPERTIES_TABLESPACE_LABEL, AddIndexDialog.this.emptyBorder);
            this._tableSpaceField = new JTextField();
            this._tableSpaceField.setPreferredSize(AddIndexDialog.this.mediumField);
            this._tableSpaceField.setEnabled(false);
            JLabel accessMethodLabel = AddIndexDialog.this.getBorderedLabel(i18n.PROPERTIES_ACCESS_METHOD_LABEL, AddIndexDialog.this.emptyBorder);
            this._accessMethodBox = new JComboBox();
            this._accessMethodBox.setPreferredSize(AddIndexDialog.this.mediumField);
            this._accessMethodBox.setEditable(false);
            this._accessMethodBox.setEnabled(false);
            this._uniqueLabel = AddIndexDialog.this.getBorderedLabel(i18n.PROPERTIES_UNIQUE_LABEL, AddIndexDialog.this.emptyBorder);
            this._uniqueBox = new JCheckBox();
            JLabel constraintLabel = AddIndexDialog.this.getBorderedLabel(i18n.PROPERTIES_CONSTRAINT_LABEL, AddIndexDialog.this.emptyBorder);
            constraintLabel.setToolTipText(i18n.PROPERTIES_CONSTRAINT_TOOLTIP);
            this._constraintArea = new JTextArea();
            this._constraintArea.setBorder(BorderFactory.createLineBorder(Color.black));
            this._constraintArea.setPreferredSize(AddIndexDialog.this.mediumField);
            this._constraintArea.setLineWrap(true);
            this._constraintArea.setWrapStyleWord(true);
            this._constraintArea.setToolTipText(i18n.PROPERTIES_CONSTRAINT_TOOLTIP);
            JScrollPane scrollAreaConstraint = new JScrollPane(this._constraintArea);
            scrollAreaConstraint.setVerticalScrollBarPolicy(22);
            scrollAreaConstraint.setAutoscrolls(true);
            scrollAreaConstraint.setPreferredSize(AddIndexDialog.this.mediumField);
            Insets boxesInsets = new Insets(5, 5, 0, 5);
            boolean xweight_label = false;
            boolean xweight_field = true;
            this.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, (double)xweight_label, 0.0, 12, 0, boxesInsets, 0, 0));
            this.add((Component)this._indexNameField, new GridBagConstraints(1, 0, 1, 1, (double)xweight_field, 0.0, 17, 2, boxesInsets, 0, 0));
            this.add((Component)tableSpaceLabel, new GridBagConstraints(0, 1, 1, 1, (double)xweight_label, 0.0, 12, 0, boxesInsets, 0, 0));
            this.add((Component)this._tableSpaceField, new GridBagConstraints(1, 1, 1, 1, (double)xweight_field, 0.0, 17, 2, boxesInsets, 0, 0));
            this.add((Component)accessMethodLabel, new GridBagConstraints(0, 2, 1, 1, (double)xweight_label, 0.0, 12, 0, boxesInsets, 0, 0));
            this.add((Component)this._accessMethodBox, new GridBagConstraints(1, 2, 1, 1, (double)xweight_field, 0.0, 17, 2, boxesInsets, 0, 0));
            this.add((Component)this._uniqueLabel, new GridBagConstraints(0, 3, 1, 1, (double)xweight_label, 0.0, 12, 0, boxesInsets, 0, 0));
            this.add((Component)this._uniqueBox, new GridBagConstraints(1, 3, 1, 1, (double)xweight_field, 0.0, 17, 2, boxesInsets, 0, 0));
            this.add((Component)constraintLabel, new GridBagConstraints(0, 4, 1, 1, (double)xweight_label, 0.0, 12, 2, boxesInsets, 0, 0));
            boxesInsets.bottom = 5;
            this.add((Component)scrollAreaConstraint, new GridBagConstraints(1, 4, 1, 1, (double)xweight_field, 1.0, 18, 1, boxesInsets, 0, 0));
        }

        public void enableTableSpaceField(boolean enable) {
            this._tableSpaceField.setEnabled(enable);
        }

        public void setAccessMethods(boolean enable, String[] accessMethods) {
            this._accessMethodBox.setEnabled(enable);
            if (accessMethods != null) {
                for (String method : accessMethods) {
                    this._accessMethodBox.addItem(method);
                    if (!method.equalsIgnoreCase("unique")) continue;
                    this._uniqueBox.setEnabled(false);
                    this.remove(this._uniqueLabel);
                    this.remove(this._uniqueBox);
                }
            }
        }

        public String getIndexName() {
            return this._indexNameField.getText();
        }

        public String getTablespaceText() {
            return this._tableSpaceField.getText();
        }

        public String getAccessMethod() {
            return this._accessMethodBox.getSelectedItem().toString();
        }

        public boolean isUniqueSet() {
            return this._uniqueBox.isSelected();
        }

        public String getConstraints() {
            return this._constraintArea.getText();
        }
    }

    protected static interface i18n {
        public static final String DIALOG_TITLE = AddIndexDialog.access$000().getString("AddIndexDialog.title");
        public static final String TABBEDPANE_PROPERTIES_LABEL = AddIndexDialog.access$000().getString("AddIndexDialog.propertiesTabname");
        public static final String TABBEDPANE_COLUMNS_LABEL = AddIndexDialog.access$000().getString("AddIndexDialog.columnsTabName");
        public static final String PROPERTIES_NAME_LABEL = AddIndexDialog.access$000().getString("AddIndexDialog.propertiesNameLabel");
        public static final String PROPERTIES_TABLESPACE_LABEL = AddIndexDialog.access$000().getString("AddIndexDialog.tableSpaceLabel");
        public static final String PROPERTIES_ACCESS_METHOD_LABEL = AddIndexDialog.access$000().getString("AddIndexDialog.accessMethodLabel");
        public static final String PROPERTIES_UNIQUE_LABEL = AddIndexDialog.access$000().getString("AddIndexDialog.uniqueLabel");
        public static final String PROPERTIES_CLUSTERED_LABEL = AddIndexDialog.access$000().getString("AddIndexDialog.clusteredLabel");
        public static final String PROPERTIES_CONSTRAINT_LABEL = AddIndexDialog.access$000().getString("AddIndexDialog.constraintLabel");
        public static final String PROPERTIES_CONSTRAINT_TOOLTIP = AddIndexDialog.access$000().getString("AddIndexDialog.constraintLabelToolTip");
        public static final String COLUMNS_COLUMN_HEADER = AddIndexDialog.access$000().getString("AddIndexDialog.columnsTableHeader");
        public static final String COLUMNS_ADD_BUTTON_LABEL = AddIndexDialog.access$000().getString("AddIndexDialog.addButtonLabel");
        public static final String COLUMNS_REMOVE_BUTTON_LABEL = AddIndexDialog.access$000().getString("AddIndexDialog.removeButtonLabel");
    }
}

