/*
 * Decompiled with CFR 0.152.
 */
package net.steppschuh.markdowngenerator.table;

import java.util.ArrayList;
import java.util.List;
import net.steppschuh.markdowngenerator.MarkdownElement;
import net.steppschuh.markdowngenerator.MarkdownSerializationException;
import net.steppschuh.markdowngenerator.util.StringUtil;

public class TableRow<T>
extends MarkdownElement {
    private List<T> columns;

    public TableRow() {
        this.columns = new ArrayList<T>();
    }

    public TableRow(List<T> columns) {
        this.columns = columns;
    }

    @Override
    public String serialize() throws MarkdownSerializationException {
        StringBuilder sb = new StringBuilder();
        for (T item : this.columns) {
            if (item == null) {
                throw new MarkdownSerializationException("Column is null");
            }
            if (item.toString().contains("|")) {
                throw new MarkdownSerializationException("Column contains seperator char \"|\"");
            }
            sb.append("|");
            sb.append(StringUtil.surroundValueWith(item.toString(), " "));
            if (this.columns.indexOf(item) != this.columns.size() - 1) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    public List<T> getColumns() {
        return this.columns;
    }

    public void setColumns(List<T> columns) {
        this.columns = columns;
        this.invalidateSerialized();
    }
}

