/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.SecurityUtils;
import java.util.Locale;

public final class SystemInfo {
    private static boolean _isWindows = false;
    private static boolean _isWindowsNTor2000 = false;
    private static boolean _isWindowsXP = false;
    private static boolean _isWindowsVista = false;
    private static boolean _isWindows2003 = false;
    private static boolean _isClassicWindows = false;
    private static boolean _isWindows95 = false;
    private static boolean _isWindows98 = false;
    private static boolean _supportsTray = false;
    private static boolean _isMacClassic = false;
    private static boolean _isMacOSX = false;
    private static boolean _isLinux = false;
    private static boolean _isSolaris = false;

    private SystemInfo() {
    }

    public static String getJavaVersion() {
        return SecurityUtils.getProperty("java.version", "1.4.2");
    }

    public static String getJavaVendor() {
        return SecurityUtils.getProperty("java.vendor", "");
    }

    public static String getJavaClassVerion() {
        return SecurityUtils.getProperty("java.class.version", "");
    }

    public static String getOS() {
        return SecurityUtils.getProperty("os.name", "Windows XP");
    }

    public static String getOSVersion() {
        return SecurityUtils.getProperty("os.version", "");
    }

    public static String getOSArchitecture() {
        return SecurityUtils.getProperty("os.arch", "");
    }

    public static String getCurrentDirectory() {
        return SecurityUtils.getProperty("user.dir", "");
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static void setSupportsTray(boolean support) {
        _supportsTray = support;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isClassicWindows() {
        return _isClassicWindows;
    }

    public static boolean isWindowsNTor2000() {
        return _isWindowsNTor2000;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isWindowsVista() {
        return _isWindowsVista;
    }

    public static boolean isWindows95() {
        return _isWindows95;
    }

    public static boolean isWindows98() {
        return _isWindows98;
    }

    public static boolean isWindows2003() {
        return _isWindows2003;
    }

    public static boolean isMacClassic() {
        return _isMacClassic;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isAnyMac() {
        return _isMacClassic || _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    public static boolean isJdk13Above() {
        String s = SystemInfo.getJavaVersion();
        String sub = s.substring(0, 3);
        try {
            double version = Double.parseDouble(sub);
            return version >= 1.3;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isJdk142Above() {
        String s = SystemInfo.getJavaVersion();
        String sub = s.substring(0, 5);
        return sub.compareTo("1.4.2") >= 0;
    }

    public static boolean isJdk14Above() {
        String s = SystemInfo.getJavaVersion();
        String sub = s.substring(0, 3);
        try {
            double version = Double.parseDouble(sub);
            return version >= 1.4;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isJdk15Above() {
        String s = SystemInfo.getJavaVersion();
        String sub = s.substring(0, 3);
        try {
            double version = Double.parseDouble(sub);
            return version >= 1.5;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isJdk6Above() {
        String s = SystemInfo.getJavaVersion();
        String sub = s.substring(0, 3);
        try {
            double version = Double.parseDouble(sub);
            return version >= 1.6;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isJdk6u10Above() {
        String s = SystemInfo.getJavaVersion();
        String sub = s.substring(0, 3);
        String minor = s.substring(4, 5);
        String build = s.substring(6, 8);
        try {
            double majorVersion = Double.parseDouble(sub);
            double minorVersion = Double.parseDouble(minor);
            double buildVersion = Double.parseDouble(build);
            return majorVersion >= 1.6 && (minorVersion > 0.0 || buildVersion >= 10.0);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isJdk7Above() {
        String s = SystemInfo.getJavaVersion();
        String sub = s.substring(0, 3);
        try {
            double version = Double.parseDouble(sub);
            return version >= 1.7;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isCJKLocale() {
        return SystemInfo.isCJKLocale(Locale.getDefault());
    }

    public static boolean isCJKLocale(Locale locale) {
        return locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) || locale.equals(new Locale("zh", "HK")) || locale.equals(Locale.TAIWAN) || locale.equals(Locale.JAPAN) || locale.equals(Locale.JAPANESE) || locale.equals(Locale.KOREA) || locale.equals(Locale.KOREAN);
    }

    static {
        String os = SecurityUtils.getProperty("os.name", "Windows XP");
        _isWindows = os.indexOf("Windows") != -1;
        try {
            String osVersion = SecurityUtils.getProperty("os.version", "5.0");
            Float version = Float.valueOf(osVersion);
            _isClassicWindows = (double)version.floatValue() <= 4.0;
        }
        catch (NumberFormatException ex) {
            _isClassicWindows = false;
        }
        if (os.indexOf("Windows XP") != -1 || os.indexOf("Windows NT") != -1 || os.indexOf("Windows 2000") != -1) {
            _isWindowsNTor2000 = true;
        }
        if (os.indexOf("Windows XP") != -1) {
            _isWindowsXP = true;
        }
        if (os.indexOf("Windows Vista") != -1) {
            _isWindowsVista = true;
        }
        if (os.indexOf("Windows 2003") != -1) {
            _isWindows2003 = true;
            _isWindowsXP = true;
        }
        if (os.indexOf("Windows 95") != -1) {
            _isWindows95 = true;
        }
        if (os.indexOf("Windows 98") != -1) {
            _isWindows98 = true;
        }
        if (_isWindows) {
            _supportsTray = true;
        }
        _isSolaris = os.indexOf("Solaris") != -1 || os.indexOf("SunOS") != -1;
        boolean bl = _isLinux = os.indexOf("Linux") != -1;
        if (os.startsWith("Mac OS")) {
            if (os.endsWith("X")) {
                _isMacOSX = true;
            } else {
                _isMacClassic = true;
            }
        }
    }
}

