/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript;

import java.io.File;
import java.sql.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.action.ExportFileWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportPreferencesDAO;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ResultSetExportData;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.sql.QueryHolder;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.ProgressAbortFactoryCallbackImpl;

public class SQLToFileHandler
implements ISQLExecutionListener {
    private static final ILogger s_log = LoggerController.createLogger(SQLToFileHandler.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLToFileHandler.class);
    private ISession _session;
    private ISQLPanelAPI _sqlPaneAPI;
    private boolean _abortExecution = false;

    public SQLToFileHandler(ISession session, ISQLPanelAPI sqlPaneAPI) {
        this._session = session;
        this._sqlPaneAPI = sqlPaneAPI;
    }

    public String statementExecuting(String initialSql) {
        if (-1 == initialSql.toUpperCase().indexOf("@FILE")) {
            return initialSql;
        }
        IQueryTokenizer queryTokenizer = this._session.getQueryTokenizer();
        queryTokenizer.setScriptToTokenize(initialSql);
        StringBuilder sqlsNotToWriteToFile = new StringBuilder();
        while (queryTokenizer.hasQuery()) {
            String query = queryTokenizer.nextQuery().getQuery();
            if (!query.trim().toUpperCase().startsWith("@FILE")) {
                sqlsNotToWriteToFile.append(query);
                if (1 == queryTokenizer.getSQLStatementSeparator().length()) {
                    sqlsNotToWriteToFile.append(queryTokenizer.getSQLStatementSeparator()).append("\n");
                    continue;
                }
                sqlsNotToWriteToFile.append(" ").append(queryTokenizer.getSQLStatementSeparator()).append("\n");
                continue;
            }
            String sqlWithFilePrefix = query.trim();
            int fileBeginMarkerPos = sqlWithFilePrefix.indexOf(39);
            if (-1 == fileBeginMarkerPos) {
                Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("SQLToFileHandler.noFileBeginMarker"));
                continue;
            }
            int fileEndMarkerPos = sqlWithFilePrefix.indexOf(39, fileBeginMarkerPos + 1);
            if (-1 == fileEndMarkerPos) {
                Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("SQLToFileHandler.noFileEndMarker"));
                continue;
            }
            String fileName = sqlWithFilePrefix.substring(fileBeginMarkerPos + 1, fileEndMarkerPos).trim();
            File file = new File(fileName);
            String sqlToWriteToFile = sqlWithFilePrefix.substring(fileEndMarkerPos + 1).trim();
            TableExportPreferences prefs = TableExportPreferencesDAO.loadPreferences();
            prefs.setCsvFile(fileName);
            if (fileName.toUpperCase().endsWith("CSV")) {
                prefs.setFormatCSV(true);
                prefs.setFormatXLSOld(false);
                prefs.setFormatXLS(false);
                prefs.setFormatXML(false);
                prefs.setFormatJSON(false);
            } else if (fileName.toUpperCase().endsWith("XLS")) {
                prefs.setFormatCSV(false);
                prefs.setFormatXLSOld(true);
                prefs.setFormatXLS(false);
                prefs.setFormatXML(false);
                prefs.setFormatJSON(false);
            } else if (fileName.toUpperCase().endsWith("XLSX")) {
                prefs.setFormatCSV(false);
                prefs.setFormatXLSOld(false);
                prefs.setFormatXLS(true);
                prefs.setFormatXML(false);
                prefs.setFormatJSON(false);
            } else if (fileName.toUpperCase().endsWith("XML")) {
                prefs.setFormatCSV(false);
                prefs.setFormatXLSOld(false);
                prefs.setFormatXLS(false);
                prefs.setFormatXML(true);
                prefs.setFormatJSON(false);
            } else if (fileName.toUpperCase().endsWith("JSON")) {
                prefs.setFormatCSV(false);
                prefs.setFormatXLSOld(false);
                prefs.setFormatXLS(false);
                prefs.setFormatXML(false);
                prefs.setFormatJSON(true);
            }
            this.callResultSetExport(prefs, file, sqlToWriteToFile);
            if (!this._abortExecution) continue;
            this._abortExecution = false;
            break;
        }
        this._sqlPaneAPI.getSQLEntryPanel().requestFocus();
        if (0 == sqlsNotToWriteToFile.length()) {
            return null;
        }
        return sqlsNotToWriteToFile.toString();
    }

    private void callResultSetExport(TableExportPreferences prefs, File file, String sqlToWriteToFile) {
        try {
            Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("SQLToFileHandler.writing.file", new Object[]{file.getPath()}));
            Statement stat = this._session.getSQLConnection().createStatement();
            DialectType dialectType = DialectFactory.getDialectType((ISQLDatabaseMetaData)this._session.getMetaData());
            ProgressAbortFactoryCallbackImpl progressControllerFactory = new ProgressAbortFactoryCallbackImpl(this._session, sqlToWriteToFile, () -> file, stat);
            progressControllerFactory.getOrCreate(() -> this.onModalProgressDialogIsDisplaying(prefs, file, sqlToWriteToFile, stat, dialectType, progressControllerFactory));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void onModalProgressDialogIsDisplaying(TableExportPreferences prefs, File file, String sqlToWriteToFile, Statement stat, DialectType dialectType, ProgressAbortFactoryCallbackImpl progressControllerFactory) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> this.doWriteFile(prefs, file, sqlToWriteToFile, stat, dialectType, progressControllerFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteFile(TableExportPreferences prefs, File file, String sqlToWriteToFile, Statement stat, DialectType dialectType, ProgressAbortFactoryCallbackImpl progressControllerFactory) {
        try {
            ExportFileWriter.writeFile((TableExportPreferences)prefs, (IExportData)new ResultSetExportData(stat.executeQuery(sqlToWriteToFile), dialectType), (ProgressAbortCallback)progressControllerFactory.getOrCreate());
            Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("SQLToFileHandler.wrote.file", new Object[]{file.getPath()}));
        }
        catch (Throwable e) {
            s_log.error((Object)e);
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("SQLToFileHandler.error.writing.file", new Object[]{file.getPath(), e}));
            this._abortExecution = this._session.getProperties().getAbortOnError();
        }
        finally {
            progressControllerFactory.hideProgressMonitor();
        }
    }

    public void statementExecuted(QueryHolder sql) {
    }

    public void executionFinished() {
    }
}

