/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.RepaintManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.borders.NapkinBoxBorder;
import net.sourceforge.napkinlaf.borders.NapkinLineBorder;
import net.sourceforge.napkinlaf.borders.NapkinSelectedBorder;
import net.sourceforge.napkinlaf.borders.NapkinWrappedBorder;
import net.sourceforge.napkinlaf.fonts.MergedFont;
import net.sourceforge.napkinlaf.fonts.PatchedFontUIResource;
import net.sourceforge.napkinlaf.util.AlphaColorUIResource;
import net.sourceforge.napkinlaf.util.ComponentWalker;
import net.sourceforge.napkinlaf.util.NapkinConstants;
import net.sourceforge.napkinlaf.util.NapkinDebug;
import net.sourceforge.napkinlaf.util.NapkinIconFactory;
import net.sourceforge.napkinlaf.util.NapkinRepaintManager;
import net.sourceforge.napkinlaf.util.NapkinUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NapkinLookAndFeel
extends BasicLookAndFeel {
    private static final String[] UI_TYPES = new String[]{"ButtonUI", "CheckBoxMenuItemUI", "CheckBoxUI", "ColorChooserUI", "ComboBoxUI", "DesktopIconUI", "DesktopPaneUI", "EditorPaneUI", "FileChooserUI", "FormattedTextFieldUI", "InternalFrameUI", "LabelUI", "ListUI", "MenuBarUI", "MenuItemUI", "MenuUI", "OptionPaneUI", "PanelUI", "PasswordFieldUI", "PopupMenuSeparatorUI", "PopupMenuUI", "ProgressBarUI", "RadioButtonMenuItemUI", "RadioButtonUI", "RootPaneUI", "ScrollBarUI", "ScrollPaneUI", "SeparatorUI", "SliderUI", "SpinnerUI", "SplitPaneUI", "TabbedPaneUI", "TableHeaderUI", "TableUI", "TextAreaUI", "TextFieldUI", "TextPaneUI", "ToggleButtonUI", "ToolBarSeparatorUI", "ToolBarUI", "ToolTipUI", "TreeUI", "ViewportUI"};
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private static final Map<JComponent, Void> installedComponents = new WeakHashMap<JComponent, Void>();
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();

    public NapkinLookAndFeel() {
        Package sysPackage = Runtime.getRuntime().getClass().getPackage();
        String sysVer = sysPackage.getSpecificationVersion();
        if (sysVer.startsWith("1.5")) {
            new JLabel();
        }
    }

    @Override
    public String getDescription() {
        return "The Napkin Look and Feel";
    }

    @Override
    public String getID() {
        return "Napkin";
    }

    @Override
    public String getName() {
        return this.getID();
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String cName = NapkinLookAndFeel.class.getName();
        String basicPackageName = cName.replace("NapkinLookAndFeel", "Napkin");
        for (String uiType : UI_TYPES) {
            String uiClass = basicPackageName + uiType;
            table.put(uiType, uiClass);
        }
        HashSet keys = new HashSet(table.keySet());
        keys.removeAll(Arrays.asList(UI_TYPES));
        if (keys.size() != 0) {
            System.out.println("keys we didn't overwrite: " + keys);
        }
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        Color penColor = theme.getPenColor();
        Color bgColor = theme.getBackgroundColor();
        table.put("desktop", bgColor);
        table.put("activeCaption", bgColor);
        table.put("activeCaptionText", theme.getSelectionColor());
        table.put("activeCaptionBorder", penColor);
        table.put("inactiveCaption", bgColor);
        table.put("inactiveCaptionText", penColor);
        table.put("inactiveCaptionBorder", penColor);
        table.put("window", bgColor);
        table.put("windowBorder", penColor);
        table.put("windowText", penColor);
        table.put("text", bgColor);
        table.put("textText", penColor);
        table.put("textHighlight", theme.getHighlightColor());
        table.put("textHighlightText", penColor);
        table.put("textInactiveText", penColor);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        NapkinLookAndFeel.overrideComponentDefaults(table);
        UIDefaults.ActiveValue checkBoxButtonIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createCheckBoxIcon();
            }
        };
        UIDefaults.ActiveValue checkedMenuItemIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createCheckedMenuItemIcon();
            }
        };
        UIDefaults.ActiveValue radioButtonIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createRadioButtonIcon();
            }
        };
        UIDefaults.ActiveValue underlineBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinLineBorder(false);
            }
        };
        UIDefaults.ActiveValue selectBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinSelectedBorder();
            }
        };
        UIDefaults.ActiveValue boxBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinBoxBorder();
            }
        };
        UIDefaults.ActiveValue emptyBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinWrappedBorder(new EmptyBorder(3, 3, 3, 3));
            }
        };
        UIDefaults.ActiveValue downArrowIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(5, 8);
            }
        };
        UIDefaults.ActiveValue rightArrowIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(3, 8);
            }
        };
        UIDefaults.ActiveValue closeIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createXIcon(15);
            }
        };
        UIDefaults.ActiveValue minIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(1, 10);
            }
        };
        UIDefaults.ActiveValue iconIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(5, 10);
            }
        };
        NapkinLookAndFeel.setupActions(table);
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        NapkinTheme popupTheme = theme.getPopupTheme();
        Object[] napkinDefaults = new Object[]{"CheckBox.icon", checkBoxButtonIcon, "CheckBox.textIconGap", 0, "CheckBoxMenuItem.checkIcon", checkedMenuItemIcon, "CheckBoxMenuItem.foreground", popupTheme.getPenColor(), "CheckBoxMenuItem.selectionForeground", popupTheme.getSelectionColor(), "CheckBoxMenuItem.textIconGap", 0, "DesktopIcon.border", null, "FileChooser.detailsViewButtonToolTipText", "Details View", "FileChooser.detailsViewIcon", NapkinLookAndFeel.sketchedIcon("DetailsView"), "FileChooser.fileNameLabelText", "File Name(s):", "FileChooser.filesOfTypeLabelText", "Of Type(s):", "FileChooser.homeFolderIcon", NapkinLookAndFeel.sketchedIcon("HomeFolder"), "FileChooser.homeFolderToolTipText", "Home Folder", "FileChooser.listViewButtonToolTipText", "List View", "FileChooser.listViewIcon", NapkinLookAndFeel.sketchedIcon("ListView"), "FileChooser.lookInLabelText", "Look in:", "FileChooser.newFolderIcon", NapkinLookAndFeel.sketchedIcon("NewFolder"), "FileChooser.newFolderToolTipText", "New Folder", "FileChooser.saveInLabelText", "Save in:", "FileChooser.upFolderIcon", NapkinLookAndFeel.sketchedIcon("UpFolder"), "FileChooser.upFolderToolTipText", "Up One Level", "FileView.computerIcon", NapkinLookAndFeel.sketchedIcon("Computer"), "FileView.directoryIcon", NapkinLookAndFeel.sketchedIcon("Directory"), "FileView.fileIcon", NapkinLookAndFeel.sketchedIcon("File"), "FileView.floppyDriveIcon", NapkinLookAndFeel.sketchedIcon("FloppyDrive"), "FileView.hardDriveIcon", NapkinLookAndFeel.sketchedIcon("HardDrive"), "InternalFrame.activeTitleForeground", popupTheme.getSelectionColor(), "InternalFrame.border", emptyBorder, "InternalFrame.closeButtonToolTip", "Close", "InternalFrame.closeIcon", closeIcon, "InternalFrame.iconButtonToolTip", "Minimise", "InternalFrame.iconifyIcon", iconIcon, "InternalFrame.inactiveTitleForeground", popupTheme.getPenColor(), "InternalFrame.maxButtonToolTip", "Maximise", "InternalFrame.maximizeIcon", null, "InternalFrame.minimizeIcon", minIcon, "InternalFrame.restoreButtonToolTip", "Restore", "List.focusCellHighlightBorder", null, "Menu.arrowIcon", rightArrowIcon, "Menu.border", null, "MenuBar.border", null, "MenuItem.disabledForeground", popupTheme.getPenColor(), "MenuItem.foreground", popupTheme.getPenColor(), "MenuItem.selectionForeground", popupTheme.getSelectionColor(), "OptionPane.buttonAreaBorder", null, "OptionPane.errorIcon", NapkinLookAndFeel.sketchedIcon("Error"), "OptionPane.informationIcon", NapkinLookAndFeel.sketchedIcon("Information"), "OptionPane.messageAreaBorder", null, "OptionPane.questionIcon", NapkinLookAndFeel.sketchedIcon("Question"), "OptionPane.warningIcon", NapkinLookAndFeel.sketchedIcon("Warning"), "RadioButton.icon", radioButtonIcon, "RadioButton.textIconGap", 0, "PasswordField.border", underlineBorder, "PopupMenu.border", null, "PopupMenu.foreground", popupTheme.getPenColor(), "RadioButtonMenuItem.checkIcon", radioButtonIcon, "RadioButtonMenuItem.foreground", popupTheme.getPenColor(), "RadioButtonMenuItem.selectionForeground", popupTheme.getSelectionColor(), "RadioButtonMenuItem.textIconGap", 0, "RootPane.frameBorder", boxBorder, "RootPane.plainDialogBorder", boxBorder, "RootPane.informationDialogBorder", boxBorder, "RootPane.errorDialogBorder", boxBorder, "RootPane.colorChooserDialogBorder", boxBorder, "RootPane.fileChooserDialogBorder", boxBorder, "RootPane.questionDialogBorder", boxBorder, "RootPane.warningDialogBorder", boxBorder, "SplitPane.dividerSize", 9, "SplitPaneDivider.border", null, "TabbedPane.contentBorderInsets", NapkinBoxBorder.LARGE_DEFAULT_INSETS, "TabbedPane.tabsOverlapBorder", null, "Table.focusCellHighlightBorder", null, "Table.scrollPaneBorder", null, "TextArea.caretForeground", theme.getPenColor(), "TextField.border", underlineBorder, "TextField.caretForeground", theme.getPenColor(), "ToggleButton.border", selectBorder, "ToolTip.border", null, "ToolTip.foreground", popupTheme.getPenColor(), "Tree.closedIcon", rightArrowIcon, "Tree.collapsedIcon", null, "Tree.expandedIcon", null, "Tree.hash", theme.getPenColor(), "Tree.leafIcon", null, "Tree.openIcon", downArrowIcon, "Tree.selectionBorderColor", null};
        table.putDefaults(napkinDefaults);
    }

    private static Object sketchedIcon(final String templateName) {
        return new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createSketchedIcon(templateName);
            }
        };
    }

    private static void setupActions(UIDefaults table) {
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        Object[] actionDefaults = new Object[]{"TextField.focusInputMap", fieldInputMap, "PasswordField.focusInputMap", fieldInputMap, "TextArea.focusInputMap", multilineInputMap, "TextPane.focusInputMap", multilineInputMap, "EditorPane.focusInputMap", multilineInputMap};
        table.putDefaults(actionDefaults);
    }

    public static void overrideComponentDefaults(UIDefaults table) {
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        Map<String, Font> fontMap = NapkinLookAndFeel.fontNameMap(theme);
        HashMap<MergedFont, MergedFont> fontCache = new HashMap<MergedFont, MergedFont>();
        Font textFont = theme.getTextFont();
        Font boldFont = theme.getBoldTextFont();
        UIDefaults.ActiveValue drawnBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinBoxBorder();
            }
        };
        UIDefaults.ActiveValue compoundBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                NapkinBoxBorder outside = new NapkinBoxBorder();
                BasicBorders.MarginBorder inside = new BasicBorders.MarginBorder();
                return new CompoundBorder(outside, inside);
            }
        };
        AlphaColorUIResource clear = new AlphaColorUIResource(NapkinConstants.CLEAR);
        for (Map.Entry entry : table.entrySet()) {
            Object val;
            if (!(entry.getKey() instanceof String)) continue;
            String key = (String)entry.getKey();
            Object res = NapkinLookAndFeel.propVal(key, "font", val = entry.getValue(), table);
            if (res != null) {
                if (!(res instanceof Font) || !(res instanceof UIResource) || res instanceof PatchedFontUIResource) continue;
                Font resource = (Font)res;
                String name = resource.getFontName();
                Font font = fontMap.get(name);
                if (font == null) {
                    font = resource.isBold() ? boldFont : textFont;
                    System.err.println("unknown font: " + name + " for " + key);
                }
                if (PatchedFontUIResource.doesPatchWork()) {
                    MergedFont mFont = new MergedFont(font, resource);
                    if (fontCache.containsKey(mFont)) {
                        mFont = (MergedFont)fontCache.get(mFont);
                    } else {
                        fontCache.put(mFont, mFont);
                    }
                    font = mFont;
                }
                entry.setValue(font);
                continue;
            }
            res = NapkinLookAndFeel.propVal(key, "border", val, table);
            if (res != null) {
                if (!(res instanceof UIResource) && (!(val instanceof UIResource) || !(res instanceof BevelBorder) && !(res instanceof EtchedBorder) && !(res instanceof LineBorder) && !(res instanceof CompoundBorder))) continue;
                if (res instanceof CompoundBorder) {
                    entry.setValue(compoundBorder);
                    continue;
                }
                if (res instanceof EmptyBorder) continue;
                entry.setValue(drawnBorder);
                continue;
            }
            if (key.contains("Text") || key.startsWith("Password") || key.startsWith("Editor")) continue;
            if (key.endsWith(".foreground") || key.endsWith("BorderColor") || key.endsWith(".caretForeground") || key.endsWith(".acceleratorForeground") || key.endsWith(".disabledForeground") || key.endsWith(".inactiveForeground") || key.endsWith(".inactiveTitleForeground") || key.endsWith(".selectionForeground") || key.endsWith(".textForeground")) {
                entry.setValue(theme.getPenColor());
                continue;
            }
            if (key.endsWith(".background") || key.endsWith(".disabledBackground") || key.endsWith(".textBackground")) {
                entry.setValue(clear);
                continue;
            }
            if (key.endsWith(".selectionBackground") || key.endsWith("SelectionBackground")) {
                entry.setValue(NapkinConstants.HIGHLIGHT_CLEAR);
                continue;
            }
            if (!key.endsWith(".activeTitleForeground") && !key.endsWith("SelectionForeground")) continue;
            entry.setValue(theme.getSelectionColor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Font> fontNameMap(NapkinTheme theme) {
        Font dialogPlain = theme.getTextFont();
        Font dialogBold = theme.getBoldTextFont();
        Font serifPlain = theme.getTextFont();
        Font sansSerifPlain = theme.getTextFont();
        Font monospacedPlain = theme.getFixedFont();
        TreeMap<String, Font> fromName = new TreeMap<String, Font>(String.CASE_INSENSITIVE_ORDER);
        NapkinLookAndFeel.addToFontMap(fromName, "Dialog.plain", dialogPlain);
        NapkinLookAndFeel.addToFontMap(fromName, "Dialog.bold", dialogBold);
        NapkinLookAndFeel.addToFontMap(fromName, "Serif.plain", serifPlain);
        NapkinLookAndFeel.addToFontMap(fromName, "SansSerif.plain", sansSerifPlain);
        NapkinLookAndFeel.addToFontMap(fromName, "Monospaced.plain", monospacedPlain);
        InputStream fonts = NapkinLookAndFeel.class.getResourceAsStream("resources/fonts.properties");
        if (fonts != null) {
            try {
                Properties props = new Properties();
                props.load(fonts);
                fonts.close();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String fontName = (String)entry.getKey();
                    Font font = (Font)fromName.get(entry.getValue());
                    if (font == null) {
                        System.err.println("unknown font: " + fontName);
                        continue;
                    }
                    fromName.put(fontName, font);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                NapkinUtil.tryClose(fonts);
            }
        }
        return fromName;
    }

    private static void addToFontMap(Map<String, Font> map, String name, Font font) {
        map.put(name, font);
        map.put(name.replace(".", ""), font);
        if (name.endsWith(".plain")) {
            map.put(name.replace(".plain", ""), font);
        }
    }

    private static Object propVal(String key, String prop, Object val, UIDefaults table) {
        int keyLen = key.length();
        int propLen = prop.length();
        int prePos = keyLen - propLen - 1;
        Object result = null;
        if (prePos > 0 && (key.endsWith(prop) && key.charAt(prePos) == '.' || key.endsWith(prop.substring(1)) && key.charAt(prePos + 1) == Character.toUpperCase(prop.charAt(0)))) {
            result = NapkinLookAndFeel.extractVal(val, table);
        }
        return result;
    }

    private static Object extractVal(Object val, UIDefaults table) {
        if (val instanceof UIDefaults.LazyValue) {
            val = ((UIDefaults.LazyValue)val).createValue(table);
        } else if (val instanceof UIDefaults.ActiveValue) {
            val = ((UIDefaults.ActiveValue)val).createValue(table);
        }
        return val;
    }

    private static void wrapRepaintManager() {
        RepaintManager manager = RepaintManager.currentManager(null);
        RepaintManager.setCurrentManager(NapkinRepaintManager.wrap(manager));
    }

    private static void unwrapRepaintManager() {
        RepaintManager manager = RepaintManager.currentManager(null);
        RepaintManager.setCurrentManager(NapkinRepaintManager.unwrap(manager));
    }

    @Override
    public void initialize() {
        if (this.initialised.compareAndSet(false, true)) {
            NapkinLookAndFeel.wrapRepaintManager();
            super.initialize();
        }
    }

    @Override
    public void uninitialize() {
        if (this.initialised.compareAndSet(true, false)) {
            NapkinLookAndFeel.unwrapRepaintManager();
            super.uninitialize();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    if (!(UIManager.getLookAndFeel() instanceof NapkinLookAndFeel)) {
                        NapkinLookAndFeel.purgeAllInstalledComponents();
                    }
                }
            }).start();
        }
    }

    public static void registerComponent(JComponent component) {
        lock.writeLock().lock();
        installedComponents.put(component, null);
        lock.writeLock().unlock();
    }

    private static void purgeAllInstalledComponents() {
        lock.readLock().lock();
        for (JComponent component : installedComponents.keySet()) {
            if (!NapkinUtil.isNapkinInstalled(component)) continue;
            component.updateUI();
        }
        lock.readLock().unlock();
        lock.writeLock().lock();
        installedComponents.clear();
        lock.writeLock().unlock();
    }

    @Override
    public Icon getDisabledSelectedIcon(JComponent component, Icon icon) {
        return icon;
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        return icon;
    }

    static class DumpVisitor
    implements ComponentWalker.Visitor {
        private final PrintStream out;

        DumpVisitor(PrintStream out) {
            this.out = out;
        }

        public boolean visit(Component c, int depth) {
            for (int i = 0; i < depth; ++i) {
                this.out.print(i % 2 == 0 ? (char)'|' : '.');
                this.out.print(' ');
            }
            String desc = NapkinDebug.descFor(c);
            this.out.print(desc);
            this.out.println();
            return true;
        }
    }
}

