/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import net.sourceforge.napkinlaf.borders.NapkinCompoundBorder;
import net.sourceforge.napkinlaf.borders.NapkinLineBorder;
import net.sourceforge.napkinlaf.util.NapkinPainter;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinComboBoxUI
extends BasicComboBoxUI
implements NapkinPainter {
    private boolean wasLightWeightPopupEnabled;
    private Border oldBorder;

    public static ComponentUI createUI(JComponent c) {
        return new NapkinComboBoxUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.oldBorder = c.getBorder();
        c.setBorder(new NapkinCompoundBorder(new NapkinLineBorder(false), new EmptyBorder(0, 0, 3, 0)));
        NapkinUtil.installUI(c);
        this.wasLightWeightPopupEnabled = this.comboBox.isLightWeightPopupEnabled();
        this.comboBox.setLightWeightPopupEnabled(false);
    }

    public void uninstallUI(JComponent c) {
        this.comboBox.setLightWeightPopupEnabled(this.wasLightWeightPopupEnabled);
        NapkinUtil.uninstallUI(c);
        c.setBorder(this.oldBorder);
        super.uninstallUI(c);
    }

    protected JButton createArrowButton() {
        return NapkinUtil.createArrowButton(5);
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasTheFocus) {
    }

    public void update(Graphics g, JComponent c) {
        NapkinUtil.update(g, c, this);
    }

    public void superPaint(Graphics g, JComponent c) {
        super.update(g, c);
    }
}

