/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.netezza.exp;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ISequenceParentExtractor;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class NetezzaSequenceParentExtractorImpl
implements ISequenceParentExtractor {
    private static final ILogger s_log = LoggerController.createLogger(NetezzaSequenceParentExtractorImpl.class);
    private static final String SQL = "SELECT OBJNAME FROM _v_objs_owned where CLASS = 'SEQUENCE' and DATABASE = ? and OWNER = ? and OBJNAME like ? ";

    public String getSequenceParentQuery() {
        return SQL;
    }

    public void bindParameters(PreparedStatement pstmt, IDatabaseObjectInfo parentDbinfo, ObjFilterMatcher filterMatcher) throws SQLException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("bindParameters: database = " + parentDbinfo.getCatalogName()));
            s_log.debug((Object)("bindParameters: owner = " + parentDbinfo.getSchemaName()));
            s_log.debug((Object)("bindParameters: objname = " + filterMatcher.getSqlLikeMatchString()));
        }
        pstmt.setString(1, parentDbinfo.getCatalogName());
        pstmt.setString(2, parentDbinfo.getSchemaName());
        pstmt.setString(3, filterMatcher.getSqlLikeMatchString());
    }
}

