/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.functions.Expression;
import unity.operators.MergeSort;
import unity.operators.Operator;
import unity.operators.Projection;
import unity.operators.SetIntersect;
import unity.predicates.SortComparator;
import unity.query.GlobalQuery;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQIntersectNode
extends LQNode {
    private static final long serialVersionUID = 1L;

    public LQIntersectNode() {
        this.type = 11;
    }

    @Override
    public String generateSQL() {
        return "INTERSECT";
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        Relation relation = operatorArray[0].getOutputRelation();
        Relation relation2 = operatorArray[1].getOutputRelation();
        Expression[] expressionArray = new Expression[relation.getNumAttributes()];
        Expression[] expressionArray2 = new Expression[relation2.getNumAttributes()];
        boolean[] blArray = new boolean[2];
        this.outputRelation = Relation.unionCompatible(relation, relation2, expressionArray, expressionArray2, blArray);
        if (blArray[0]) {
            operatorArray[0] = new Projection(operatorArray[0], expressionArray, relation, this);
        }
        if (blArray[1]) {
            operatorArray[1] = new Projection(operatorArray[1], expressionArray2, relation2, this);
        }
        boolean[] blArray2 = new boolean[this.outputRelation.getNumAttributes()];
        int[] nArray = new int[blArray2.length];
        for (int i = 0; i < blArray2.length; ++i) {
            blArray2[i] = true;
            nArray[i] = i;
        }
        SortComparator sortComparator = new SortComparator(nArray, blArray2);
        MergeSort mergeSort = new MergeSort(operatorArray[0], this.getMemorySize(), sortComparator, this);
        MergeSort mergeSort2 = new MergeSort(operatorArray[1], this.getMemorySize(), sortComparator, this);
        SetIntersect setIntersect = new SetIntersect(new Operator[]{mergeSort, mergeSort2}, sortComparator, this.outputRelation);
        return setIntersect;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("INTERSECT ");
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }

    @Override
    public void computeCost() {
        long l = this.getChild(0).getRows();
        long l2 = this.getChild(0).getRows();
        this.cost = (double)(l + l2) * 1.0;
        this.rows = l + l2;
    }
}

