/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.util.BitSet;
import unity.query.DPNode;
import unity.query.LQNode;

public class DPTable {
    private DPNode[] table;
    private int size;

    public DPTable(int n) {
        this.table = new DPNode[1 << n];
        this.size = 1 << n;
    }

    public void insert(BitSet bitSet, DPNode dPNode) {
        this.table[DPTable.keyToIndex((BitSet)bitSet)] = dPNode;
    }

    public static int keyToIndex(BitSet bitSet) {
        int n = 0;
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            n += 1 << n2;
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return n;
    }

    public static BitSet indexToKey(int n) {
        BitSet bitSet = new BitSet();
        int n2 = 0;
        for (int i = n; i > 0; i /= 2) {
            if (i % 2 == 1) {
                bitSet.set(n2);
            }
            ++n2;
        }
        return bitSet;
    }

    public DPNode find(BitSet bitSet) {
        return this.table[DPTable.keyToIndex(bitSet)];
    }

    public void update(BitSet bitSet, LQNode lQNode) {
        this.table[DPTable.keyToIndex(bitSet)].setRoot(lQNode);
    }

    public int size() {
        return this.size;
    }

    public int findMin() {
        for (int i = this.table.length - 1; i >= 0; --i) {
            if (this.table[i] == null) continue;
            return i;
        }
        return 0;
    }
}

