/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.io.FileManager;
import unity.jdbc.UnityDriver;
import unity.operators.HashBuffer;
import unity.operators.Operator;
import unity.operators.PageHashTable;
import unity.predicates.JoinPredicate;
import unity.query.LQNode;
import unity.util.HashFunc;

public class DynamicHashJoin
extends Operator {
    private static final long serialVersionUID = 1L;
    private int numPartitions = 31;
    private JoinPredicate pred;
    private Relation inner;
    private Relation outer;
    private boolean isLeftOuterJoin;
    private boolean isRightOuterJoin;
    private Tuple nullLeftTuple;
    private Tuple nullRightTuple;
    private PageHashTable innerHashTable;
    private int frozen;
    private PageHashTable outerHashTable;
    private boolean processingFrozen;
    private int partitionNum;
    private boolean processingProbe;
    private ArrayList<byte[]> matches;
    private int curLoc;
    private Tuple probeTuple;
    private Tuple buildTuple;
    private boolean clearedHashTable;
    private BufferedInputStream probeFile;
    private boolean leftBuild;
    private HashBuffer hashTable;
    private boolean partitionInputDone;
    private boolean joinComplete;

    public DynamicHashJoin(Operator[] operatorArray, JoinPredicate joinPredicate, long l, boolean bl, boolean bl2, LQNode lQNode) {
        super(operatorArray, l);
        Object[] objectArray;
        this.pred = joinPredicate;
        this.matches = new ArrayList();
        this.queryNode = lQNode;
        this.inner = this.input[0].getOutputRelation();
        this.outer = this.input[1].getOutputRelation();
        Relation relation = new Relation(this.inner);
        relation.mergeRelation(this.outer);
        this.setOutputRelation(relation);
        this.isLeftOuterJoin = bl;
        this.isRightOuterJoin = bl2;
        if (this.isLeftOuterJoin) {
            objectArray = new Object[this.outer.getNumAttributes()];
            Arrays.fill(objectArray, null);
            this.nullRightTuple = new Tuple(objectArray, this.outer);
        }
        if (this.isRightOuterJoin) {
            objectArray = new Object[this.inner.getNumAttributes()];
            Arrays.fill(objectArray, null);
            this.nullLeftTuple = new Tuple(objectArray, this.inner);
        }
    }

    @Override
    public void init() throws SQLException {
        this.input[0].init();
        this.innerHashTable = new PageHashTable(this.numPartitions, this.MEMORY_SIZE_IN_BYTES, this.input[0].getOutputRelation(), this, "inner_" + this.hashCode());
        this.frozen = 0;
        this.partitionInner(this.input[0]);
        this.outerHashTable = new PageHashTable(this.numPartitions, 0L, this.input[1].getOutputRelation(), this, "outer_" + this.hashCode());
        this.input[1].init();
        for (int i = 0; i < this.frozen; ++i) {
            this.outerHashTable.initPartition(i, 2);
        }
        this.processingFrozen = false;
        this.leftBuild = true;
        this.probeTuple = new Tuple(this.outer);
        this.buildTuple = new Tuple(this.inner);
        this.clearedHashTable = false;
        this.joinComplete = false;
    }

    @Override
    public void close() throws SQLException {
        if (UnityDriver.DEBUG) {
            System.out.println("Operation: " + this.toString() + " Rows output: " + this.rowsOut + " IO bytes: " + this.IOBytes);
        }
        this.cleanup();
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        if (this.joinComplete) {
            return false;
        }
        block2: while (true) {
            if (this.processingProbe) {
                if (this.curLoc == this.matches.size()) {
                    this.processingProbe = false;
                    this.matches.clear();
                    continue;
                }
                ++this.curLoc;
                this.incrementRowsOut();
                if (this.leftBuild) {
                    this.buildTuple.setBytes(this.matches.get(this.curLoc - 1));
                    return this.outputJoinTuple(this.buildTuple, this.probeTuple, tuple);
                }
                this.buildTuple.setBytes(this.matches.get(this.curLoc - 1));
                return this.outputJoinTuple(this.probeTuple, this.buildTuple, tuple);
            }
            if (this.processingFrozen) {
                if (!this.partitionInputDone) {
                    while (this.probeTuple.read(this.probeFile)) {
                        int n = this.leftBuild ? this.pred.getHashKeyInput2(this.probeTuple) : this.pred.getHashKeyInput1(this.probeTuple);
                        this.hashTable.find(n, this.probeTuple, this.matches);
                        if (this.isLeftOuterJoin && !this.leftBuild) {
                            if (this.matches.size() == 0) {
                                this.matches.add(this.nullRightTuple.getBytes());
                            }
                        } else if (this.isRightOuterJoin && this.leftBuild && this.matches.size() == 0) {
                            this.matches.add(this.nullLeftTuple.getBytes());
                        }
                        this.curLoc = 0;
                        this.processingProbe = true;
                        if (this.matches.size() <= 0) continue;
                        continue block2;
                    }
                    try {
                        FileManager.closeFile(this.probeFile);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.curLoc = 0;
                    this.matches.clear();
                    if (this.isLeftOuterJoin && this.leftBuild) {
                        this.hashTable.getNonMatched(this.matches);
                        this.processingProbe = true;
                        this.probeTuple = this.nullRightTuple;
                        this.probeFile = null;
                        this.partitionInputDone = true;
                        continue;
                    }
                    if (this.isRightOuterJoin && !this.leftBuild) {
                        this.hashTable.getNonMatched(this.matches);
                        this.processingProbe = true;
                        this.probeTuple = this.nullLeftTuple;
                        this.probeFile = null;
                        this.partitionInputDone = true;
                        continue;
                    }
                }
                ++this.partitionNum;
                if (this.setupPartition()) continue;
                this.joinComplete = true;
                this.cleanup();
                return false;
            }
            while (this.input[1].next(this.probeTuple)) {
                int n = this.pred.getHashKeyInput2(this.probeTuple);
                if (this.probeTuple.getStatus() == 1) {
                    if (!this.isRightOuterJoin) continue;
                    this.curLoc = 0;
                    this.processingProbe = true;
                    this.matches.add(this.nullLeftTuple.getBytes());
                    continue block2;
                }
                int n2 = HashFunc.getPartition(n, this.numPartitions);
                if (n2 < this.frozen) {
                    this.outerHashTable.insert(n, this.probeTuple);
                    continue;
                }
                this.innerHashTable.probeHashTable(n2, n, this.probeTuple, this.matches);
                if (this.isRightOuterJoin && this.matches.size() == 0) {
                    this.matches.add(this.nullLeftTuple.getBytes());
                }
                if (this.matches.size() <= 0) continue;
                this.curLoc = 0;
                this.processingProbe = true;
                continue block2;
            }
            if (this.isLeftOuterJoin && !this.clearedHashTable) {
                this.matches.clear();
                for (int i = this.frozen; i < this.numPartitions; ++i) {
                    HashBuffer hashBuffer = this.innerHashTable.getHashTable(i);
                    if (hashBuffer == null) continue;
                    hashBuffer.getNonMatched(this.matches);
                }
                this.processingProbe = true;
                this.probeTuple = this.nullRightTuple;
                this.clearedHashTable = true;
                this.curLoc = 0;
                continue;
            }
            this.input[1].close();
            this.outerHashTable.close(2);
            this.processingFrozen = true;
            this.partitionNum = 0;
            if (!this.setupPartition()) break;
        }
        this.cleanup();
        this.joinComplete = true;
        return false;
    }

    private void partitionInner(Operator operator) throws SQLException {
        int n;
        Tuple tuple = new Tuple();
        while (operator.next(tuple)) {
            boolean bl;
            n = this.pred.getHashKeyInput1(tuple);
            if (tuple.getStatus() == 1) {
                if (!this.isLeftOuterJoin) continue;
                n = 0;
            }
            if (bl = this.innerHashTable.insert(n, tuple)) continue;
            this.purge();
        }
        operator.close();
        this.innerHashTable.close(2);
        for (n = this.frozen; n < this.numPartitions; ++n) {
            this.innerHashTable.buildHashTable(n, this.pred);
        }
    }

    private boolean setupPartition() throws SQLException {
        Tuple tuple;
        int n;
        Relation relation;
        int n2;
        int n3;
        BufferedInputStream bufferedInputStream = null;
        if (this.probeFile != null) {
            try {
                FileManager.closeFile(this.probeFile);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        while (true) {
            if (this.partitionNum >= this.frozen) {
                return false;
            }
            n3 = this.innerHashTable.getTuples(this.partitionNum);
            n2 = this.outerHashTable.getTuples(this.partitionNum);
            if (n3 > 0 && n2 > 0 || n3 > 0 && this.isLeftOuterJoin || n2 > 0 && this.isRightOuterJoin) break;
            ++this.partitionNum;
        }
        this.partitionInputDone = false;
        if (n2 < n3) {
            try {
                bufferedInputStream = FileManager.openInputFile(this.outerHashTable.getFileName(this.partitionNum));
                this.probeFile = FileManager.openInputFile(this.innerHashTable.getFileName(this.partitionNum));
                relation = this.outer;
            }
            catch (Exception exception) {
                try {
                    if (bufferedInputStream != null) {
                        FileManager.closeFile(bufferedInputStream);
                    }
                }
                catch (Exception exception2) {
                    throw new SQLException(exception2);
                }
                throw new SQLException(exception);
            }
            n = n2;
            this.leftBuild = false;
        } else {
            try {
                this.probeFile = FileManager.openInputFile(this.outerHashTable.getFileName(this.partitionNum));
                bufferedInputStream = FileManager.openInputFile(this.innerHashTable.getFileName(this.partitionNum));
                relation = this.inner;
            }
            catch (Exception exception) {
                try {
                    if (bufferedInputStream != null) {
                        FileManager.closeFile(bufferedInputStream);
                    }
                }
                catch (Exception exception3) {
                    throw new SQLException(exception3);
                }
                throw new SQLException(exception);
            }
            n = n3;
            this.leftBuild = true;
        }
        this.hashTable = new HashBuffer(n, this.pred, relation);
        if (this.leftBuild) {
            tuple = new Tuple(this.inner);
            this.probeTuple = new Tuple(this.outer);
            this.buildTuple = new Tuple(this.inner);
        } else {
            tuple = new Tuple(this.outer);
            this.probeTuple = new Tuple(this.inner);
            this.buildTuple = new Tuple(this.outer);
        }
        int n4 = 0;
        while (tuple.read(bufferedInputStream)) {
            n4 = this.leftBuild ? this.pred.getHashKeyInput1(tuple) : this.pred.getHashKeyInput2(tuple);
            byte[] byArray = new byte[tuple.getBytes().length];
            System.arraycopy(tuple.getBytes(), 0, byArray, 0, byArray.length);
            this.hashTable.insert(n4, byArray);
            this.incrementIOBytes(byArray.length);
        }
        try {
            FileManager.closeFile(bufferedInputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void cleanup() throws SQLException {
        this.innerHashTable.clear();
        this.outerHashTable.clear();
    }

    private void purge() throws SQLException {
        int n = this.frozen++;
        this.innerHashTable.purge(n);
    }

    private boolean outputJoinTuple(Tuple tuple, Tuple tuple2, Tuple tuple3) throws SQLException {
        tuple3.mergeTuple(tuple, tuple2, this.getOutputRelation(), true);
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("DYNAMIC HASH JOIN: ");
        stringBuilder.append(this.pred.toString(this.inner, this.outer));
        stringBuilder.append("   (BufferSizeInBytes=" + this.MEMORY_SIZE_IN_BYTES + " ; IsLeftOuter=" + this.isLeftOuterJoin + " ; IsRightOuter=" + this.isRightOuterJoin + ")");
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "DYNAMIC HASH JOIN";
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public double getCost() {
        long l = this.input[0].getRows();
        long l2 = this.input[1].getRows();
        int n = this.input[0].getRowSize();
        double d = 200.0;
        if (l * (long)n < this.MEMORY_SIZE_IN_BYTES) {
            d += (double)(l + l2) * 1.0;
        } else {
            d += (double)(l + l2) * 1.0;
            d += this.getIO() * 0.005;
        }
        return d;
    }

    @Override
    public double getIO() {
        long l = this.input[0].getRows();
        long l2 = this.input[1].getRows();
        int n = this.input[0].getRowSize();
        int n2 = this.input[1].getRowSize();
        if (l * (long)n < this.MEMORY_SIZE_IN_BYTES) {
            return 0.0;
        }
        return 3L * (l * (long)n + l2 * (long)n2);
    }
}

