/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import pig.jdbc.PigStatement;
import pig.query.PigOperation;
import pig.query.PigQuery;
import unity.engine.Attribute;
import unity.engine.Tuple;
import unity.operators.DistributedJoin;
import unity.operators.HadoopScan;
import unity.operators.Operator;
import unity.operators.ResultSetScan;
import unity.predicates.JoinPredicate;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.LQExprNode;
import unity.query.LQJoinNode;
import unity.query.LQNode;
import unity.query.LQProjNode;
import unity.query.LQTree;

public class DistributedJoinHDFS
extends DistributedJoin {
    private static final long serialVersionUID = 1L;
    private Tuple leftTuple;
    private boolean hasLeft;
    private String temporaryTableName;
    private String temporaryFilePath;
    private String outputPath;
    private FileSystem fileSystem;
    private Operator scan;

    public DistributedJoinHDFS(Operator[] operatorArray, JoinPredicate joinPredicate, boolean bl, GlobalQuery globalQuery) {
        super(operatorArray, joinPredicate, bl, globalQuery);
    }

    @Override
    public void init() throws SQLException {
        Serializable serializable;
        LQNode lQNode;
        int n = 0;
        int n2 = 1;
        this.input[n].init();
        this.leftTuple = new Tuple(this.firstRelation);
        this.hasLeft = true;
        if (!this.input[n].next(this.leftTuple)) {
            this.hasLeft = false;
            return;
        }
        this.temporaryTableName = "TEMP_TABLE";
        int n3 = this.swap ? 1 : 0;
        GQFieldRef gQFieldRef = (GQFieldRef)this.pred.getQueryNode().getChild(n3).getContent();
        GQTableRef gQTableRef = gQFieldRef.getTable();
        String string = gQTableRef.getAliasName();
        this.temporaryTableName = this.temporaryTableName + '_' + string;
        this.temporaryTableName = this.temporaryTableName + new Date().getTime();
        gQTableRef.setAliasName(this.temporaryTableName);
        GQTableRef gQTableRef2 = this.createTemporary(this.temporaryTableName);
        this.writeTuples(n);
        ResultSetScan resultSetScan = (ResultSetScan)this.input[n2];
        resultSetScan.init();
        PigStatement pigStatement = (PigStatement)resultSetScan.getResultSet().getStatement();
        this.outputPath = pigStatement.getOutputPath();
        LQNode lQNode2 = resultSetScan.getQueryNode();
        LQProjNode lQProjNode = (LQProjNode)lQNode2;
        for (int i = 0; i < this.firstRelation.getNumAttributes(); ++i) {
            lQNode = new LQExprNode();
            lQNode.setType(100);
            serializable = this.firstRelation.getAttribute(i);
            lQNode.setContent(((Attribute)serializable).getReference());
            lQProjNode.addNoDupExpression((LQExprNode)lQNode);
        }
        LQExprNode lQExprNode = new LQExprNode();
        lQExprNode.setType(6);
        lQExprNode.setContent(gQTableRef2);
        lQNode = new LQJoinNode();
        ((LQJoinNode)lQNode).setCondition(this.pred.getQueryNode());
        serializable = lQNode2.getChild();
        lQNode.addChild(lQExprNode);
        lQNode.addChild((LQNode)serializable);
        ((LQNode)serializable).setParent(lQNode);
        lQNode2.setChild(0, lQNode);
        lQNode.setParent(lQNode2);
        LQTree.printTree(lQNode2, 0);
        this.scan = this.doPigJoin();
        this.scan.init();
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        return this.scan.next(tuple);
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (!this.hasLeft) {
            return;
        }
        try {
            this.scan.close();
            this.fileSystem.deleteOnExit(new Path(this.temporaryFilePath));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void writeTuples(int n) throws SQLException {
        try {
            this.fileSystem = FileSystem.get((Configuration)new Configuration());
            this.temporaryFilePath = "/tmp/" + this.temporaryTableName;
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)this.fileSystem.create(new Path(this.temporaryFilePath), true)));
            do {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.leftTuple.getObject(0));
                for (int i = 1; i < this.firstRelation.getNumAttributes(); ++i) {
                    stringBuilder.append("\t");
                    stringBuilder.append(this.leftTuple.getObject(i));
                }
                stringBuilder.append("\n");
                System.out.println(stringBuilder.toString());
                bufferedWriter.write(stringBuilder.toString());
            } while (this.input[n].next(this.leftTuple));
            bufferedWriter.close();
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    private GQTableRef createTemporary(String string) {
        return GQTableRef.createTemporaryTableRef(string, string);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DISTRIBUTED JOIN (temp. table): ");
        if (this.swap) {
            stringBuffer.append(this.pred.toString(this.secondRelation, this.firstRelation));
        } else {
            stringBuffer.append(this.pred.toString(this.firstRelation, this.secondRelation));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getName() {
        return "DISTRIBUTED JOIN (with temp. table)";
    }

    @Override
    public String getDescription() {
        return "";
    }

    private Operator doPigJoin() throws SQLException {
        ArrayList<PigOperation> arrayList = new ArrayList<PigOperation>();
        arrayList.add(new PigOperation("A = LOAD '" + this.temporaryFilePath + "';", "A", this.firstRelation));
        arrayList.add(new PigOperation("B = LOAD '" + this.outputPath + "';", "B", this.secondRelation));
        if (this.swap) {
            arrayList.add(new PigOperation("C = JOIN B BY $" + this.secondRelationJoinAttrs[0] + ", A BY $" + this.firstRelationJoinAttrs[0] + ";", "C", this.outputRelation));
        } else {
            arrayList.add(new PigOperation("C = JOIN A BY $" + this.firstRelationJoinAttrs[0] + ", B BY $" + this.secondRelationJoinAttrs[0] + ";", "C", this.outputRelation));
        }
        PigQuery pigQuery = new PigQuery(arrayList);
        System.out.println(pigQuery.toString());
        pigQuery.execute();
        this.scan = new HadoopScan(pigQuery.getOutputPath(), this.outputRelation);
        return this.scan;
    }
}

