/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import unity.jdbc.UnityDriver;

public class UnityDataSource
implements DataSource,
Referenceable,
Serializable {
    protected static UnityDriver unityDriver = null;
    private static final long serialVersionUID = 1L;
    protected PrintWriter logWriter = null;
    protected String encoding = null;
    protected String url = null;
    protected boolean pooled = true;
    protected String password = "";
    protected int logintimeout = 0;

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "unity.jdbc.UnityDataSourceFactory", null);
        reference.add(new StringRefAddr("url", this.url));
        reference.add(new StringRefAddr("password", this.password));
        return reference;
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        return this.getConnection(this.getProps());
    }

    protected Connection getConnection(Properties properties) throws SQLException {
        UnityDriver unityDriver = new UnityDriver();
        return unityDriver.connect(this.url, this.getProps());
    }

    @Override
    public Connection getConnection() throws SQLException {
        UnityDriver unityDriver = new UnityDriver();
        Properties properties = new Properties();
        return unityDriver.connect(this.url, properties);
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.logintimeout = n;
    }

    @Override
    public int getLoginTimeout() {
        return this.logintimeout;
    }

    public Properties getProps() {
        Properties properties = new Properties();
        properties.setProperty("password", this.password);
        properties.setProperty("loginTimeout", String.valueOf(this.getLoginTimeout()));
        return properties;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            unityDriver = (UnityDriver)Class.forName("unity.jdbc.UnityDriver").newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(UnityDriver.i18n.getString("UnityDataSource.ErrorCannotLoadDriver"));
        }
    }
}

