/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;

public class Interval
extends Expression {
    private static final long serialVersionUID = 1L;
    private Expression valueExpr;
    private int intervalType;
    private Object value;

    public Interval(Expression expression, int n) {
        this.valueExpr = expression;
        this.intervalType = n;
    }

    public Interval(Object object, int n) {
        this.value = object;
        this.intervalType = n;
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        this.value = this.valueExpr.evaluate(tuple);
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public Date add(Date date, boolean bl) {
        if (date == null) {
            return null;
        }
        if (this.value == null) {
            return null;
        }
        boolean bl2 = bl;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        boolean bl3 = date instanceof Timestamp;
        try {
            int n = 0;
            if (this.value instanceof Integer) {
                n = (Integer)this.value;
                if (!bl2) {
                    n *= -1;
                }
            } else {
                String string = this.value.toString();
                if (this.intervalType == 10000 || this.intervalType == 10001 || this.intervalType == 10002 || this.intervalType == 10004 || this.intervalType == 10005 || this.intervalType == 10006 || this.intervalType == 10007 || this.intervalType == 10008 || this.intervalType == 10003) {
                    n = Integer.parseInt(string);
                    if (!bl2) {
                        n *= -1;
                    }
                } else {
                    int n2;
                    int[] nArray = new int[6];
                    String string2 = "";
                    int n3 = 0;
                    boolean bl4 = false;
                    for (n2 = 0; n2 < string.length(); ++n2) {
                        char c = string.charAt(n2);
                        if (c == ' ' || c == ':' || c == '-' || c == '.') {
                            if (string2.length() > 0) {
                                nArray[n3++] = Integer.parseInt(string2);
                            }
                            string2 = "";
                            if (c == '.') {
                                bl4 = true;
                            }
                            if (c != '-' || n2 != 0) continue;
                            bl2 = !bl2;
                            continue;
                        }
                        string2 = string2 + c;
                    }
                    if (string2.length() > 0) {
                        if (bl4) {
                            nArray[n3++] = Integer.parseInt(string2);
                            for (n2 = 0; n2 < 6 - string2.length(); ++n2) {
                                int n4 = n3 - 1;
                                nArray[n4] = nArray[n4] * 10;
                            }
                        } else {
                            nArray[n3++] = Integer.parseInt(string2);
                        }
                    }
                    if (!bl2) {
                        n2 = 0;
                        while (n2 < n3) {
                            int n5 = n2++;
                            nArray[n5] = nArray[n5] * -1;
                        }
                    }
                    if (this.intervalType == 10009) {
                        if (n3 >= 2) {
                            ((Calendar)gregorianCalendar).add(2, nArray[1]);
                        }
                        if (n3 >= 1) {
                            ((Calendar)gregorianCalendar).add(1, nArray[0]);
                        }
                    } else if (this.intervalType == 10010) {
                        bl3 = true;
                        if (n3 >= 2) {
                            ((Calendar)gregorianCalendar).add(11, nArray[1]);
                        }
                        if (n3 >= 1) {
                            ((Calendar)gregorianCalendar).add(5, nArray[0]);
                        }
                    } else if (this.intervalType == 10011) {
                        bl3 = true;
                        if (n3 >= 3) {
                            ((Calendar)gregorianCalendar).add(12, nArray[2]);
                        }
                        if (n3 >= 2) {
                            ((Calendar)gregorianCalendar).add(11, nArray[1]);
                        }
                        if (n3 >= 1) {
                            ((Calendar)gregorianCalendar).add(5, nArray[0]);
                        }
                    } else if (this.intervalType == 10012) {
                        bl3 = true;
                        if (n3 >= 4) {
                            ((Calendar)gregorianCalendar).add(13, nArray[3]);
                        }
                        if (n3 >= 3) {
                            ((Calendar)gregorianCalendar).add(12, nArray[2]);
                        }
                        if (n3 >= 2) {
                            ((Calendar)gregorianCalendar).add(11, nArray[1]);
                        }
                        if (n3 >= 1) {
                            ((Calendar)gregorianCalendar).add(5, nArray[0]);
                        }
                    } else if (this.intervalType == 10013) {
                        bl3 = true;
                        if (n3 >= 4) {
                            ((Calendar)gregorianCalendar).add(13, nArray[3]);
                        }
                        if (n3 >= 3) {
                            ((Calendar)gregorianCalendar).add(12, nArray[2]);
                        }
                        if (n3 >= 2) {
                            ((Calendar)gregorianCalendar).add(11, nArray[1]);
                        }
                        if (n3 >= 1) {
                            ((Calendar)gregorianCalendar).add(5, nArray[0]);
                        }
                        if (n3 >= 5) {
                            return this.addMicroSecond(gregorianCalendar, nArray[4]);
                        }
                    } else if (this.intervalType == 10014) {
                        bl3 = true;
                        if (n3 >= 2) {
                            ((Calendar)gregorianCalendar).add(12, nArray[1]);
                        }
                        if (n3 >= 1) {
                            ((Calendar)gregorianCalendar).add(11, nArray[0]);
                        }
                    } else if (this.intervalType == 10015) {
                        bl3 = true;
                        if (n3 >= 3) {
                            ((Calendar)gregorianCalendar).add(13, nArray[2]);
                        }
                        if (n3 >= 2) {
                            ((Calendar)gregorianCalendar).add(12, nArray[1]);
                        }
                        if (n3 >= 1) {
                            ((Calendar)gregorianCalendar).add(11, nArray[0]);
                        }
                    } else if (this.intervalType == 10016) {
                        bl3 = true;
                        if (n3 >= 3) {
                            ((Calendar)gregorianCalendar).add(13, nArray[2]);
                        }
                        if (n3 >= 2) {
                            ((Calendar)gregorianCalendar).add(12, nArray[1]);
                        }
                        if (n3 >= 1) {
                            ((Calendar)gregorianCalendar).add(11, nArray[0]);
                        }
                        if (n3 >= 4) {
                            return this.addMicroSecond(gregorianCalendar, nArray[3]);
                        }
                    } else if (this.intervalType == 10017) {
                        bl3 = true;
                        if (n3 >= 2) {
                            ((Calendar)gregorianCalendar).add(13, nArray[1]);
                        }
                        if (n3 >= 1) {
                            ((Calendar)gregorianCalendar).add(12, nArray[0]);
                        }
                    } else if (this.intervalType == 10018) {
                        bl3 = true;
                        if (n3 >= 2) {
                            ((Calendar)gregorianCalendar).add(13, nArray[1]);
                        }
                        if (n3 >= 1) {
                            ((Calendar)gregorianCalendar).add(12, nArray[0]);
                        }
                        if (n3 >= 3) {
                            return this.addMicroSecond(gregorianCalendar, nArray[2]);
                        }
                    } else if (this.intervalType == 10019) {
                        bl3 = true;
                        if (n3 >= 1) {
                            ((Calendar)gregorianCalendar).add(13, nArray[0]);
                        }
                        if (n3 >= 2) {
                            return this.addMicroSecond(gregorianCalendar, nArray[1]);
                        }
                    }
                }
            }
            if (this.intervalType == 10000) {
                ((Calendar)gregorianCalendar).add(1, n);
            } else if (this.intervalType == 10001) {
                ((Calendar)gregorianCalendar).add(2, n * 3);
            } else if (this.intervalType == 10002) {
                ((Calendar)gregorianCalendar).add(2, n);
            } else if (this.intervalType == 10003) {
                ((Calendar)gregorianCalendar).add(5, n * 7);
            } else if (this.intervalType == 10004) {
                ((Calendar)gregorianCalendar).add(5, n);
            } else if (this.intervalType == 10005) {
                bl3 = true;
                ((Calendar)gregorianCalendar).add(11, n);
            } else if (this.intervalType == 10006) {
                bl3 = true;
                ((Calendar)gregorianCalendar).add(12, n);
            } else if (this.intervalType == 10007) {
                bl3 = true;
                ((Calendar)gregorianCalendar).add(13, n);
            } else if (this.intervalType == 10008) {
                bl3 = true;
                return this.addMicroSecond(gregorianCalendar, n);
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (bl3) {
            return new Timestamp(gregorianCalendar.getTime().getTime());
        }
        return new java.sql.Date(gregorianCalendar.getTime().getTime());
    }

    private Timestamp addMicroSecond(Calendar calendar, int n) {
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        int n2 = timestamp.getNanos();
        int n3 = (n2 += n * 1000) / 1000000000;
        if (n2 < 0) {
            n2 = 1000000000 + n2;
            --n3;
        } else {
            n2 %= 1000000000;
        }
        if (n3 != 0) {
            calendar.add(13, n3);
            timestamp.setTime(calendar.getTime().getTime());
        }
        timestamp.setNanos(n2);
        return timestamp;
    }

    @Override
    public String toString(Relation relation) {
        return "INTERVAL " + this.valueExpr.toString(relation) + " " + Interval.typeName(this.intervalType);
    }

    public static String typeName(int n) {
        switch (n) {
            case 10000: {
                return "YEAR";
            }
            case 10001: {
                return "QUARTER";
            }
            case 10002: {
                return "MONTH";
            }
            case 10003: {
                return "WEEK";
            }
            case 10004: {
                return "DAY";
            }
            case 10005: {
                return "HOUR";
            }
            case 10006: {
                return "MINUTE";
            }
            case 10007: {
                return "SECOND";
            }
            case 10008: {
                return "MICROSECOND";
            }
            case 10009: {
                return "YEAR_MONTH";
            }
            case 10010: {
                return "DAY_HOUR";
            }
            case 10011: {
                return "DAY_MINUTE";
            }
            case 10013: {
                return "DAY_MICROSECOND";
            }
            case 10014: {
                return "HOUR_MINUTE";
            }
            case 10015: {
                return "HOUR_SECOND";
            }
            case 10016: {
                return "HOUR_MICROSECOND";
            }
            case 10017: {
                return "MINUTE_SECOND";
            }
            case 10018: {
                return "MINUTE_MICROSECOND";
            }
            case 10019: {
                return "SECOND_MICROSECOND";
            }
        }
        return "";
    }

    public static int[] getIntervalTypes() {
        return new int[]{10000, 10001, 10002, 10003, 10004, 10005, 10006, 10007, 10009, 10010, 10011, 10014, 10015, 10017, 10008, 10013, 10016, 10018, 10019};
    }

    public static Interval parseInterval(String string) {
        try {
            int n;
            int[] nArray = new int[6];
            String string2 = "";
            int n2 = 0;
            boolean bl = false;
            String string3 = string;
            boolean bl2 = true;
            for (n = 0; n < string3.length(); ++n) {
                char c = string3.charAt(n);
                if (c == ' ' || c == ':' || c == '-' || c == '.') {
                    if (string2.length() > 0) {
                        nArray[n2++] = Integer.parseInt(string2);
                    }
                    string2 = "";
                    if (c == '.') {
                        bl = true;
                    }
                    if (c != '-' || n != 0) continue;
                    bl2 = !bl2;
                    continue;
                }
                string2 = string2 + c;
            }
            if (string2.length() > 0) {
                if (bl) {
                    nArray[n2++] = Integer.parseInt(string2);
                    for (n = 0; n < 6 - string2.length(); ++n) {
                        int n3 = n2 - 1;
                        nArray[n3] = nArray[n3] * 10;
                    }
                } else {
                    nArray[n2++] = Integer.parseInt(string2);
                }
            }
            if (n2 == 0) {
                return null;
            }
            if (n2 == 1) {
                return new Interval(string, 10005);
            }
            if (n2 == 2) {
                return new Interval(string, 10005);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String outputTimestamp(String string, int n) {
        int n2 = string.length() - 1;
        String string2 = null;
        if (n == 10005) {
            string2 = ":00:00";
        } else if (n == 10006) {
            string2 = ":00";
        }
        if (string2 != null) {
            if (string.charAt(n2) == '\'') {
                return string.substring(0, n2) + string2 + "'";
            }
            return string + "'" + string2 + "'";
        }
        return string;
    }
}

