/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class AcrylTabbedPaneUI
extends BaseTabbedPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new AcrylTabbedPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.tabAreaInsets.bottom = 5;
    }

    protected Color[] getTabColors(int tabIndex, boolean isSelected, boolean isRollover) {
        if (tabIndex >= 0 && tabIndex < this.tabPane.getTabCount()) {
            boolean isEnabled = this.tabPane.isEnabledAt(tabIndex);
            Color backColor = this.tabPane.getBackgroundAt(tabIndex);
            Color[] colorArr = AbstractLookAndFeel.getTheme().getTabColors();
            colorArr = backColor instanceof UIResource ? (isSelected ? AbstractLookAndFeel.getTheme().getDefaultColors() : (isRollover && isEnabled ? AbstractLookAndFeel.getTheme().getRolloverColors() : AbstractLookAndFeel.getTheme().getTabColors())) : (isSelected ? ColorHelper.createColorArr(ColorHelper.brighter(backColor, 60.0), backColor, 20) : (isRollover && isEnabled ? ColorHelper.createColorArr(ColorHelper.brighter(backColor, 80.0), ColorHelper.brighter(backColor, 20.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(backColor, 40.0), ColorHelper.darker(backColor, 10.0), 20)));
            return colorArr;
        }
        return AbstractLookAndFeel.getTheme().getTabColors();
    }

    protected Color[] getContentBorderColors(int tabPlacement) {
        Color[] SEP_COLORS = new Color[]{ColorHelper.brighter(AbstractLookAndFeel.getControlColorLight(), 20.0), AbstractLookAndFeel.getControlColorLight(), ColorHelper.brighter(AbstractLookAndFeel.getControlColorDark(), 20.0), AbstractLookAndFeel.getControlColorDark(), ColorHelper.darker(AbstractLookAndFeel.getControlColorDark(), 20.0)};
        return SEP_COLORS;
    }

    protected Color getContentBorderColor() {
        return ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 50.0);
    }

    protected Color getLoBorderColor(int tabIndex) {
        if (tabIndex == this.tabPane.getSelectedIndex() && this.tabPane.getBackgroundAt(tabIndex) instanceof ColorUIResource) {
            return ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 10.0);
        }
        return super.getLoBorderColor(tabIndex);
    }

    protected Font getTabFont(boolean isSelected) {
        if (isSelected) {
            return super.getTabFont(isSelected).deriveFont(1);
        }
        return super.getTabFont(isSelected);
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Color backColor = this.tabPane.getBackgroundAt(tabIndex);
        if (!(backColor instanceof UIResource)) {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            return;
        }
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            Graphics2D g2D = (Graphics2D)g;
            Object savedRenderingHint = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            v.paint(g, textRect);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
            }
        } else {
            int mnemIndex = -1;
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            }
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                if (isSelected) {
                    Color shadowColor = ColorHelper.darker(AbstractLookAndFeel.getWindowTitleColorDark(), 30.0);
                    g.setColor(shadowColor);
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x - 1, textRect.y - 1 + metrics.getAscent());
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x - 1, textRect.y + 1 + metrics.getAscent());
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x + 1, textRect.y - 1 + metrics.getAscent());
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x + 1, textRect.y + 1 + metrics.getAscent());
                    g.setColor(AbstractLookAndFeel.getTheme().getTabSelectionForegroundColor());
                } else {
                    g.setColor(this.tabPane.getForegroundAt(tabIndex));
                }
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }
}

