/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstituteRoot;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ObjectResultTabController;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ObjectResultTabControllerListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.QueryListCreator;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.QueryListCreatorListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.WaitPanel;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.WaitPanelListener;

public class ObjectResultController {
    private static ILogger s_log = LoggerController.createLogger(ObjectResultController.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ObjectResultController.class);
    private JTabbedPane _objectResultTabbedPane;
    private ISession _session;
    private HibernatePluginResources _resource;

    public ObjectResultController(ISession session, HibernatePluginResources resource) {
        this._session = session;
        this._resource = resource;
        SessionProperties props = session.getProperties();
        this._objectResultTabbedPane = UIFactory.getInstance().createTabbedPane(props.getSQLExecutionTabPlacement());
    }

    public JTabbedPane getPanel() {
        return this._objectResultTabbedPane;
    }

    public void displayObjects(HibernateConnection con, String hqlQuery, boolean limitObjectCount, int limitObjectCountVal, boolean useSessionConnection) {
        int maxNumResults = -1;
        if (limitObjectCount) {
            maxNumResults = limitObjectCountVal;
        }
        QueryListCreatorListener queryListCreatorListener = new QueryListCreatorListener(){

            @Override
            public void queryExecuted(QueryListCreator queryListCreator) {
                ObjectResultController.this.onQueryExecuted(queryListCreator);
            }
        };
        WaitPanelListener waitPanelListener = new WaitPanelListener(){

            @Override
            public void removeWaitPanel(WaitPanel waitPanel) {
                ObjectResultController.this.onCloseTab(waitPanel);
            }
        };
        WaitPanel waitPanel = new WaitPanel(hqlQuery, this._resource, waitPanelListener);
        this._objectResultTabbedPane.addTab(waitPanel.getTitle(), waitPanel);
        this._objectResultTabbedPane.setSelectedComponent(waitPanel);
        new QueryListCreator(queryListCreatorListener, hqlQuery, maxNumResults, useSessionConnection, con, this._session, waitPanel).execute();
    }

    private void onQueryExecuted(QueryListCreator queryListCreator) {
        List<ObjectSubstituteRoot> list;
        this.removeOldErrorPanel(queryListCreator.getWaitPanel());
        if (queryListCreator.getWaitPanel().isDisplayingError()) {
            return;
        }
        for (int i = 0; i < this._objectResultTabbedPane.getTabCount(); ++i) {
            if (this._objectResultTabbedPane.getComponentAt(i) != queryListCreator.getWaitPanel()) continue;
            this._objectResultTabbedPane.removeTabAt(i);
            break;
        }
        if (null == (list = queryListCreator.getList())) {
            return;
        }
        ObjectResultTabControllerListener l = new ObjectResultTabControllerListener(){

            @Override
            public void closeTab(ObjectResultTabController toClose) {
                ObjectResultController.this.onCloseTab(toClose.getPanel());
            }
        };
        String hqlQuery = queryListCreator.getHqlQuery();
        int maxNumResults = queryListCreator.getMaxNumResults();
        HibernateConnection con = queryListCreator.getConnection();
        ObjectResultTabController ortc = new ObjectResultTabController(list, maxNumResults, con, hqlQuery, this._resource, l, this._session);
        int titelLen = Math.min(hqlQuery.length(), 14);
        String title = hqlQuery.trim().substring(0, titelLen).replaceAll("\n", " ");
        this._objectResultTabbedPane.addTab(title, ortc.getPanel());
        this._objectResultTabbedPane.setSelectedComponent(ortc.getPanel());
    }

    private void removeOldErrorPanel(WaitPanel currentWaitPanel) {
        for (int i = 0; i < this._objectResultTabbedPane.getTabCount(); ++i) {
            if (currentWaitPanel == this._objectResultTabbedPane.getComponentAt(i) || !(this._objectResultTabbedPane.getComponentAt(i) instanceof WaitPanel) || !((WaitPanel)this._objectResultTabbedPane.getComponentAt(i)).isDisplayingError()) continue;
            this._objectResultTabbedPane.removeTabAt(i);
            break;
        }
    }

    private void onCloseTab(JPanel panel) {
        for (int i = 0; i < this._objectResultTabbedPane.getTabCount(); ++i) {
            if (this._objectResultTabbedPane.getComponentAt(i) != panel) continue;
            this._objectResultTabbedPane.removeTabAt(i);
            break;
        }
    }
}

