/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.RCParam;

class ReflectionCaller {
    private Object _callee;
    private boolean _treatClassCalleeAsType;

    ReflectionCaller() {
        this(null);
    }

    ReflectionCaller(Object callee) {
        this(callee, true);
    }

    ReflectionCaller(Object callee, boolean treatClassCalleeAsType) {
        this._callee = callee;
        this._treatClassCalleeAsType = treatClassCalleeAsType;
    }

    ReflectionCaller getClass(String className, ClassLoader cl) {
        return new ReflectionCaller(ReflectionCaller.getClassPlain(className, cl), this._treatClassCalleeAsType);
    }

    public static Class getClassPlain(String className, ClassLoader cl) {
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    ReflectionCaller callConstructor(Class[] paramTypes, Object[] params) {
        try {
            Constructor constr = this.getCalleeClass().getDeclaredConstructor(paramTypes);
            return new ReflectionCaller(constr.newInstance(params));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ReflectionCaller newInstance() {
        try {
            return new ReflectionCaller(this.getCalleeClass().newInstance(), this._treatClassCalleeAsType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    List<ReflectionCaller> callArrayMethod(String methodName) {
        try {
            Method meth = this.getDeclaredMethodIncludingSuper(methodName, new Class[0]);
            Object[] callees = (Object[])meth.invoke(this._callee, new Object[0]);
            ArrayList<ReflectionCaller> ret = new ArrayList<ReflectionCaller>();
            for (Object callee : callees) {
                ret.add(new ReflectionCaller(callee, this._treatClassCalleeAsType));
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Object getCallee() {
        return this._callee;
    }

    Collection<ReflectionCaller> callCollectionMethod(String methodName) {
        try {
            Method meth = this.getDeclaredMethodIncludingSuper(methodName, new Class[0]);
            meth.setAccessible(true);
            Collection callees = (Collection)meth.invoke(this._callee, new Object[0]);
            ArrayList<ReflectionCaller> ret = new ArrayList<ReflectionCaller>();
            for (Object callee : callees) {
                ret.add(new ReflectionCaller(callee, this._treatClassCalleeAsType));
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    ReflectionCaller getField(String fieldName) {
        try {
            return new ReflectionCaller(this.getCalleeClass().getDeclaredField(fieldName).get(this._callee), this._treatClassCalleeAsType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Class getCalleeClass() {
        if (this._treatClassCalleeAsType && this._callee instanceof Class) {
            return (Class)this._callee;
        }
        return this._callee.getClass();
    }

    ReflectionCaller callMethod(String methodName) {
        return this.callMethod(methodName, new RCParam(new Object[0]));
    }

    ReflectionCaller callMethod(String methodName, Object ... params) {
        return this.callMethod(methodName, new RCParam(params));
    }

    ReflectionCaller callMethod(String methodName, RCParam param) {
        try {
            Class[] paramTypes = new Class[param.size()];
            Object[] paramValues = new Object[param.size()];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypes[i] = param.getType(i);
                paramValues[i] = param.getValue(i);
            }
            Method meth = this.getDeclaredMethodIncludingSuper(methodName, paramTypes);
            meth.setAccessible(true);
            return new ReflectionCaller(meth.invoke(this._callee, paramValues), this._treatClassCalleeAsType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Method getDeclaredMethodIncludingSuper(String methodName, Class ... paramTypes) throws NoSuchMethodException {
        NoSuchMethodException throwBuf = new NoSuchMethodException(methodName);
        for (Class clazz = this.getCalleeClass(); null != clazz; clazz = clazz.getSuperclass()) {
            try {
                Method ret = clazz.getDeclaredMethod(methodName, paramTypes);
                ret.setAccessible(true);
                return ret;
            }
            catch (NoSuchMethodException e) {
                throwBuf = e;
                for (Class<?> anInterface : clazz.getInterfaces()) {
                    try {
                        Method ret = anInterface.getDeclaredMethod(methodName, paramTypes);
                        if (!ret.isDefault()) continue;
                        ret.setAccessible(true);
                        return ret;
                    }
                    catch (NoSuchMethodException e2) {
                        throwBuf = e2;
                    }
                }
                continue;
            }
        }
        throw throwBuf;
    }

    public static void main(String[] args) {
        ReflectionCaller c = new ReflectionCaller(Integer.class);
        System.out.println(c.getCalleeClass().getName());
    }

    ReflectionCaller callStaticMethod(ClassLoader cl, String className, String methName, Class[] paramTypes, Object[] args) {
        try {
            Class<?> clazz = cl.loadClass(className);
            Method method = clazz.getDeclaredMethod(methName, paramTypes);
            method.setAccessible(true);
            return new ReflectionCaller(method.invoke(clazz, args), this._treatClassCalleeAsType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ReflectionCaller setTreatClassCalleeAsType(boolean b) {
        this._treatClassCalleeAsType = b;
        return this;
    }
}

