/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;
import net.sourceforge.squirrel_sql.fw.completion.util.CompletionParser;
import net.sourceforge.squirrel_sql.plugins.hibernate.completion.MappingInfoProvider;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.PropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.MappedClassInfoData;

public class MappedClassInfo
extends CompletionInfo {
    private CompletionParser _lastParser;
    private MappedClassInfoData _mappedClassInfoData;
    private PropertyInfo[] _propertyInfos;

    public MappedClassInfo(MappedClassInfoData mappedClassInfoData) {
        this._mappedClassInfoData = mappedClassInfoData;
        this._propertyInfos = new PropertyInfo[this._mappedClassInfoData.getHibernatePropertyInfos().length + 1];
        this._propertyInfos[0] = new PropertyInfo(this._mappedClassInfoData.getIndentifierHibernatePropertyInfo(), this._mappedClassInfoData.getMappedClassName());
        for (int i = 0; i < this._mappedClassInfoData.getHibernatePropertyInfos().length; ++i) {
            this._propertyInfos[i + 1] = new PropertyInfo(this._mappedClassInfoData.getHibernatePropertyInfos()[i], this._mappedClassInfoData.getMappedClassName());
        }
    }

    public String getCompareString() {
        if (null != this._lastParser && this._mappedClassInfoData.getMappedClassName().startsWith(this._lastParser.getStringToParse())) {
            return this._mappedClassInfoData.getMappedClassName();
        }
        return this._mappedClassInfoData.getSimpleMappedClassName();
    }

    public boolean matches(CompletionParser parser, boolean matchNameExact, boolean stateless) {
        if (!stateless) {
            this._lastParser = parser;
        }
        if (matchNameExact) {
            return this._mappedClassInfoData.getMappedClassName().equals(parser.getStringToParse()) || this._mappedClassInfoData.getSimpleMappedClassName().equals(parser.getStringToParse());
        }
        return this._mappedClassInfoData.getMappedClassName().startsWith(parser.getStringToParse()) || this._mappedClassInfoData.getSimpleMappedClassName().startsWith(parser.getStringToParse());
    }

    public boolean hasColumns() {
        return true;
    }

    public ArrayList<PropertyInfo> getQualifiedMatchingAttributes(CompletionParser parser) {
        String propertyChainBegin;
        ArrayList<PropertyInfo> ret = new ArrayList<PropertyInfo>();
        String stringToParse = parser.getStringToParse();
        if (stringToParse.startsWith(this._mappedClassInfoData.getMappedClassName() + ".")) {
            propertyChainBegin = stringToParse.substring((this._mappedClassInfoData.getMappedClassName() + ".").length());
        } else if (stringToParse.startsWith(this._mappedClassInfoData.getSimpleMappedClassName() + ".")) {
            propertyChainBegin = stringToParse.substring((this._mappedClassInfoData.getSimpleMappedClassName() + ".").length());
        } else {
            return ret;
        }
        ArrayList<String> props = this.getArrayFormChain(propertyChainBegin);
        PropertyInfo[] propInfoBuf = this._propertyInfos;
        block0: for (int i = 0; i < props.size(); ++i) {
            for (PropertyInfo propertyInfo : propInfoBuf) {
                if (!propertyInfo.matchesUnQualified(props.get(i))) continue;
                if (i == props.size() - 1) {
                    ret.add(propertyInfo);
                    continue;
                }
                if (i >= props.size() - 1 || !props.get(i).equals(propertyInfo.getHibernatePropertyInfo().getPropertyName())) continue;
                propInfoBuf = new PropertyInfo[]{};
                MappedClassInfo mappedClassInfo = propertyInfo.getMappedClassInfo();
                if (null == mappedClassInfo) continue block0;
                propInfoBuf = mappedClassInfo.getAttributes();
                continue block0;
            }
        }
        return ret;
    }

    private ArrayList<String> getArrayFormChain(String propertyChainBegin) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(propertyChainBegin.split("\\.")));
        if (propertyChainBegin.endsWith(".")) {
            ret.add("");
        }
        return ret;
    }

    public Collection<? extends CompletionInfo> getMatchingAttributes(CompletionParser parser) {
        ArrayList<PropertyInfo> ret = new ArrayList<PropertyInfo>();
        for (PropertyInfo propertyInfo : this._propertyInfos) {
            if (!propertyInfo.matchesUnQualified(parser.getLastToken())) continue;
            ret.add(propertyInfo);
        }
        return ret;
    }

    public boolean isSame(String name) {
        return this._mappedClassInfoData.getMappedClassName().equals(name) || this._mappedClassInfoData.getSimpleMappedClassName().equals(name);
    }

    public String getClassName() {
        return this._mappedClassInfoData.getMappedClassName();
    }

    public String getSimpleClassName() {
        return this._mappedClassInfoData.getSimpleMappedClassName();
    }

    public String[] getAttributeNames() {
        String[] ret = new String[this._propertyInfos.length];
        for (int i = 0; i < this._propertyInfos.length; ++i) {
            ret[i] = this._propertyInfos[i].getCompareString();
        }
        return ret;
    }

    public PropertyInfo getAttributeByName(String attrName) {
        for (PropertyInfo propertyInfo : this._propertyInfos) {
            if (!propertyInfo.getCompareString().equals(attrName)) continue;
            return propertyInfo;
        }
        return null;
    }

    public PropertyInfo[] getAttributes() {
        return this._propertyInfos;
    }

    public String getTableName() {
        return this._mappedClassInfoData.getTableName();
    }

    public void initAttributesWithClassInfo(MappingInfoProvider mappingInfoProvider) {
        for (PropertyInfo propertyInfo : this._propertyInfos) {
            propertyInfo.setMappedClassInfo(mappingInfoProvider.getExactMappedClassInfoFor(propertyInfo.getHibernatePropertyInfo().getClassName()));
        }
    }

    public boolean isPlainValueArray() {
        return this._mappedClassInfoData.isPlainValueArray();
    }
}

