/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.exportconfig.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.builders.DefaultFormBuilder;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.exportconfig.ExportConfigPreferences;

public class ExportPanelBuilder {
    private static final ILogger s_log = LoggerController.createLogger(ExportPanelBuilder.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExportPanelBuilder.class);
    private final ControlMediator _mediator = new ControlMediator();
    private JCheckBox _exportPrefsChk;
    private JTextField _exportPrefsText;
    private JButton _exportPrefsBtn;
    private JCheckBox _exportDriversChk;
    private JTextField _exportDriversText;
    private JButton _exportDriversBtn;
    private JCheckBox _exportAliasesChk;
    private JTextField _exportAliasesText;
    private JButton _exportAliasesBtn;
    private JCheckBox _includeUserNamesChk;
    private JCheckBox _includePasswordsChk;
    private JButton _exportBtn = null;
    private JButton _cancelBtn = null;
    private IApplication _app = null;
    private JPanel _panel = null;

    public ExportPanelBuilder(IApplication app) {
        this._app = app;
    }

    public JPanel buildPanel(ExportConfigPreferences prefs) {
        this.initComponents(prefs);
        FormLayout layout = new FormLayout("12dlu, left:max(40dlu;pref), 3dlu, 150dlu:grow(1.0), 3dlu, right:max(40dlu;pref), 3dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setLeadingColumnOffset(1);
        builder.appendSeparator(s_stringMgr.getString("ExportPanel.prefs"));
        builder.append((Component)this._exportPrefsChk);
        builder.append((Component)this._exportPrefsText);
        builder.append((Component)this._exportPrefsBtn);
        builder.nextLine();
        builder.appendSeparator(s_stringMgr.getString("ExportPanel.drivers"));
        builder.append((Component)this._exportDriversChk);
        builder.append((Component)this._exportDriversText);
        builder.append((Component)this._exportDriversBtn);
        builder.nextLine();
        builder.appendSeparator(s_stringMgr.getString("ExportPanel.aliases"));
        builder.append((Component)this._exportAliasesChk);
        builder.append((Component)this._exportAliasesText);
        builder.append((Component)this._exportAliasesBtn);
        builder.setLeadingColumnOffset(3);
        builder.nextLine();
        builder.append((Component)this._includeUserNamesChk);
        builder.nextLine();
        builder.append((Component)this._includePasswordsChk);
        builder.setLeadingColumnOffset(1);
        builder.nextLine();
        builder.appendSeparator();
        builder.append((Component)this.createButtonBar(), 5);
        this._panel = builder.getPanel();
        return this._panel;
    }

    public void writeToPerferences(ExportConfigPreferences prefs) {
        if (prefs == null) {
            throw new IllegalArgumentException("ExportConfigPreferences == null");
        }
        prefs.setExportPreferences(this._exportPrefsChk.isSelected());
        prefs.setExportDrivers(this._exportDriversChk.isSelected());
        prefs.setExportAliases(this._exportAliasesChk.isSelected());
        prefs.setPreferencesFileName(this._exportPrefsText.getText());
        prefs.setDriversFileName(this._exportDriversText.getText());
        prefs.setAliasesFileName(this._exportAliasesText.getText());
        prefs.setIncludeUserNames(this._includeUserNamesChk.isSelected());
        prefs.setIncludePasswords(this._includePasswordsChk.isSelected());
    }

    private void updateControlStatus() {
        boolean isSelected = this._exportPrefsChk.isSelected();
        this._exportPrefsText.setEditable(isSelected);
        this._exportPrefsBtn.setEnabled(isSelected);
        isSelected = this._exportDriversChk.isSelected();
        this._exportDriversText.setEditable(isSelected);
        this._exportDriversBtn.setEnabled(isSelected);
        isSelected = this._exportAliasesChk.isSelected();
        this._exportAliasesText.setEditable(isSelected);
        this._exportAliasesBtn.setEnabled(isSelected);
        this._includeUserNamesChk.setEnabled(isSelected);
        this._includePasswordsChk.setEnabled(isSelected);
    }

    private void initComponents(ExportConfigPreferences prefs) {
        String export = s_stringMgr.getString("ExportPanel.export");
        this._exportPrefsChk = new JCheckBox(export);
        this._exportDriversChk = new JCheckBox(export);
        this._exportAliasesChk = new JCheckBox(export);
        this._exportPrefsText = new JTextField();
        this._exportDriversText = new JTextField();
        this._exportAliasesText = new JTextField();
        String btnTitle = s_stringMgr.getString("ExportPanel.browse");
        this._exportPrefsBtn = new JButton(btnTitle);
        this._exportDriversBtn = new JButton(btnTitle);
        this._exportAliasesBtn = new JButton(btnTitle);
        String cancel = s_stringMgr.getString("ExportPanel.cancel");
        this._exportBtn = new JButton(export);
        this._cancelBtn = new JButton(cancel);
        this._includeUserNamesChk = new JCheckBox(s_stringMgr.getString("ExportPanel.includeusers"));
        this._includePasswordsChk = new JCheckBox(s_stringMgr.getString("ExportPanel.includepasswords"));
        this._exportPrefsChk.addActionListener(this._mediator);
        this._exportDriversChk.addActionListener(this._mediator);
        this._exportAliasesChk.addActionListener(this._mediator);
        this._exportPrefsBtn.addActionListener(new BrowseButtonListener(this._exportPrefsText));
        this._exportDriversBtn.addActionListener(new BrowseButtonListener(this._exportDriversText));
        this._exportAliasesBtn.addActionListener(new BrowseButtonListener(this._exportAliasesText));
        this._exportBtn.addActionListener(new ExportButtonListener());
        this._cancelBtn.addActionListener(new CancelButtonListener());
        this._exportPrefsChk.setSelected(prefs.getExportPreferences());
        this._exportDriversChk.setSelected(prefs.getExportDrivers());
        this._exportAliasesChk.setSelected(prefs.getExportAliases());
        this._includeUserNamesChk.setSelected(prefs.getIncludeUserNames());
        this._includePasswordsChk.setSelected(prefs.getIncludePasswords());
        this._exportPrefsText.setText(prefs.getPreferencesFileName());
        this._exportDriversText.setText(prefs.getDriversFileName());
        this._exportAliasesText.setText(prefs.getAliasesFileName());
        this.updateControlStatus();
    }

    private JPanel createButtonBar() {
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        builder.addGridded((JComponent)this._exportBtn);
        builder.addRelatedGap();
        builder.addGridded((JComponent)this._cancelBtn);
        return builder.getPanel();
    }

    private String getFileName(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            s_log.error((Object)s_stringMgr.getString("exportconfig.errorReslovingFileName"), (Throwable)ex);
            return file.getAbsolutePath();
        }
    }

    private boolean confirmOverwrite(File f) throws CancelledException {
        String title = s_stringMgr.getString("ExportPanel.confirmoverwritetitle");
        String message = s_stringMgr.getString("ExportPanel.confirmoverwritemsg", new Object[]{f.getAbsolutePath()});
        int option = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(this._panel), message, title, 1);
        if (option == 0) {
            return true;
        }
        if (option == 2) {
            throw new CancelledException();
        }
        return false;
    }

    private class CancelledException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private CancelledException() {
        }
    }

    private final class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SwingUtilities.getRoot(ExportPanelBuilder.this._panel).setVisible(false);
        }
    }

    private final class ExportButtonListener
    implements ActionListener {
        private ExportButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            boolean succeeded = false;
            boolean cancelled = false;
            Exception ex = null;
            try {
                File f;
                if (ExportPanelBuilder.this._exportPrefsChk.getModel().isSelected() && (!(f = new File(ExportPanelBuilder.this._exportPrefsText.getText())).exists() || ExportPanelBuilder.this.confirmOverwrite(f))) {
                    SquirrelPreferences prefs = ExportPanelBuilder.this._app.getSquirrelPreferences();
                    new XMLBeanWriter((Object)prefs).save(f);
                }
                if (ExportPanelBuilder.this._exportDriversChk.getModel().isSelected() && (!(f = new File(ExportPanelBuilder.this._exportDriversText.getText())).exists() || ExportPanelBuilder.this.confirmOverwrite(f))) {
                    ExportPanelBuilder.this._app.getDataCache().saveDrivers(f);
                }
                if (ExportPanelBuilder.this._exportAliasesChk.getModel().isSelected() && (!(f = new File(ExportPanelBuilder.this._exportAliasesText.getText())).exists() || ExportPanelBuilder.this.confirmOverwrite(f))) {
                    ExportPanelBuilder.this._app.getDataCache().saveAliases(f);
                }
                succeeded = true;
            }
            catch (CancelledException e) {
                cancelled = true;
                ex = e;
            }
            catch (Exception e) {
                ex = e;
            }
            String outcomeMessage = "";
            String title = "";
            int optionType = 0;
            if (cancelled) {
                outcomeMessage = s_stringMgr.getString("ExportPanel.cancelledmessage");
                title = s_stringMgr.getString("ExportPanel.cancelledtitle");
                optionType = 1;
            }
            if (succeeded) {
                outcomeMessage = s_stringMgr.getString("ExportPanel.successmessage");
                title = s_stringMgr.getString("ExportPanel.successtitle");
                optionType = 1;
            }
            if (!succeeded && !cancelled) {
                outcomeMessage = s_stringMgr.getString("ExportPanel.failedmessage", new Object[]{ex.getMessage()});
                title = s_stringMgr.getString("ExportPanel.failedtitle");
                optionType = 0;
            }
            SwingUtilities.getRoot(ExportPanelBuilder.this._panel).setVisible(false);
            JOptionPane.showMessageDialog(SwingUtilities.getRoot(ExportPanelBuilder.this._panel), outcomeMessage, title, optionType);
        }
    }

    private final class BrowseButtonListener
    implements ActionListener {
        private final JTextField _tf;

        BrowseButtonListener(JTextField tf) {
            this._tf = tf;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter((FileFilter)new FileExtensionFilter("XML files", new String[]{".xml"}));
            chooser.setSelectedFile(new File(this._tf.getText()));
            if (chooser.showSaveDialog(null) == 0) {
                this._tf.setText(ExportPanelBuilder.this.getFileName(chooser.getSelectedFile()));
            }
        }
    }

    private final class ControlMediator
    implements ActionListener {
        private ControlMediator() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ExportPanelBuilder.this.updateControlStatus();
        }
    }
}

