/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.plugins.syntax.AutoCorrectData;
import net.sourceforge.squirrel_sql.plugins.syntax.AutoCorrectDlg;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;

public class AutoCorrectController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AutoCorrectController.class);
    private AutoCorrectDlg _dlg;
    private SyntaxPlugin _syntaxPugin;

    public AutoCorrectController(SyntaxPlugin syntaxPugin, Frame parent) {
        this._syntaxPugin = syntaxPugin;
        this._dlg = new AutoCorrectDlg(parent);
        AutoCorrectData autoCorrectData = syntaxPugin.getAutoCorrectProviderImpl().getAutoCorrectData();
        Vector<Vector> data = new Vector<Vector>();
        Enumeration<String> e = autoCorrectData.getAutoCorrectsHash().keys();
        while (e.hasMoreElements()) {
            String error = e.nextElement();
            Vector<String> row2 = new Vector<String>();
            row2.add(error);
            String corr = autoCorrectData.getAutoCorrectsHash().get(error);
            row2.add(corr);
            data.add(row2);
        }
        data.sort(Comparator.comparing(row -> (String)row.get(0)));
        Vector<String> colHeaders = new Vector<String>();
        colHeaders.add(s_stringMgr.getString("syntax.errAbrev"));
        colHeaders.add(s_stringMgr.getString("syntax.corExt"));
        DefaultTableModel dtm = new DefaultTableModel();
        dtm.setDataVector(data, colHeaders);
        this._dlg.tblAutoCorrects.setModel(dtm);
        this._dlg.chkEnable.setSelected(autoCorrectData.isEnableAutoCorrects());
        this._dlg.setSize(550, 500);
        GUIUtils.centerWithinParent((Window)this._dlg);
        this._dlg.setVisible(true);
        this._dlg.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoCorrectController.this.onApply();
            }
        });
        this._dlg.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoCorrectController.this.onNew();
            }
        });
        this._dlg.btnRemoveRows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoCorrectController.this.onRemoveRows();
            }
        });
        this._dlg.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoCorrectController.this.onClose();
            }
        });
        this._dlg.tblAutoCorrects.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AutoCorrectController.this.onSelectionChanged(e);
            }
        });
        this._dlg.tblAutoCorrects.getSelectionModel().setSelectionInterval(0, 0);
    }

    private void onSelectionChanged(ListSelectionEvent e) {
        if (1 == this._dlg.tblAutoCorrects.getSelectedRows().length) {
            int selRow = this._dlg.tblAutoCorrects.getSelectedRows()[0];
            DefaultTableModel dtm = (DefaultTableModel)this._dlg.tblAutoCorrects.getModel();
            Vector<Vector> dataVector = dtm.getDataVector();
            Vector row = dataVector.get(selRow);
            this._dlg._txtAbreviation.setText((String)row.get(0));
            String correction = (String)row.get(1);
            this._dlg._txtCorrection.setText(correction);
        } else {
            this._dlg._txtAbreviation.setText(null);
            this._dlg._txtCorrection.setText(null);
        }
    }

    private void onClose() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onRemoveRows() {
        DefaultTableModel dtm = (DefaultTableModel)this._dlg.tblAutoCorrects.getModel();
        int selRow = this._dlg.tblAutoCorrects.getSelectedRow();
        while (-1 != selRow) {
            dtm.removeRow(selRow);
            selRow = this._dlg.tblAutoCorrects.getSelectedRow();
        }
        this.save();
    }

    private void onApply() {
        if (StringUtilities.isEmpty((String)this._dlg._txtAbreviation.getText(), (boolean)true) || StringUtilities.isEmpty((String)this._dlg._txtCorrection.getText(), (boolean)true)) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this._dlg.tblAutoCorrects.getModel();
        Vector<Vector> dataVector = dtm.getDataVector();
        boolean found = false;
        for (int i = 0; i < dataVector.size(); ++i) {
            Vector row = dataVector.get(i);
            if (!this._dlg._txtAbreviation.getText().equalsIgnoreCase((String)row.get(0))) continue;
            row.set(1, this._dlg._txtCorrection.getText());
            dtm.fireTableRowsUpdated(i, i);
            found = true;
            break;
        }
        if (!found) {
            Vector<String> row = new Vector<String>();
            row.add(this._dlg._txtAbreviation.getText());
            row.add(this._dlg._txtCorrection.getText());
            dtm.addRow(row);
            this._dlg.tblAutoCorrects.getSelectionModel().setSelectionInterval(dtm.getRowCount() - 1, dtm.getRowCount() - 1);
            Rectangle cellRect = this._dlg.tblAutoCorrects.getCellRect(dtm.getRowCount() - 1, 0, true);
            this._dlg.tblAutoCorrects.scrollRectToVisible(cellRect);
        }
        this.save();
    }

    private void save() {
        DefaultTableModel dtm = (DefaultTableModel)this._dlg.tblAutoCorrects.getModel();
        Vector<Vector> dataVector = dtm.getDataVector();
        Hashtable<String, String> newAutoCorrects = new Hashtable<String, String>();
        for (int i = 0; i < dataVector.size(); ++i) {
            Vector row = dataVector.get(i);
            String error = (String)row.get(0);
            String corr = (String)row.get(1);
            if (null == error || null == corr || 0 == error.trim().length() || 0 == corr.trim().length() || error.equals(corr)) continue;
            newAutoCorrects.put(error.trim().toUpperCase(), corr);
        }
        this._syntaxPugin.getAutoCorrectProviderImpl().setAutoCorrects(newAutoCorrects, this._dlg.chkEnable.isSelected());
    }

    private void onNew() {
        this._dlg.tblAutoCorrects.clearSelection();
    }
}

