/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.tab;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourcePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourceTab;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfigFactory;
import net.sourceforge.squirrel_sql.client.util.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class PostgresSourceTab
extends BaseSourceTab {
    public static final int VIEW_TYPE = 0;
    public static final int STORED_PROC_TYPE = 1;
    public static final int TRIGGER_TYPE = 2;
    protected int sourceType = 0;
    private static final ILogger s_log = LoggerController.createLogger(PostgresSourceTab.class);
    private static CommentSpec[] commentSpecs = new CommentSpec[]{new CommentSpec("/*", "*/"), new CommentSpec("--", "\n")};
    private static CodeReformator formatter = new CodeReformator(CodeReformatorConfigFactory.createConfig((String)";", (CommentSpec[])commentSpecs));

    public PostgresSourceTab(String hint) {
        super(hint);
    }

    protected BaseSourcePanel createSourcePanel() {
        return new PostgresSourcePanel(this.getSession());
    }

    private final class PostgresSourcePanel
    extends BaseSourcePanel {
        private static final long serialVersionUID = 1L;

        PostgresSourcePanel(ISession session) {
            super(session);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(ISession session, PreparedStatement stmt) {
            this.getTextArea().setText("");
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery();
                StringBuilder buf = new StringBuilder(4096);
                while (rs.next()) {
                    String nextString = rs.getString(1);
                    if (PostgresSourceTab.this.sourceType == 1) {
                        buf.append(nextString);
                    }
                    if (PostgresSourceTab.this.sourceType == 2) {
                        buf.append(nextString.trim());
                        buf.append(" ");
                    }
                    if (PostgresSourceTab.this.sourceType != 0) continue;
                    buf.append(nextString.trim());
                    buf.append(" ");
                }
                if (PostgresSourceTab.this.sourceType == 0 || PostgresSourceTab.this.sourceType == 2) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("View source before formatting: " + buf.toString()));
                    }
                    this.getTextArea().setText(formatter.reformat(buf.toString()));
                } else {
                    this.getTextArea().setText(buf.toString());
                }
                this.getTextArea().setCaretPosition(0);
            }
            catch (SQLException ex) {
                session.showErrorMessage((Throwable)ex);
            }
            finally {
                SQLUtilities.closeResultSet((ResultSet)rs);
            }
        }
    }
}

