/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionExpressionImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.FunctionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/LocalFunctionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "ktFun", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "generateFunctionDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "generateLambda", "ktLambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "ir.psi2ir"})
public final class LocalFunctionGenerator
extends StatementGeneratorExtension {
    public LocalFunctionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkNotNullParameter(statementGenerator, "statementGenerator");
        super(statementGenerator);
    }

    @NotNull
    public final IrStatement generateLambda(@NotNull KtLambdaExpression ktLambda) {
        Intrinsics.checkNotNullParameter(ktLambda, "ktLambda");
        KtFunctionLiteral ktFunctionLiteral = ktLambda.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue(ktFunctionLiteral, "ktLambda.functionLiteral");
        KtFunctionLiteral ktFun = ktFunctionLiteral;
        IrType lambdaExpressionType = this.toIrType(GeneratorKt.getTypeInferredByFrontendOrFail(this, ktLambda));
        IrSimpleFunction irLambdaFunction = new FunctionGenerator(this.getContext()).generateLambdaFunctionDeclaration(ktFun);
        return new IrFunctionExpressionImpl(ktLambda.getStartOffset(), PsiUtilsKt.getEndOffset(ktLambda), lambdaExpressionType, irLambdaFunction, IrStatementOrigin.LAMBDA.INSTANCE);
    }

    @NotNull
    public final IrStatement generateFunction(@NotNull KtNamedFunction ktFun) {
        Intrinsics.checkNotNullParameter(ktFun, "ktFun");
        IrSimpleFunction irFun = this.generateFunctionDeclaration(ktFun);
        if (ktFun.getName() != null) {
            return irFun;
        }
        IrType funExpressionType = this.toIrType(GeneratorKt.getTypeInferredByFrontendOrFail(this, ktFun));
        return new IrFunctionExpressionImpl(PsiUtilsKt.getStartOffset(ktFun), PsiUtilsKt.getEndOffset(ktFun), funExpressionType, irFun, IrStatementOrigin.ANONYMOUS_FUNCTION.INSTANCE);
    }

    private final IrSimpleFunction generateFunctionDeclaration(KtNamedFunction ktFun) {
        return new FunctionGenerator(this.getContext()).generateFunctionDeclaration(ktFun, IrDeclarationOrigin.LOCAL_FUNCTION.INSTANCE);
    }
}

