/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.io.Reader;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0000H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocationWithSource;", "file", "", "startLine", "", "startChar", "(Ljava/lang/String;II)V", "getFile", "()Ljava/lang/String;", "identityObject", "", "getIdentityObject", "()Ljava/lang/Object;", "sourceProvider", "Lkotlin/Function0;", "Ljava/io/Reader;", "getSourceProvider", "()Lkotlin/jvm/functions/Function0;", "getStartChar", "()I", "getStartLine", "asSimpleLocation", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "js.ast"})
public final class JsLocation
implements JsLocationWithSource {
    @NotNull
    private final String file;
    private final int startLine;
    private final int startChar;
    @Nullable
    private final Object identityObject;
    @NotNull
    private final Function0<Reader> sourceProvider;

    public JsLocation(@NotNull String file2, int startLine, int startChar) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.file = file2;
        this.startLine = startLine;
        this.startChar = startChar;
        this.sourceProvider = sourceProvider.1.INSTANCE;
    }

    @Override
    @NotNull
    public String getFile() {
        return this.file;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getStartChar() {
        return this.startChar;
    }

    @Override
    @Nullable
    public Object getIdentityObject() {
        return this.identityObject;
    }

    @Override
    @NotNull
    public Function0<Reader> getSourceProvider() {
        return this.sourceProvider;
    }

    @Override
    @NotNull
    public JsLocation asSimpleLocation() {
        return this;
    }

    @NotNull
    public final String component1() {
        return this.getFile();
    }

    public final int component2() {
        return this.getStartLine();
    }

    public final int component3() {
        return this.getStartChar();
    }

    @NotNull
    public final JsLocation copy(@NotNull String file2, int startLine, int startChar) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return new JsLocation(file2, startLine, startChar);
    }

    public static /* synthetic */ JsLocation copy$default(JsLocation jsLocation, String string2, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string2 = jsLocation.getFile();
        }
        if ((n3 & 2) != 0) {
            n = jsLocation.getStartLine();
        }
        if ((n3 & 4) != 0) {
            n2 = jsLocation.getStartChar();
        }
        return jsLocation.copy(string2, n, n2);
    }

    @NotNull
    public String toString() {
        return "JsLocation(file=" + this.getFile() + ", startLine=" + this.getStartLine() + ", startChar=" + this.getStartChar() + ')';
    }

    public int hashCode() {
        int result2 = this.getFile().hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.getStartLine());
        result2 = result2 * 31 + Integer.hashCode(this.getStartChar());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsLocation)) {
            return false;
        }
        JsLocation jsLocation = (JsLocation)other;
        if (!Intrinsics.areEqual(this.getFile(), jsLocation.getFile())) {
            return false;
        }
        if (this.getStartLine() != jsLocation.getStartLine()) {
            return false;
        }
        return this.getStartChar() == jsLocation.getStartChar();
    }
}

