/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.FqNameExternalizer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ClassIdExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/name/ClassId;", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "classId", "kotlin-build-common"})
public final class ClassIdExternalizer
implements DataExternalizer<ClassId> {
    @NotNull
    public static final ClassIdExternalizer INSTANCE = new ClassIdExternalizer();

    private ClassIdExternalizer() {
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(classId, "classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "classId.packageFqName");
        FqNameExternalizer.INSTANCE.save(output, fqName2);
        FqName fqName3 = classId.getRelativeClassName();
        Intrinsics.checkNotNullExpressionValue(fqName3, "classId.relativeClassName");
        FqNameExternalizer.INSTANCE.save(output, fqName3);
        output.writeBoolean(classId.isLocal());
    }

    @Override
    @NotNull
    public ClassId read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        return new ClassId(FqNameExternalizer.INSTANCE.read(input), FqNameExternalizer.INSTANCE.read(input), input.readBoolean());
    }
}

