/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractProviderBasedScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirImportingScopeFilter;
import org.jetbrains.kotlin.fir.scopes.impl.FirObjectImportedCallableScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0004J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ4\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001f0!H\u0004J8\u0010#\u001a\u00020\u001f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0016\u0010 \u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030$\u0012\u0004\u0012\u00020\u001f0!H\u0004J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u0006\u0012\u0002\b\u00030\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010*\u0006\u0012\u0002\b\u00030\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractImportingScope;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractProviderBasedScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "filter", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirImportingScopeFilter;", "lookupInFir", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/scopes/impl/FirImportingScopeFilter;Z)V", "getFilter", "()Lorg/jetbrains/kotlin/fir/scopes/impl/FirImportingScopeFilter;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "fullyExpandedSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getFullyExpandedSymbol", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "findSingleClassifierSymbolByName", "name", "Lorg/jetbrains/kotlin/name/Name;", "imports", "", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "getStaticsScope", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "processFunctionsByName", "", "processor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "providers"})
public abstract class FirAbstractImportingScope
extends FirAbstractProviderBasedScope {
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final FirImportingScopeFilter filter;

    public FirAbstractImportingScope(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull FirImportingScopeFilter filter2, boolean lookupInFir) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter((Object)filter2, "filter");
        super(session2, lookupInFir);
        this.scopeSession = scopeSession;
        this.filter = filter2;
    }

    @NotNull
    protected final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @NotNull
    protected final FirImportingScopeFilter getFilter() {
        return this.filter;
    }

    private final FirClassSymbol<?> getFullyExpandedSymbol(FirClassLikeSymbol<?> $this$fullyExpandedSymbol) {
        FirClassSymbol<Object> firClassSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = $this$fullyExpandedSymbol;
        if (firClassLikeSymbol instanceof FirTypeAliasSymbol) {
            Object object = FirDeclarationUtilKt.getExpandedConeType((FirTypeAlias)((FirTypeAliasSymbol)$this$fullyExpandedSymbol).getFir());
            firClassSymbol = object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null && (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, this.getSession())) != null ? this.getFullyExpandedSymbol((FirClassLikeSymbol<?>)object) : null;
        } else if (firClassLikeSymbol instanceof FirClassSymbol) {
            firClassSymbol = (FirClassSymbol<?>)$this$fullyExpandedSymbol;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firClassSymbol;
    }

    private final FirContainingNamesAwareScope getStaticsScope(FirClassSymbol<?> $this$getStaticsScope) {
        return ((FirClass)$this$getStaticsScope.getFir()).getClassKind() == ClassKind.OBJECT ? (FirContainingNamesAwareScope)new FirObjectImportedCallableScope($this$getStaticsScope.getClassId(), FirKotlinScopeProviderKt.unsubstitutedScope((FirClass)$this$getStaticsScope.getFir(), this.getSession(), this.scopeSession, false)) : ((FirClass)$this$getStaticsScope.getFir()).getScopeProvider().getStaticScope((FirClass)$this$getStaticsScope.getFir(), this.getSession(), this.scopeSession);
    }

    @Nullable
    public final FirContainingNamesAwareScope getStaticsScope(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        FirClassLikeSymbol<?> firClassLikeSymbol = this.getProvider().getClassLikeSymbolByClassId(classId);
        return firClassLikeSymbol != null && (firClassLikeSymbol = this.getFullyExpandedSymbol(firClassLikeSymbol)) != null ? this.getStaticsScope((FirClassSymbol<?>)firClassLikeSymbol) : null;
    }

    @Nullable
    protected final FirClassLikeSymbol<?> findSingleClassifierSymbolByName(@Nullable Name name, @NotNull List<? extends FirResolvedImport> imports) {
        Intrinsics.checkNotNullParameter(imports, "imports");
        FirClassLikeSymbol<?> result2 = null;
        for (FirResolvedImport firResolvedImport : imports) {
            FirClassLikeSymbol<?> firClassLikeSymbol;
            FirClassLikeSymbol<?> symbol2;
            Name name2 = name;
            if (name2 == null && (name2 = firResolvedImport.getImportedName()) == null) continue;
            Name importedName = name2;
            ClassId classId = firResolvedImport.getResolvedParentClassId();
            if (classId == null || (classId = classId.createNestedClassId(importedName)) == null) {
                classId = ClassId.topLevel(firResolvedImport.getPackageFqName().child(importedName));
            }
            Intrinsics.checkNotNullExpressionValue(classId, "import.resolvedParentCla\u2026Name.child(importedName))");
            ClassId classId2 = classId;
            if (this.getProvider().getClassLikeSymbolByClassId(classId2) == null || !this.filter.check(symbol2, this.getSession())) continue;
            if (result2 == null || Intrinsics.areEqual(result2, symbol2)) {
                firClassLikeSymbol = symbol2;
            } else if (FirAbstractImportingScopeKt.access$isJvmOrNativeThrows(result2.getClassId()) && FirAbstractImportingScopeKt.access$isCommonThrows(symbol2.getClassId())) {
                firClassLikeSymbol = symbol2;
            } else if (FirAbstractImportingScopeKt.access$isCommonThrows(result2.getClassId()) && FirAbstractImportingScopeKt.access$isJvmOrNativeThrows(symbol2.getClassId())) {
                firClassLikeSymbol = result2;
            } else {
                return null;
            }
            result2 = firClassLikeSymbol;
        }
        return result2;
    }

    protected final void processFunctionsByName(@Nullable Name name, @NotNull List<? extends FirResolvedImport> imports, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor2) {
        Intrinsics.checkNotNullParameter(imports, "imports");
        Intrinsics.checkNotNullParameter(processor2, "processor");
        if (this.filter == FirImportingScopeFilter.INVISIBLE_CLASSES) {
            return;
        }
        for (FirResolvedImport firResolvedImport : imports) {
            FirContainingNamesAwareScope staticsScope;
            FirContainingNamesAwareScope firContainingNamesAwareScope;
            Name name2 = name;
            if (name2 == null && (name2 = firResolvedImport.getImportedName()) == null) continue;
            Name importedName = name2;
            if (firResolvedImport.getResolvedParentClassId() != null) {
                ClassId p0;
                boolean bl = false;
                firContainingNamesAwareScope = this.getStaticsScope(p0);
            } else {
                firContainingNamesAwareScope = staticsScope = null;
            }
            if (staticsScope != null) {
                staticsScope.processFunctionsByName(importedName, processor2);
                continue;
            }
            if (!importedName.isSpecial()) {
                String string2 = importedName.getIdentifier();
                Intrinsics.checkNotNullExpressionValue(string2, "importedName.identifier");
                if (!(((CharSequence)string2).length() > 0)) continue;
            }
            for (FirNamedFunctionSymbol symbol2 : this.getProvider().getTopLevelFunctionSymbols(firResolvedImport.getPackageFqName(), importedName)) {
                PhaseUtilsKt.ensureResolvedForCalls(symbol2);
                processor2.invoke(symbol2);
            }
        }
    }

    protected final void processPropertiesByName(@Nullable Name name, @NotNull List<? extends FirResolvedImport> imports, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor2) {
        Intrinsics.checkNotNullParameter(imports, "imports");
        Intrinsics.checkNotNullParameter(processor2, "processor");
        if (this.filter == FirImportingScopeFilter.INVISIBLE_CLASSES) {
            return;
        }
        for (FirResolvedImport firResolvedImport : imports) {
            FirContainingNamesAwareScope staticsScope;
            FirContainingNamesAwareScope firContainingNamesAwareScope;
            Name name2 = name;
            if (name2 == null && (name2 = firResolvedImport.getImportedName()) == null) continue;
            Name importedName = name2;
            if (firResolvedImport.getResolvedParentClassId() != null) {
                ClassId p0;
                boolean bl = false;
                firContainingNamesAwareScope = this.getStaticsScope(p0);
            } else {
                firContainingNamesAwareScope = staticsScope = null;
            }
            if (staticsScope != null) {
                staticsScope.processPropertiesByName(importedName, processor2);
                continue;
            }
            if (!importedName.isSpecial()) {
                String string2 = importedName.getIdentifier();
                Intrinsics.checkNotNullExpressionValue(string2, "importedName.identifier");
                if (!(((CharSequence)string2).length() > 0)) continue;
            }
            for (FirPropertySymbol symbol2 : this.getProvider().getTopLevelPropertySymbols(firResolvedImport.getPackageFqName(), importedName)) {
                PhaseUtilsKt.ensureResolvedForCalls(symbol2);
                processor2.invoke(symbol2);
            }
        }
    }
}

