/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CheckDeclarationParentsVisitor;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrValidator;
import org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\b\u001a&\u0010\n\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"validateIrFile", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "validateIrModule", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "checkDeclarationParents", "reportIrValidationError", "message", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "ir.backend.common"})
public final class IrValidatorKt {
    public static final void validateIrFile(@NotNull CommonBackendContext context2, @NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        IrValidator visitor2 = new IrValidator(context2, new IrValidatorConfig(false, false, false, false, false, false, 60, null));
        IrElementVisitorVoidKt.acceptVoid(irFile, visitor2);
    }

    public static final void validateIrModule(@NotNull CommonBackendContext context2, @NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(irModule, "irModule");
        IrValidator visitor2 = new IrValidator(context2, new IrValidatorConfig(false, true, false, false, false, false, 60, null));
        IrElementVisitorVoidKt.acceptVoid(irModule, visitor2);
    }

    private static final void reportIrValidationError(CommonBackendContext $this$reportIrValidationError, String message, IrFile irFile, IrElement irElement) {
        try {
            UtilsKt.reportWarning($this$reportIrValidationError, "[IR VALIDATION] " + message, irFile, irElement);
        }
        catch (Throwable e) {
            System.out.println((Object)("an error trying to print a warning message: " + e));
            e.printStackTrace();
        }
    }

    public static final void checkDeclarationParents(@NotNull IrModuleFragment $this$checkDeclarationParents) {
        Intrinsics.checkNotNullParameter($this$checkDeclarationParents, "<this>");
        $this$checkDeclarationParents.accept(CheckDeclarationParentsVisitor.INSTANCE, null);
    }

    public static final /* synthetic */ void access$reportIrValidationError(CommonBackendContext $receiver, String message, IrFile irFile, IrElement irElement) {
        IrValidatorKt.reportIrValidationError($receiver, message, irFile, irElement);
    }
}

