/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExtensionProcessingHelper {
    public static <T> void forEachExtensionSafe(@NotNull Iterable<? extends T> iterable, @NotNull Consumer<? super T> extensionConsumer) {
        if (iterable == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(0);
        }
        if (extensionConsumer == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(1);
        }
        for (T t : iterable) {
            if (t == null) break;
            try {
                extensionConsumer.accept(t);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                ExtensionPointImpl.LOG.error(e);
            }
        }
    }

    @Nullable
    public static <T> T findFirstSafe(@NotNull Predicate<? super T> predicate, @NotNull Iterable<? extends T> iterable) {
        if (predicate == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(2);
        }
        if (iterable == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(3);
        }
        return (T)ExtensionProcessingHelper.computeSafeIfAny(o -> predicate.test(o) ? o : null, iterable);
    }

    @Nullable
    public static <T, R> R computeSafeIfAny(@NotNull Function<? super T, ? extends R> processor2, @NotNull Iterable<? extends T> iterable) {
        if (processor2 == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(4);
        }
        if (iterable == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(5);
        }
        for (T t : iterable) {
            if (t == null) {
                return null;
            }
            try {
                R result2 = processor2.apply(t);
                if (result2 == null) continue;
                return result2;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                ExtensionPointImpl.LOG.error(e);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 24: 
            case 33: 
            case 37: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 24: 
            case 33: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 20: 
            case 25: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheId";
                break;
            }
            case 8: 
            case 12: 
            case 17: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: 
            case 14: 
            case 19: 
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyMapper";
                break;
            }
            case 10: 
            case 24: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionProcessingHelper";
                break;
            }
            case 15: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMapper";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueProducer";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyMapperToCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionProcessingHelper";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getByGroupingKey";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "computeIfAbsent";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCacheForGroupingKeyMapper";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCacheForKeyMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forEachExtensionSafe";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFirstSafe";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeSafeIfAny";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getByGroupingKey";
                break;
            }
            case 10: 
            case 24: 
            case 33: 
            case 37: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getByKey";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "computeIfAbsent";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doGetByKey";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "buildCacheForGroupingKeyMapper";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "buildCacheForKeyMapper";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 24: 
            case 33: 
            case 37: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

