/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
** DLL.C - This is the ODBC sample driver code for
** LIBMAIN processing.
**
*/

#include "myodbc.h"
#include <locale.h>

char *default_locale, *decimal_point, *thousands_sep;
uint decimal_point_length,thousands_sep_length;
static bool myodbc_inited=0;

void myodbc_init(void)
{
  if (myodbc_inited)
    return;
  myodbc_inited=1;
  my_init();
  {
    struct lconv *tmp;
    DBUG_ENTER("myodbc_init");
#ifdef LOG_ALL
#ifdef _UNIX_
    DBUG_PUSH("d:t:S:O,/tmp/myodbc.log");
#else
    DBUG_PUSH("d:t:S:O,c::\\tmp\\myodbc.log");
#endif
#else
    if (getenv("MYODBC_LOG") != NULL)
      DBUG_PUSH(getenv("MYODBC_LOG"));
#endif
    init_getfunctions();
    default_locale=my_strdup(setlocale(LC_NUMERIC,NullS),MYF(0));
    setlocale(LC_NUMERIC,"");
    tmp=localeconv();
    decimal_point=my_strdup(tmp->decimal_point,MYF(0));
    decimal_point_length=strlen(decimal_point);
    thousands_sep=my_strdup(tmp->thousands_sep,MYF(0));
    thousands_sep_length=strlen(thousands_sep);
    setlocale(LC_NUMERIC,default_locale);
    DBUG_VOID_RETURN;
  }
}

#ifdef _WIN32
static int inited=0,threads=0;
HINSTANCE NEAR s_hModule;	/* Saved module handle */
int APIENTRY LibMain(HANDLE hInst,DWORD ul_reason_being_called,
		     LPVOID lpReserved)
{
  switch (ul_reason_being_called) {
  case DLL_PROCESS_ATTACH:	/* case of libentry call in win 3.x */
  if (!inited++)
  {
    s_hModule=hInst;
    myodbc_init();
  }
  break;
  case DLL_THREAD_ATTACH:
    threads++;
#ifdef THREAD
    my_thread_init();
#endif
    break;
  case DLL_PROCESS_DETACH:	/* case of wep call in win 3.x */
     if (!--inited)
     {
       my_free(decimal_point,MYF(0));
       my_free(default_locale,MYF(0));
       my_free(thousands_sep,MYF(0));
       my_end(0);
     }
    break;
  case DLL_THREAD_DETACH:
#ifdef THREAD
    if (threads && --threads)
      my_thread_end();		/* Last will be freed in my_end() */
#else
    --threads;
#endif
    break;
  default:
    break;
  } /* switch */

  return TRUE;

  UNREFERENCED_PARAMETER(lpReserved);
} /* LibMain */

int __stdcall DllMain(HANDLE hInst,DWORD ul_reason_being_called,LPVOID lpReserved)
{
  return LibMain(hInst,ul_reason_being_called,lpReserved);
}

#elif defined(__WIN__)

/****************************************************************************
**	This routine is called by LIBSTART.ASM at module load time.  All it
**	does in this sample is remember the DLL module handle.	The module
**	handle is needed if you want to do things like load stuff from the
**	resource file (for instance string resources).
****************************************************************************/

int _export FAR PASCAL libmain(HANDLE hModule,short cbHeapSize,
			       SQLCHAR FAR *lszCmdLine)
{
  s_hModule = hModule;
  myodbc_init();
  return TRUE;
}

#endif

#ifdef _WIN32
void __declspec( dllexport) FAR PASCAL LoadByOrdinal(void);
//	Entry point to cause DM to load using ordinals
void __declspec( dllexport) FAR PASCAL LoadByOrdinal(void)
{}
#endif
