// $Id: test_ATIS.java,v 1.1 1997/11/19 18:19:20 xzhu Exp $
// test_ATIS.java
//
// port from perl script 'test-ATIS'
//
// Author: Xiaokun Kelvin ZHU
// Address: kelvinxz@iname.com
// 1997/09/14
//
// Copyright (C) 1997, X.K.ZHU
//   The `test_ATIS.java' is free software and comes with NO WARRANTY of any
//   kind; you can redistribute it and/or modify it under the terms of the 
//   GNU Library General Public License as published by the Free Software 
//   Foundation; either version 2 of the License, or (at your option) any 
//   later version.
package bench;

import java.net.URL;
import java.sql.*;
import java.io.*;
import java.util.*;
import zxk.util.*;

public class test_ATIS implements DBugConstant
{
  // Change this to make test harder/easier
  // This is the default value for the count of records used in this test.
  private  int loopCount = 1000;

  private long second_orig;
  private InputStream myIn;

  private boolean skipCreate;
  private boolean skipIn;
  private boolean skipDelete;
  private boolean fastInsert;
  private boolean lockTables;
  private boolean fast;
  private String debugStr = null;

  private test_ATIS()
  {
    second_orig = -1;
    myIn = System.in;

    skipCreate = false;
    skipIn = false;
    skipDelete = false;
    fastInsert = false;
    lockTables = false;
    fast = false;
  }

  public void doit(String[] args)
  {
    String[] loName = { "fast", "fast_insert", "help", "host", "lock_tables",
      "password", "port", "skip_create", "skip_delete", "skip_in",
      "user", "debug" };
    int loHasArg[] = { GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.NO_ARG,
      GetOpt.REQ_ARG, GetOpt.NO_ARG, GetOpt.OPT_ARG, GetOpt.REQ_ARG,
      GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.REQ_ARG,
      GetOpt.REQ_ARG };
    int loValue[] = { 'F', 'i', '?', 'h', 'l', 'p', 'P', 
      'c', 'd', 's', 'u', '#' };
    GetOpt g = new GetOpt();
    g.setInputArgs(args);
    g.setShortOption("#:?cdsiFh:lp::P:u:");
    g.setLongOptionName(loName);
    g.setLongOptionHasArg(loHasArg);
    g.setLongOptionValue(loValue);
    g.setOptionMode(GetOpt.LONG_OPT);

    String host = null;
    String port = null;
    String user = null;
    String password = null;
    String database = new String("test");
    int c;
    boolean tty_password = false;
    boolean error = false;

    try
    {
      while ( (c=g.getopt()) != GetOpt.EOF)
      {
        switch(c)
        {
          case '#':
            debugStr = g.getOptarg();
            break;
	  case 'F':
	    fast = true;
	    break;
	  case 'i':
	    fastInsert = true;
	    break;
	  case 'l':
	    lockTables = true;
	    break;
	  case 'c':
	    skipCreate = true;
	    break;
	  case 'd':
	    skipDelete = true;
	    break;
	  case 's':
	    skipIn = true;
	    break;
          case 'h':
	    host = g.getOptarg();
	    break;
	  case 'p':
	    password = g.getOptarg();
	    if (password == null)
	      tty_password = true;
	    break;
	  case 'u':
	    user = g.getOptarg();
	    break;
	  case 'P':
	    port = g.getOptarg();
	    break;
	  default:
	    String s = new Character((char)c).toString();
	    System.err.println("Illegal option character '" + s + "'");
	  case '?':
	    error = true;
	    break;
        }
      }
    }
    catch (GetOptException e)
    {
      System.err.println(e.getMessage());
      error = true;
    }

    if (error)
    {
      System.out.println("Usage: java test_ATIS OPTIONS");
      System.out.println("\n" +
  "-#, --debug=opt      debug string, default is NO, see DBug.java for details\n" +
  "-?, --help		display this help and exit\n" + 
  "-c, --skip_create	skip create tables\n" +
  "-d, --skip_delete	skip delete tables\n" +
  "-F, --fast		fast load tables.\n" +
  "-h, --host=#		connect to host\n" +
  "-i, --fast_insert	fast insert record\n" +
  "-l, --lock_tables	lock table\n" + 
  "-p, --password=xxx	password to use when connecting to server\n" +
  "                     If password is not given it's asked from the tty.\n" +
  "-P  --port=...	Port number to use for connection\n" + 
  "-s, --skip_in	skip `IN' at the select sentence" +
  "-u, --user=#		user for login if not current user\n");
      System.exit(1);
    }

    if (tty_password)
      password = getTtyPassword();
    
    if (debugStr == null)
      debugStr = new String("");
    if (zxk_debug)
      DBug.dbug.dbPush(debugStr);

    Connection conn;
    int rows;
    int i;
    //
    // Connect and start timing
    //
    long zsec = System.currentTimeMillis();
    conn = executeConnect(host, port, user, password, database);
    Statement stmt = null;
    System.out.println("ATIS table test");
    try
    {
      stmt = conn.createStatement();
      if (!skipCreate)
      {
        //
        // Create needed tables
        //
        second_orig = System.currentTimeMillis();
	for (i=0; i<table_names.length; ++i)
	{
          String tableName = table_names[i];
	  String[] table = tables[i];
	  StringBuffer fieldsPart = new StringBuffer();
	  String prefix = "";
	  //
	  // This may fial if we have no table so ignore the SQLException
	  //
	  try 
	  { stmt.executeUpdate("drop table " + tableName);
	  } catch (SQLException e2) {}
	  for (int j=0; j<table.length; j+=2)
	  {
            fieldsPart.append(prefix + table[j] + ' ' + table[j+1]);
	    prefix = ", ";
	  }
	  if (debugStr.length() != 0)
	    System.out.println("Creating table " + tableName);
	  stmt.executeUpdate("create table " + tableName + "(" + fieldsPart.toString() + ")");
  	}
        System.out.println("Time to create_table " + tables.length + " tables: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      }
      //
      // Insert data
      //
      second_orig = System.currentTimeMillis();
      rows = 0;
      if (lockTables)
      {
	StringBuffer sb = new StringBuffer("LOCK TABLES ");
	for (int j=0; j<table_names.length-1; ++j)
	  sb.append(table_names[j] + " WRITE, ");
	sb.append(table_names[table_names.length-1] + "WRITE");
        stmt.executeUpdate(sb.toString());
      }
      Properties sysProps = System.getProperties();
      String curDir = sysProps.getProperty("user.dir");
      String fileSep = sysProps.getProperty("file.separator");
      if (fast)
      {
	for (int j=0; j<table_names.length; ++j)
	{
	  String tableName = table_names[j];
	  StringBuffer sb = new StringBuffer("load data infile '" + 
	    curDir + fileSep + "data-ATIS" + fileSep + tableName + 
	    ".txt' into table " + tableName + 
	    " columns optionally enclosed by '\"' terminated by ','");
	  if (debugStr.length() != 0)
	    System.out.println(sb.toString());
	  rows += stmt.executeUpdate(sb.toString());
	  if (debugStr.length() != 0)
	    System.out.println("Info for load of " + tableName + ": " + rows);
        }
      }
      else
      {
	for (i=0; i<table_names.length; ++i)
	{
	  String tableName = table_names[i];
	  String[] table = tables[i];
	  StringBuffer insStart = new StringBuffer("insert into "+tableName);
	  String prefix = "";
	  if (!fastInsert)
	  {
	    insStart.append(" (");
	    for (int j=0; j<table.length; j+=2)
	    {
	      String s = table[j];
	      if (!s.startsWith("PRIMARY KEY") &&
		  !s.startsWith("KEY") &&
		  !s.startsWith("UNIQUE") )
                insStart.append(prefix + s);
              prefix = ", ";
	    }
	    insStart.append(')');
	  }
	  insStart.append(" values (");
	  try
	  {
            BufferedReader in = new BufferedReader( new FileReader(
	      "data-ATIS" + fileSep + tableName + ".txt"));
	    String s;
	    while ((s = in.readLine()) != null)
	    {
              StringBuffer sb = new StringBuffer(insStart + s + ')'); 
	      if (debugStr.length() != 0)
	        System.out.println(sb.toString());
	      stmt.executeUpdate(sb.toString());
	      rows++;
	    }
	    in.close();
          }
	  catch(FileNotFoundException e) 
	  { 
	    System.out.println( "File Not Found:" + args[1]);
	    System.exit(1);
          } 
	  catch(IOException e) 
	  {
            System.out.println("IO Exception");
	    System.exit(1);
          }
	}
      }
      System.out.println("Time to insert " + rows + " rows: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      //
      // Delete the tables
      //
      second_orig = System.currentTimeMillis();
      if (!skipDelete)
      {
        stmt.executeUpdate("UNLOCK TABLES");
      }
      for (i=0; i<table_names.length; ++i)
      {
        String tableName = table_names[i];
	stmt.executeUpdate("drop table " + tableName);
      }
      System.out.println("Time to drop_table " + table_names.length + " tables: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
    }
    catch (SQLException e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
    catch (Exception e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
    executeClose(conn);

    // End of the test 
    // Finally print time used to execute the whole test
    System.out.println("Toal time: " + (System.currentTimeMillis() - zsec)/1000.0 + " sec.");
  }

  private Connection executeConnect(String host, String port, String user, 
    String password, String database)
  {
    boolean specialVersion = false;
    try
    {
      Class.forName ("gwe.sql.gweMysqlDriver");

      StringBuffer bufferURL = new StringBuffer();
      bufferURL.append("jdbc:mysql:");
      if (host != null && host.length() != 0)
      {
        bufferURL.append("//" + host);
        if (port != null && port.length() != 0)
          bufferURL.append(":" + port + "/");
        else
          bufferURL.append("/");
      }
      else if (port != null && port.length() != 0)
      {
        bufferURL.append("//localhost:" + port + "/");
      }
      bufferURL.append(database);
      if (user == null || user.length() == 0)
        user = System.getProperty("user.name");
      bufferURL.append("?user=" + user);
      if (password == null)
        password = "";
      bufferURL.append(";password=" + password);
      String url = new String(bufferURL);
//System.out.println(url);

      return DriverManager.getConnection (url);
    } 
    catch (SQLException e) 
    {
      System.out.println (e.getMessage ());
      System.exit(1);
    } 
    catch (Exception e)
    { 
      e.printStackTrace(); 
      System.exit(1);
    }
    return null;
  }

  private void executeClose(Connection conn)
  {
    try
    {
      conn.close();
    } 
    catch (SQLException e)
    { 
      e.printStackTrace();
      System.exit(1);
    }
    /* System.out.println("wait for 10 sec for closing...");
    try
    {
          Thread.sleep(10000);
    } catch (InterruptedException e) {}
    */
  }

  private int displayResult(ResultSet rs)
    throws SQLException
  {               
    int i;          
    int rows = 0;
    ResultSetMetaData rsmd = rs.getMetaData ();
    int numCols = rsmd.getColumnCount ();
        
    try 
    {
    boolean hasMore = rs.next();
    if (hasMore)
    {
      // Display column headings
      System.out.print("|");
      for (i=1; i<=numCols; i++) 
      {
        System.out.print(rsmd.getColumnName(i));
        System.out.print("\t|");
      }
      System.out.println("");
      // Display data, fetching until end of the result set
      while (hasMore) 
      {          
        rows++;    
        System.out.print("|");
        for (i=1; i<=numCols; i++) 
        {
          System.out.print(rs.getString(i));
  	System.out.print("\t|");
        }
        System.out.println("");
	hasMore = rs.next();
      }
    }       
    } 
    catch (SQLException e)
    { throw e; }

    return rows;
  }       

  private String readLine()
  {
    StringBuffer line = new StringBuffer();
    int in = -1;
    
    try
    {
      while ( (in = myIn.read()) != 10 && in != 13 && in != -1)
      {
	//String s = new Character((char)in).toString();
        //System.out.print(" " + s);
        line.append(new Character((char)in));
      }
    } catch (IOException e)
    { e.printStackTrace(); }
    
    if (line.length() == 0 && in == -1)
      return null;
    return line.toString();
  }

  private String getTtyPassword()
  {
    System.out.print("Password:");
    return readLine();
  }

  public static void main (String[] args) 
  {
    test_ATIS admin = new test_ATIS();
    admin.doit(args);
  }

  private static String[] aircraft = {
    "aircraft_code", "char(3) NOT NULL",
    "aircraft_type", "char(64)",
    "engines", "tinyint(1)",
    "category", "char(10)",
    "wide_body", "char(3)",
    "wing_span", "float(6,2)",
    "length", "float(6,2)",
    "weight", "integer(7)",
    "capacity", "smallint(3)",
    "pay_load", "integer(7)",
    "cruising_speed", "mediumint(5)",
    "range_miles", "mediumint(5)",
    "pressurized", "char(3)",
    "PRIMARY KEY", "(aircraft_code)"
  };
  private static String[] airline = {
    "airline_code", "char(2) NOT NULL",
    "airline_name", "char(64)",
    "note", "char(38)",
    "PRIMARY KEY", "(airline_code)"
  };
  private static String[] airport = {
    "airport_code", "char(3) NOT NULL",
    "airport_name", "char(40)",
    "location", "char(36)",
    "state_code", "char(2)",
    "country_name", "char(25)",
    "time_zone_code", "char(3)",
    "PRIMARY KEY", "(airport_code)"
  };
  private static String[] airport_service = {
    "city_code", "char(4) NOT NULL",
    "airport_code", "char(3) NOT NULL",
    "miles_distant", "float(4,1)",
    "direction", "char(3)",
    "minutes_distant", "smallint(3)",
    "PRIMARY KEY", "(city_code, airport_code)"
  };
  private static String[] city = {
    "city_code", "char(4) NOT NULL",
    "city_name", "char(25)",
    "state_code", "char(2)",
    "country_name", "char(25)",
    "time_zone_code", "char(3)",
    "PRIMARY KEY", "(city_code)"
  };
  private static String[] class_of_service = {
    "class_code", "char(2) NOT NULL",
    "rank", "tinyint(2)",
    "class_description", "char(80)",
    "PRIMARY KEY", "(class_code)"
  };
  private static String[] code_description = {
    "code", "char(5) NOT NULL",
    "description", "char(110)",
    "PRIMARY KEY", "(code)"
  };
  private static String[] compound_class = {
    "fare_class", "char(3) NOT NULL",
    "base_class", "char(2) NOT NULL",
    "class_type", "char(10) NOT NULL",
    "premium", "char(3) NOT NULL",
    "economy", "char(3) NOT NULL",
    "discounted", "char(3) NOT NULL",
    "night", "char(3) NOT NULL",
    "season_fare", "char(4) NOT NULL",
    "class_days", "char(7) NOT NULL",
    "PRIMARY KEY", "(fare_class)"
  };
  private static String[] connect_leg = {
    "connect_code", "integer(8) NOT NULL",
    "leg_number", "tinyint(1) NOT NULL",
    "flight_code", "integer(8)",
    "PRIMARY KEY", "(connect_code, leg_number, flight_code)"
  };
  private static String[] connection = {
    "connect_code", "integer(8) NOT NULL",
    "from_airport", "char(3)",
    "to_airport", "char(3)",
    "departure_time", "smallint(4)",
    "arrival_time", "smallint(4)",
    "flight_days", "char(7)",
    "stops", "tinyint(1)",
    "connections", "tinyint(1)",
    "time_elapsed", "smallint(4)",
    "PRIMARY KEY", "(connect_code)",
    "KEY", "(from_airport)",
    "KEY", "(to_airport)"
  };
  private static String[] day_name = {
    "day_code", "tinyint(1) NOT NULL",
    "day_name", "char(9)",
    "PRIMARY KEY", "(day_code)"
  };
  private static String[] dual_carrier = {
    "main_airline", "char(2) NOT NULL",
    "dual_airline", "char(2)",
    "low_flight", "smallint(4) NOT NULL",
    "high_flight", "smallint(4) NOT NULL",
    "connection_name", "char(64)",
    "PRIMARY KEY", "(main_airline, dual_airline, low_flight)",
    "KEY", "(main_airline)"
  };
  private static String[] fare = {
    "fare_code", "char(8) NOT NULL",
    "from_airport", "char(3) NOT NULL",
    "to_airport", "char(3) NOT NULL",
    "fare_class", "char(3) NOT NULL",
    "fare_airline", "char(2)",
    "restrict_code", "char(5)",
    "one_way_cost", "float(7,2)",
    "rnd_trip_cost", "float(8,2)",
    "PRIMARY KEY", "(fare_code)",
    "KEY", "(fare_code)",
    "KEY", "(from_airport)",
    "KEY", "(to_airport)"
  };
  private static String[] flight = {
    "flight_code", "integer(8) NOT NULL",
    "flight_days", "char(7)",
    "from_airport", "char(3)",
    "to_airport", "char(3)",
    "departure_time", "smallint(4)",
    "arrival_time", "smallint(4)",
    "airline_code", "char(2)",
    "flight_number", "smallint(4)",
    "class_string", "char(8)",
    "aircraft_code", "char(3)",
    "meal_code", "char(7)",
    "stops", "tinyint(1)",
    "dual_carrier", "char(1)",
    "time_elapsed", "smallint(4)",
    "PRIMARY KEY", "(flight_code)",
    "KEY", "(from_airport)",
    "KEY", "(to_airport)"
  };
  private static String[] flight_class = {
    "flight_code", "integer(8) NOT NULL",
    "fare_class", "char(3) NOT NULL",
    "PRIMARY KEY", "(flight_code, fare_class)"
  };
  private static String[] flight_day = {
    "day_mask", "char(7) NOT NULL",
    "day_code", "tinyint(1) NOT NULL",
    "day_name", "char(9)",
    "PRIMARY KEY", "(day_mask, day_code)"
  };
  private static String[] flight_fare = {
    "flight_code", "integer(8) NOT NULL",
    "fare_code", "char(8) NOT NULL",
    "PRIMARY KEY", "(flight_code, fare_code)"
  };
  private static String[] food_service = {
    "meal_code", "char(4) NOT NULL",
    "meal_number", "tinyint(1) NOT NULL",
    "meal_class", "char(10)",
    "meal_description", "char(10)",
    "PRIMARY KEY", "(meal_code, meal_number, meal_class)"
  };
  private static String[] ground_service = {
    "city_code", "char(4) NOT NULL",
    "airport_code", "char(3) NOT NULL",
    "transport_code", "char(1) NOT NULL",
    "ground_fare", "float(6,2)",
    "PRIMARY KEY", "(city_code, airport_code, transport_code)"
  };
  private static String[] time_interval = {
    "period", "char(20) NOT NULL",
    "begin_time", "smallint(4) NOT NULL",
    "end_time", "smallint(4) NOT NULL",
    "PRIMARY KEY", "(period, begin_time)"
  };
  private static String[] month_name = {
    "month_number", "tinyint(2) NOT NULL",
    "month_name", "char(9) NOT NULL",
    "PRIMARY KEY", "(month_number)"
  };
  private static String[] restrict_carrier = {
    "restrict_code", "char(5) NOT NULL",
    "airline_code", "char(2)",
    "PRIMARY KEY", "(restrict_code, airline_code)"
  };
  private static String[] restrict_class = {
    "restrict_code", "char(5) NOT NULL",
    "ex_fare_class", "char(12)",
    "PRIMARY KEY", "(restrict_code, ex_fare_class)"
  };
  private static String[] restriction = {
    "restrict_code", "char(5) NOT NULL",
    "application", "char(80)",
    "no_discounts", "char(80)",
    "reserve_ticket", "smallint(3)",
    "stopovers", "char(1)",
    "return_min", "smallint(3)",
    "return_max", "smallint(3)",
    "PRIMARY KEY", "(restrict_code)"
  };
  private static String[] state = {
    "state_code", "char(2) NOT NULL",
    "state_name", "char(25)",
    "country_name", "char(25)",
    "PRIMARY KEY", "(state_code)"
  };
  private static String[] stop = {
    "flight_code", "integer(8) NOT NULL",
    "stop_number", "tinyint(1) NOT NULL",
    "stop_flight", "integer(8)",
    "PRIMARY KEY", "(flight_code, stop_number)"
  };
  private static String[] time_zone = {
    "time_zone_code", "char(3) NOT NULL",
    "time_zone_name", "char(32) NOT NULL",
    "PRIMARY KEY", "(time_zone_code, time_zone_name)"
  };
  private static String[] transport = {
    "transport_code", "char(1) NOT NULL",
    "transport_description", "char(32)",
    "PRIMARY KEY", "(transport_code)"
  };

// Avoid not used warnings
  private static String[][] tables = {
    aircraft, airline, airport, airport_service,
    city, class_of_service, code_description,
    compound_class, connect_leg, connection, day_name,
    dual_carrier, fare, flight, flight_class, flight_day,
    flight_fare, food_service, ground_service, time_interval,
    month_name,
    restrict_carrier, restrict_class, restriction, state, stop,
    time_zone, transport
  };

  private static String[] table_names = {
    "aircraft", "airline", "airport", "airport_service",
    "city", "class_of_service", "code_description", 
    "compound_class", "connect_leg", "connection", "day_name",
    "dual_carrier", "fare", "flight", "flight_class", "flight_day",
    "flight_fare", "food_service", "ground_service", "time_interval",
    "month_name",
    "restrict_carrier", "restrict_class", "restriction", "state", "stop",
    "time_zone", "transport"
  };
}
